import sys
import subprocess
import os
import re
import shutil

pattern_valgrind_head = re.compile(r'==\d+==')
pattern_valgrind_tail = re.compile(r'==\d+== ERROR SUMMARY: [1-9]+')
pattern_valgrind_at = re.compile(r'==\d+== {4}at 0x\w+: ')
pattern_valgrind_by = re.compile(r'==\d+== {4}by 0x\w+: ')
invalid_cause_dict = dict()


def search_file(dirname):
    paths = []
    for root, dirs, files in os.walk(dirname):
        for file in files:
            print(file)
            if file.startswith("README"):
                continue
            else:
                path = os.path.join(root, file)
                paths.append(path)
    print(len(paths))
    return paths


def TIMEOUT_COMMAND(command, path, output_seeds_dirname, stdout, stderr):
    """call shell-command and either return its output or kill it
    if it doesn't normally exit within timeout seconds and return None"""
    process = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
    outs, errs = process.communicate()
    errs = str(errs, "utf-8", errors='ignore')
    outs = str(outs, "utf-8", errors='ignore')
    stdout.write(outs)
    err_data = ''
    search_at_count = 0
    search_by_count = 0
    error_cause = ''
    if pattern_valgrind_tail.search(errs):
        for i in errs.splitlines():
            if pattern_valgrind_at.match(i) is not None and search_at_count < 2:
                search_at_count += 1
                if search_at_count <= 1:
                    err_data = err_data + i + "\n"
                    _, end = pattern_valgrind_at.search(i).span()
                    error_cause += i[end:]
            elif pattern_valgrind_by.match(i) is not None and search_by_count <= 10 and search_at_count <= 1:
                search_by_count += 1
                err_data = err_data + i + "\n"
                _, end = pattern_valgrind_by.search(i).span()
                error_cause += i[end:]
            elif pattern_valgrind_tail.match(i) is not None:
                err_data = err_data + i + "\n"
                if not invalid_cause_dict.get(error_cause, None):
                    stderr.write(err_data)
                    # TODO write to mangodb
                    invalid_cause_dict[error_cause] = 1
                    if not os.path.exists(output_seeds_dirname):
                        os.makedirs(output_seeds_dirname)
                    shutil.copy2(path, output_seeds_dirname)
            elif pattern_valgrind_head.match(i) is not None:
                err_data = err_data + i + "\n"
            else:
                pass


def generation_command(target, parameter, paths, output_seeds_dirname, stdout_outputfile, stderr_outputfile):
    stdout_output = open(stdout_outputfile, "w+")
    stderr_output = open(stderr_outputfile, "w+")
    for path in paths:
        command = "valgrind " + target + " " + parameter.replace("@@", path, 1) + " "
        print(command)
        TIMEOUT_COMMAND(command, path, output_seeds_dirname, stdout_output, stderr_output)


def main(argv):
    target = argv[0]  # target program
    input_seeds_dirname = argv[1]  # input_seeds dir
    output_seeds_dirname = argv[2]  # output_seeds dir
    stdout_outputfile = argv[3]
    stderr_outputfile = argv[4]
    cmd = argv[5]
    print("Searching files\n")
    paths = search_file(input_seeds_dirname)
    generation_command(target, cmd, paths, output_seeds_dirname, stdout_outputfile, stderr_outputfile)


if __name__ == "__main__":
    main(sys.argv[1:])
