# encoding=utf-8
import os
import sys
import subprocess


def search_file(dirname):
    paths = []
    for root, dirs, files in os.walk(dirname):
        for file in files:
            print(file)
            if file.startswith("README"):
                continue
            else:
                path = os.path.join(root, file)
                paths.append(path)
    print(len(paths))
    return paths


def TIMEOUT_COMMAND(command, fl):
    """call shell-command and either return its output or kill it
    if it doesn't normally exit within timeout seconds and return None"""
    process = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
    for info in process.communicate():
        fl.write(info)


def generation_command(target, parameter, paths, outputfile):
    fl = open(outputfile, "w+")
    for path in paths:
        # print(path)
        command = target + " " + parameter.replace("@@", path, 1) + " "
        print(command)
        ret = TIMEOUT_COMMAND(command, fl)


# 启动服务
def service_on(service, port, conf_file, outputfile):
    command = service + " " + conf_file + " " + port
    print(command)
    process = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
    print("service on")
    return process


# 关闭服务
def service_off(process):
    process.kill()


def afl_replay(target, afl_replay_path, paths, protocol, port, conf_file, outputfile):
    fl = open(outputfile, "w+")
    for path in paths:
        process = service_on(target, port, conf_file, outputfile)
        command = afl_replay_path + " " + path + " " + protocol + " " + port
        print(command)
        # 使用afl-replay
        subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
        for info in process.communicate():
            try:
                fl.write(info.decode("utf-8"))
            except UnicodeDecodeError:
                fl.write(str(info))
        service_off(process)


def main(argv):
    target = argv[0]  # 被测程序
    conf_file = argv[1]  # 被测程序配置文件
    port = argv[2]  # 被测程序开放端口
    afl_replay_path = argv[3]  # afl_replay_path
    dirname = argv[4]  # seeds目录
    protocol = argv[5]  # 协议
    outputfile = argv[6]  # 输出文件
    print("Searching files\n")
    paths = search_file(dirname)
    afl_replay(target, afl_replay_path, paths, protocol, port, conf_file, outputfile)  # afl-replay


if __name__ == "__main__":
    main(sys.argv[1:])
