#include <stdint.h>
#include "guetzli/jpeg_data.h"
#include "guetzli/jpeg_data_reader.h"
#include "guetzli/processor.h"

extern "C" int test_func(const uint8_t *data, size_t size) {
  std::string jpeg_data(reinterpret_cast<const char*>(data), size);

  // Ignore large images, to prevent timeouts.
  guetzli::JPEGData jpg_header;
  if (!guetzli::ReadJpeg(data, size, guetzli::JPEG_READ_HEADER, &jpg_header)) {
    return 0;
  }
  static constexpr int kMaxPixels = 10000;
  if (static_cast<int64_t>(jpg_header.width) * jpg_header.height > kMaxPixels) {
    return 0;
  }

  // TODO(robryk): Use nondefault parameters.
  guetzli::Params params;
  std::string jpeg_out;
  (void)guetzli::Process(params, nullptr, jpeg_data, &jpeg_out);
  // TODO(robryk): Verify output distance if Process() succeeded.
  return 0;
}


int main(int argc, char *argv[]){
  if(argc==1){
    printf("%s\n", "usage");
    return 0;
  }

  char* file_path = argv[1];
  FILE *fp;
  if((fp=fopen(file_path, "rb")) == NULL){
    printf("cannot open file:%s\n", file_path);
    return 0;
  }

  fseek(fp, 0, SEEK_END);
  size_t file_len = ftell(fp);
  uint8_t *tmp = (uint8_t*)malloc(sizeof(uint8_t) * file_len);
  fseek(fp, 0, SEEK_SET);
  fread(tmp, file_len, sizeof(uint8_t), fp);
  fclose(fp);

  test_func(tmp, file_len);

  return 0;

}


