import sys
import subprocess
import os
import re
import shutil

pattern_asan_head = re.compile(r'==\d+==ERROR: AddressSanitizer:')
pattern_asan = re.compile(r' {4}#\d+ 0x\w+ in ')
pattern_asan_0 = re.compile(r' {4}#0 0x\w+ in ')
invalid_cause_dict = dict()


def search_file(dirname):
    paths = []
    for root, dirs, files in os.walk(dirname):
        for file in files:
            print(file)
            if file.startswith("README"):
                continue
            else:
                path = os.path.join(root, file)
                paths.append(path)
    print(len(paths))
    return paths


def TIMEOUT_COMMAND(command, path, output_seeds_dirname, stdout, stderr):
    """call shell-command and either return its output or kill it
    if it doesn't normally exit within timeout seconds and return None"""
    process = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
    outs, errs = process.communicate()
    errs = str(errs, "utf-8", errors='ignore')
    outs = str(outs, "utf-8", errors='ignore')
    stdout.write(outs)
    is_search_0 = False
    search_by_count = 0
    error_cause = ''
    if pattern_asan_head.search(errs) is not None:
        for i in errs.splitlines():
            if pattern_asan_0.match(i) is not None and not is_search_0:
                is_search_0 = True
                _, end = pattern_asan_0.search(i).span()
                error_cause += i[end:]
            elif pattern_asan.match(i) is not None and search_by_count <= 10:
                search_by_count += 1
                _, end = pattern_asan.search(i).span()
                error_cause += i[end:]
        if not invalid_cause_dict.get(error_cause, None):
            stderr.write(command)
            stderr.write("\r\n")
            stderr.write(errs)
            invalid_cause_dict[error_cause] = 1
            if not os.path.exists(output_seeds_dirname):
                os.makedirs(output_seeds_dirname)
            shutil.copy2(path, output_seeds_dirname)


def generation_command(target, parameter, paths, output_seeds_dirname, stdout_outputfile, stderr_outputfile):
    stdout_output = open(stdout_outputfile, "w+")
    stderr_output = open(stderr_outputfile, "w+")
    for path in paths:
        command = target + " " + parameter.replace("@@", path, 1) + " "
        print(command)
        TIMEOUT_COMMAND(command, path, output_seeds_dirname, stdout_output, stderr_output)


def main(argv):
    target = argv[0]
    input_seeds_dirname = argv[1]  # input_seeds dir
    output_seeds_dirname = argv[2]  # output_seeds dir
    stdout_outputfile = argv[3]
    stderr_outputfile = argv[4]
    cmd = argv[5]
    print("Searching files\n")
    paths = search_file(input_seeds_dirname)
    generation_command(target, cmd, paths, output_seeds_dirname, stdout_outputfile, stderr_outputfile)


if __name__ == "__main__":
    main(sys.argv[1:])
