package com.example.fuzzControll.tools;

import com.example.fuzzControll.conf.SpringContextUtil;
import com.example.fuzzControll.conf.seedProperties;
import org.springframework.web.multipart.MultipartFile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class fileTools {
    seedProperties properties = (seedProperties) SpringContextUtil.getBean("seedProperties");

    public void load(MultipartFile file) {
        try (InputStream inputStream = file.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(properties.getSeedPath() + "/" + file.getOriginalFilename());) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);

            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                bufferedOutputStream.write(buffer, 0, bytesRead);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
