package com.example.fuzzControll.tools;

import com.alibaba.fastjson.JSONObject;
import com.example.fuzzControll.conf.SpringContextUtil;
import com.example.fuzzControll.controller.WebSocket;
import com.example.fuzzControll.pojo.vo.cmdStartParams;
import com.example.fuzzControll.pojo.vo.testReturnEntity;

import java.io.*;

import java.util.ArrayList;
import java.util.List;

//todo need modify
public class cmdTools {
    Boolean send = false;
    WebSocket socket = (WebSocket) SpringContextUtil.getBean("WebSocket");

    /**
     * 运行不需要后台运行cmd
     */
    public List<String> runCmd(String cmd) {
        List<String> result = new ArrayList<>();
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            printMessage(process.getInputStream(), result);
            printMessage(process.getErrorStream(), new ArrayList<>());
            process.waitFor();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }

    //todo 不同协议种子路径也不同

    /**
     * 运行需要后台运行cmd
     * 通过websocket返回数据
     */
    public void runProgramCmd(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            printMessageToWeb(process.getInputStream(), process);
            printMessage(process.getErrorStream(), new ArrayList<>());
            process.waitFor();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 运行需要后台运行cmd
     * 将数据存入文件中
     */
    public void runProgramCmdAndResultTofile(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            printMessageToFile(process.getInputStream());
            printMessageToFile(process.getErrorStream());
            process.waitFor();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printMessageToFile(InputStream input) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                Reader reader = new InputStreamReader(input);
                BufferedReader bf = new BufferedReader(reader);
                String line = null;
                try {
                    while ((line = bf.readLine()) != null) {
                        System.out.println(line);
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

            }
        }).start();
    }

    private List<String> printMessage(final InputStream input, List<String> result) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                Reader reader = new InputStreamReader(input);
                BufferedReader bf = new BufferedReader(reader);
                String line = null;
                try {
                    while ((line = bf.readLine()) != null) {
                        result.add(line);
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }

            }
        }).start();
        return result;
    }

    private void printMessageToWeb(final InputStream input, Process process) throws IOException {

//        try (FileOutputStream outputStream = new FileOutputStream("/home/qbq/1.text");
//             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);) {
//
//            byte[] buffer = new byte[1024];
//            int bytesRead;
//            while ((bytesRead = input.read(buffer)) != -1) {
//                bufferedOutputStream.write(buffer, 0, bytesRead);
//            }
//            if (testControlTools.getIsRunning()) {
//                process.destroy();
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
        Reader reader = new InputStreamReader(input);
        BufferedReader bf = new BufferedReader(reader);
        String line = null;
        testReturnEntity returnEntity = new testReturnEntity();
        while ((line = bf.readLine()) != null && testControlTools.getIsRunning()) {
            makeReturnEntity(line, returnEntity);
            if (send) {
                String data = JSONObject.toJSONString(returnEntity);
                socket.appointSending("backend100", "web100", data);
                System.out.println(returnEntity + "*");
            }
        }
    }

    private testReturnEntity makeReturnEntity(String line, testReturnEntity returnEntity) {
        System.out.println(line);
        if (line.contains("run time")) {
            send = false;
            int run_time = line.indexOf(":");
            int cycles_done = line.indexOf("cycles done :");
            returnEntity.setRun_time(line.substring(run_time + 1, run_time + 30));
            returnEntity.setCycles_done(line.substring(cycles_done + 13, cycles_done + 18));
        } else if (line.contains("last new path")) {
            int last_new_path = line.indexOf(":");
            int total_paths = line.indexOf("total paths :");
            returnEntity.setLast_new_path(line.substring(last_new_path + 1, last_new_path + 30));
            returnEntity.setTotal_paths(line.substring(total_paths + 13, line.indexOf("total paths :") + 16));
        } else if (line.contains("last uniq crash")) {
            int last_uniq_crash = line.indexOf(":");
            int uniq_crashes = line.indexOf("uniq crashes :");
            returnEntity.setLast_uniq_crash(line.substring(last_uniq_crash + 1, last_uniq_crash + 30));
            returnEntity.setUniq_crashes(line.substring(uniq_crashes + 14, uniq_crashes + 19));
        } else if (line.contains("last uniq hang")) {
            int last_uniq_hang = line.indexOf(":");
            int uniq_hangs = line.indexOf("uniq hangs :");
            returnEntity.setLast_uniq_hang(line.substring(last_uniq_hang + 1, last_uniq_hang + 30));
            returnEntity.setUniq_hangs(line.substring(uniq_hangs + 12, uniq_hangs + 16));
        } else if (line.contains("now processing")) {
            int now_processing = line.indexOf(":");
            int map_density = line.indexOf("map density :");
            returnEntity.setNow_processing(line.substring(now_processing + 1, now_processing + 12));
            returnEntity.setMap_density(line.substring(map_density + 13, map_density + 25));
        } else if (line.contains("paths timed out")) {
            int paths_timed_out = line.indexOf(":");
            int count_coverage = line.indexOf("count coverage :");
            returnEntity.setPaths_timed_out(line.substring(paths_timed_out + 1, paths_timed_out + 12));
            returnEntity.setCount_coverage(line.substring(count_coverage + 16, count_coverage + 35));
        } else if (line.contains("now trying")) {
            int now_trying = line.indexOf(":");
            int favored_paths = line.indexOf("favored paths :");
            returnEntity.setNow_trying(line.substring(now_trying + 1, now_trying + 18));
            returnEntity.setFavored_paths(line.substring(favored_paths + 15, favored_paths + 28));
        } else if (line.contains("stage execs")) {
            int stage_execs = line.indexOf(":");
            int new_edges_on = line.indexOf("new edges on :");
            returnEntity.setStage_execs(line.substring(stage_execs + 1, stage_execs + 18));
            returnEntity.setNew_edges_on(line.substring(new_edges_on + 14, new_edges_on + 31));
        } else if (line.contains("total execs")) {
            int total_execs = line.indexOf(":");
            int total_crashes = line.indexOf("total crashes :");
            returnEntity.setTotal_execs(line.substring(total_execs + 1, total_execs + 5));
            returnEntity.setTotal_crashes(line.substring(total_crashes + 15, total_crashes + 31));
        } else if (line.contains("exec speed") && line.contains("total tmouts")) {
            int exec_speed = line.indexOf(":");
            int total_tmouts = line.indexOf("total tmouts :");
            returnEntity.setExec_speed(line.substring(exec_speed + 1, exec_speed + 25));
            returnEntity.setTotal_tmouts(line.substring(total_tmouts + 14, total_tmouts + 27));
        } else if (line.contains("bit flips")) {
            int bit_flips = line.indexOf(":");
            int levels = line.indexOf("levels :");
            returnEntity.setBit_flips(line.substring(bit_flips + 1, bit_flips + 18));
            returnEntity.setLevels(line.substring(levels + 8, levels + 12));
        } else if (line.contains("byte flips")) {
            int byte_flips = line.indexOf(":");
            int pending = line.indexOf("pending :");
            returnEntity.setByte_flips(line.substring(byte_flips + 1, byte_flips + 16));
            returnEntity.setPending(line.substring(pending + 9, pending + 12));
        } else if (line.contains("arithmetics")) {
            int arithmetics = line.indexOf(":");
            int pend_fav = line.indexOf("pend fav :");
            returnEntity.setArithmetics(line.substring(arithmetics + 1, arithmetics + 16));
            returnEntity.setPend_fav(line.substring(pend_fav + 10, pend_fav + 16));
        } else if (line.contains("known ints")) {
            int known_ints = line.indexOf(":");
            int own_finds = line.indexOf("own finds :");
            returnEntity.setKnown_ints(line.substring(known_ints + 1, known_ints + 16));
            returnEntity.setOwn_finds(line.substring(own_finds + 11, own_finds + 14));
        } else if (line.contains("dictionary") && line.contains("imported")) {
            int dictionary = line.indexOf(":");
            int imported = line.indexOf("imported :");
            returnEntity.setDictionary(line.substring(dictionary + 1, dictionary + 16));
            returnEntity.setImported(line.substring(imported + 10, imported + 16));
        } else if (line.contains("havoc")) {
            int havoc = line.indexOf(":");
            int stability = line.indexOf("stability :");
            returnEntity.setHavoc(line.substring(havoc + 1, havoc + 18));
            returnEntity.setStability(line.substring(stability + 11, stability + 20));
        } else if (line.contains("trim")) {
            send = true;
            int trim = line.indexOf(":");
            returnEntity.setTrim(line.substring(trim + 1, trim + 10));
        }
        return returnEntity;
    }

    public String parse(cmdStartParams cmdStartParams) {
        StringBuilder cmd = new StringBuilder();
        if (cmdStartParams.getNetinfo() != "") {
            cmd.append(" -N " + cmdStartParams.getNetinfo());
        }
        if (cmdStartParams.getProtopcol() != "") {
            cmd.append(" -P " + cmdStartParams.getProtopcol());
        }
        if (cmdStartParams.getWaiting() != 0) {
            cmd.append(" -D " + cmdStartParams.getWaiting());
        }
        if (cmdStartParams.getNsname() != "") {
            cmd.append(" -e " + cmdStartParams.getNsname());
        }
        if (cmdStartParams.getKill()) {
            cmd.append(" -K ");
        }
        if (cmdStartParams.getAwareMode()) {
            cmd.append(" -E ");
        }
        if (cmdStartParams.getRegionMutationOperators()) {
            cmd.append(" -R ");
        }
        if (cmdStartParams.getFalseNegativeMode()) {
            cmd.append(" -F ");
        }
        if (cmdStartParams.getScript() != "") {
            cmd.append(" -c " + cmdStartParams.getScript());
        }
        if (cmdStartParams.getStateSelectionAlgo() != 0) {
            cmd.append(" -q " + cmdStartParams.getStateSelectionAlgo());
        }
        if (cmdStartParams.getSeedSelectionAlgo() != 0) {
            cmd.append(" -s " + cmdStartParams.getSeedSelectionAlgo() + " ");
        }
        return cmd.toString();
    }
}