package com.example.fuzzControll.service.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.example.fuzzControll.conf.kittyProperties;
import com.example.fuzzControll.conf.seedProperties;
import com.example.fuzzControll.constents.protocolConstent;
import com.example.fuzzControll.pojo.vo.protocolGenerationEntity;
import com.example.fuzzControll.service.protocolTemplateService;
import com.example.fuzzControll.tools.cmdTools;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class protocolTemplateImpl implements protocolTemplateService {
    cmdTools cmdTools = new cmdTools();
    @Autowired
    kittyProperties kitty;

    @Override
    public void generation(protocolGenerationEntity protocolGeneration) {
        String cmd = parseParameters(protocolGeneration);
        cmdTools.runProgramCmdAndResultTofile(cmd);
    }

    public String parseParameters(protocolGenerationEntity protocolGeneration) {
        switch (protocolGeneration.getProtocolName().toLowerCase()) {
            case "arp":
                return arpCmd(protocolGeneration);
            case "bgp":
                return bgpCmd(protocolGeneration);
            case "dhcp":
                return dhcpCmd(protocolGeneration);
            case "dns":
                return dnsCmd(protocolGeneration);
            case "frp":
                return frpCmd(protocolGeneration);
            case "ftp":
                return ftpCmd(protocolGeneration);
            case "hdlc":
                return hdlcCmd(protocolGeneration);
            case "http_dos_qemu":
                return http_dos_qemuCmd(protocolGeneration);
            default:
                log.error("未知协议！[{}]", protocolGeneration.getProtocolName());
                return null;
        }
    }

    private String http_dos_qemuCmd(protocolGenerationEntity protocolGeneration) {
        String dst_ip = null;
        String port = null;
        try {
            dst_ip = protocolGeneration.getParamJson()[0];
            port = protocolGeneration.getParamJson()[1];
        } catch (Exception e) {
            log.error("http_dos_qemu参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.HTTP_DOS_QUMU + " -d " + dst_ip + " -p " + port;
    }

    private String hdlcCmd(protocolGenerationEntity protocolGeneration) {
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.HDLC;
    }

    private String ftpCmd(protocolGenerationEntity protocolGeneration) {
        String target_host = null;
        String target_port = null;
        try {
            target_host = protocolGeneration.getParamJson()[0];
            target_port = protocolGeneration.getParamJson()[1];
        } catch (Exception e) {
            log.error("frp参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.FTP + target_host + " " + target_port;
    }

    private String frpCmd(protocolGenerationEntity protocolGeneration) {
        String target_host = null;
        String target_port = null;
        try {
            target_host = protocolGeneration.getParamJson()[0];
            target_port = protocolGeneration.getParamJson()[1];
        } catch (Exception e) {
            log.error("frp参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.FRP + target_host + " " + target_port;
    }

    private String dnsCmd(protocolGenerationEntity protocolGeneration) {
        String dst_ip = null;
        String dst_port = null;
        try {
            dst_ip = protocolGeneration.getParamJson()[0];
            dst_port = protocolGeneration.getParamJson()[1];
        } catch (Exception e) {
            log.error("dns参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.DNS + dst_ip + " " + dst_port;
    }

    private String dhcpCmd(protocolGenerationEntity protocolGeneration) {
        String dst_ip = null;
        String dst_port = null;
        try {
            dst_ip = protocolGeneration.getParamJson()[0];
            dst_port = protocolGeneration.getParamJson()[1];
        } catch (Exception e) {
            log.error("dhcp参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.DHCP + dst_ip + " " + dst_port;
    }

    private String bgpCmd(protocolGenerationEntity protocolGeneration) {
        String src_ip = null;
        String src_port = null;
        String dst_ip = null;
        String dst_port = null;
        try {
            src_ip = protocolGeneration.getParamJson()[0];
            src_port = protocolGeneration.getParamJson()[1];
            dst_ip = protocolGeneration.getParamJson()[2];
            dst_port = protocolGeneration.getParamJson()[3];
        } catch (Exception e) {
            log.error("bgp参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.BGP + src_ip + " " + src_port + " " + dst_ip + " " + dst_port;
    }

    public String arpCmd(protocolGenerationEntity protocolGeneration) {
        String dst_mac = null;
        String src_mac = null;
        try {
            dst_mac = protocolGeneration.getParamJson()[0];
            src_mac = protocolGeneration.getParamJson()[1];
        } catch (Exception e) {
            log.error("arp参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getPath() + protocolConstent.RAW + dst_mac + " " + src_mac;
    }
}
