package com.example.fuzzControll.service.impl;

import com.example.fuzzControll.conf.kittyProperties;
import com.example.fuzzControll.pojo.vo.generateMethodEntity;
import com.example.fuzzControll.pojo.vo.protocolGenerationEntity;
import com.example.fuzzControll.service.generateMethodService;
import com.example.fuzzControll.tools.cmdTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class generateMethodServiceImpl implements generateMethodService {
    cmdTools cmdTools = new cmdTools();
    @Autowired
    kittyProperties kitty;

    @Override
    public void generation(generateMethodEntity generateMethodEntity) {
        String cmd = parseParameters(generateMethodEntity);
        cmdTools.runProgramCmdAndResultTofile(cmd);
    }

    public String parseParameters(generateMethodEntity generateMethodEntity) {
        switch (generateMethodEntity.getMethodName().toLowerCase()) {
            case "foreach":
                return foreachCmd(generateMethodEntity);
            default:
                log.error("未知变异方法！[{}]", generateMethodEntity.getMethodName());
                return null;
        }
    }

    private String foreachCmd(generateMethodEntity generateMethodEntity) {
        String target_host = null;
        String target_port = null;
        String s1 = null;
        String s2 = null;
        String s3 = null;
        try {
            target_host = generateMethodEntity.getParamJson()[0];
            target_port = generateMethodEntity.getParamJson()[1];
            s1 = generateMethodEntity.getParamJson()[2];
            s2 = generateMethodEntity.getParamJson()[3];
            s3 = generateMethodEntity.getParamJson()[4];
        } catch (Exception e) {
            log.error("http_dos_qemu参数解析失败！");
        }
        return kitty.getVenvPath() + " " + kitty.getMethodPath() + "generate_method_test.py -f " + s1 + " " + s2 + " " + s3+" --host="+target_host+" --port="+target_port;
    }
    //todo 还有很多生成方法
}
