package com.example.fuzzControll.controller;

import com.example.fuzzControll.pojo.vo.AjaxResult;
import com.example.fuzzControll.service.seedFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@RequestMapping("/seedFile")
public class seedFileController {

    @Autowired
    seedFileService service;

    /**
     * 种子文件查询接口
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public AjaxResult list() {
        List<String> files = null;
        try {
            files = service.getSeedFiles();
        } catch (Exception e) {
            return AjaxResult.error("种子文件获取失败！");
        }
        return AjaxResult.success(files);
    }

    /**
     * 种子文件删除接口
     */
    @RequestMapping(value = "/delete/{fileName}", method = RequestMethod.GET)
    public AjaxResult delete(@PathVariable("fileName")String fileName) {
        try {
            service.delFile(fileName);
        } catch (Exception e) {
            return AjaxResult.error("种子文件删除失败！");
        }
        return AjaxResult.success("种子文件删除成功！");
    }
    /**
     * seeFileUpload
     */
    @RequestMapping(value = "/upload", method = RequestMethod.POST)
    public AjaxResult upload(MultipartFile file) {
        try {
            service.upload(file);
        } catch (Exception e) {
            return AjaxResult.error("种子文件upload失败！");
        }
        return AjaxResult.success("种子文件upload成功！");
    }
}
