package com.example.fuzzControll.controller;


import org.springframework.stereotype.Component;

import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author
 */
@Component("WebSocket")
@ServerEndpoint("/websocket/testResult/{name}")
public class WebSocket {

    private Session session; //与某个客户端连接对话，通过此对客户端发送消息
    private static final ConcurrentHashMap<String, WebSocket> WEBSOCKET_CONCURRENTHASHMAP = new ConcurrentHashMap<>(); //存放所有连接的客户端


    @OnOpen
    public void onOpen(Session session, @PathParam(value = "name") String name) {
        this.session = session; //默认客户端，没有重名
        WEBSOCKET_CONCURRENTHASHMAP.put(name, this);
        System.out.println("【webSocket连接成功】当前连接人数为：" + WEBSOCKET_CONCURRENTHASHMAP.size() + "，此人为：" + name);
    }


    @OnClose
    public void onClose() {

        for (String name : WEBSOCKET_CONCURRENTHASHMAP.keySet()) {

            if (this == WEBSOCKET_CONCURRENTHASHMAP.get(name)) {

                WEBSOCKET_CONCURRENTHASHMAP.remove(name);
                break;
            }
        }


        System.out.println("【webSocket退出成功】当前连接人数为：" + WEBSOCKET_CONCURRENTHASHMAP.size());
    }

    @OnError
    public void onError(Session session, Throwable throwable) {

        System.out.println("error:");
        throwable.printStackTrace();
    }

    @OnMessage
    public void onMessage(Session session, String message) {

        System.out.println("【webSocket接收成功】内容为：" + message);  //此处可以指定发送，或者群发，或者xxxx的

        if (message.indexOf("name:") == 0) {

            String name = message.substring(message.indexOf("name") + 5, message.indexOf(";"));


            for (String senderStr : WEBSOCKET_CONCURRENTHASHMAP.keySet()) {//获取sender的Stirng

                if (WEBSOCKET_CONCURRENTHASHMAP.get(senderStr).getSession() == session) {

                    appointSending(senderStr, name, message.substring(message.indexOf(";") + 1));
                }
            }
        } else {

            groupSending(message, session);
        }
    }


    public void groupSending(String message, Session exIncludeSession) {

        for (String name : WEBSOCKET_CONCURRENTHASHMAP.keySet()) {

            try {
                if (exIncludeSession == WEBSOCKET_CONCURRENTHASHMAP.get(name).session) {
                    continue;
                }

                WEBSOCKET_CONCURRENTHASHMAP.get(name).session.getBasicRemote().sendText(name + ":" + message);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    public void appointSending(String sender, String name, String message) {

        try {
//            WEBSOCKET_CONCURRENTHASHMAP.get(name).session.getBasicRemote().sendText(sender + ":" + message);
            WEBSOCKET_CONCURRENTHASHMAP.get(name).session.getBasicRemote().sendText(message);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Session getSession() {
        return session;
    }
}