#!/usr/bin/env python
from __future__ import print_function
import os
import sys
import shutil
from distutils.core import setup

# Python2/3 compliance
try:
	raw_input
except:
	raw_input = input

def warning(lines, terminate=True, prompt=True):
	WIDTH = 115

	if not IGNORE_WARNINGS:
		print("\n" + "*" * WIDTH)
		for line in lines:
			print(line)
		print("*" * WIDTH, "\n")

		if prompt:
			if raw_input('Continue installation anyway (Y/n)? ').lower().startswith('n'):
				terminate = True
			else:
				terminate = False

		if terminate:
			sys.exit(1)
		
# This is super hacky.
if "--yes" in sys.argv:
	sys.argv.pop(sys.argv.index("--yes"))
	IGNORE_WARNINGS = True
else:
	IGNORE_WARNINGS = False

# Look for old installations of binwalk and remove them to prevent conflicts with the new API
try:
	import binwalk
	for path in binwalk.__path__:
		if not os.path.exists(os.path.join(path, "core")):
			try:
				print ("Cleaning up old installation...")
				shutil.rmtree(path)
			except:
				pass
except:
	pass

# Change to the binwalk src directory
os.chdir(os.path.join(os.path.dirname(os.path.realpath(__file__)), "src"))

print("checking pre-requisites")
try:
	import magic
	try:
		magic.MAGIC_NO_CHECK_TEXT
	except Exception as e:
		msg = ["Pre-requisite failure: " + str(e),
			"It looks like you have an old or incompatible magic module installed.",
			"Please install the official python-magic module, or download and install it from source: ftp://ftp.astron.com/pub/file/"
		]
		
		warning(msg)
except Exception as e:
	msg = ["Pre-requisite failure:", str(e),
		"Please install the python-magic module, or download and install it from source: ftp://ftp.astron.com/pub/file/",
	]
	
	warning(msg)

try:
	import pyqtgraph
except Exception as e:
	msg = ["Pre-requisite check warning: " + str(e),
		"To take advantage of this tool's graphing capabilities, please install the pyqtgraph module.",
	]
	
	warning(msg, prompt=True)

# Build / install C compression libraries
c_lib_dir = os.path.join(os.path.dirname(os.path.realpath(__file__)), "C")
c_lib_makefile = os.path.join(c_lib_dir, "Makefile")

working_directory = os.getcwd()
os.chdir(c_lib_dir)
status = 0

if not os.path.exists(c_lib_makefile):
	status |= os.system("./configure")

status |= os.system("make")

if status != 0:
	msg = ["Build warning: failed to build compression libraries.",
		"Some plugins will not work without these libraries."
	]
	
	warning(msg, prompt=True)
elif "install" in sys.argv:
		if os.system("make install") != 0:
			msg = ["Install warning: failed to install compression libraries.",
				"Some plugins will not work without these libraries."
			]

			warning(msg, prompt=True)
		
os.chdir(working_directory)

# Generate a new magic file from the files in the magic directory
print("generating binwalk magic file")
magic_files = os.listdir("magic")
magic_files.sort()
fd = open("binwalk/magic/binwalk", "wb")
for magic in magic_files:
	fpath = os.path.join("magic", magic)
	if os.path.isfile(fpath):
		fd.write(open(fpath, "rb").read())
fd.close()

# The data files to install along with the binwalk module
install_data_files = ["magic/*", "config/*", "plugins/*", "modules/*", "core/*"]

# Install the binwalk module, script and support files
setup(	name = "binwalk",
	version = "2.0.0 beta",
	description = "Firmware analysis tool",
	author = "Craig Heffner",
	url = "https://github.com/devttys0/binwalk",

	requires = ["magic", "pyqtgraph"],
	packages = ["binwalk"],
	package_data = {"binwalk" : install_data_files},
	scripts = ["scripts/binwalk"],
)

