/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as    long as you use it under this license.

*/
rule apt_win32_dll_bergard_pgv_pvid_variant
{

    meta:
        copyright = "Fidelis Cybersecurity"
        reference = "http://www.threatgeek.com/2016/05/turbo-twist-two-64-bit-derusbi-strains-converge.html"
    strings:
        $ = "Accept:"
        $ = "User-Agent: %s"
        $ = "Host: %s:%d"
        $ = "Cache-Control: no-cache"
        $ = "Connection: Keep-Alive"
        $ = "Cookie: pgv_pvid="
        $ = "Content-Type: application/x-octet-stream"
        $ = "User-Agent: %s"
        $ = "Host: %s:%d"
        $ = "Pragma: no-cache"
        $ = "Connection: Keep-Alive"
        $ = "HTTP/1.0"

    condition:

        (uint16(0) == 0x5A4D) and (all of them)
}
