
import "hash"
import "pe"


rule Mirai_Generic_Arch : MALW
{
	meta:
		description = "Mirai Botnet TR-069 Worm - Generic Architecture" 
		author = "Felipe Molina / @felmoltor"
		date = "2016-12-04"
		version = "1.0" 
		ref1 = "http://www.theregister.co.uk/2016/11/28/router_flaw_exploited_in_massive_attack/"	
		ref2 = "https://isc.sans.edu/forums/diary/Port+7547+SOAP+Remote+Code+Execution+Attack+Against+DSL+Modems/21759" 
		ref3 = "https://krebsonsecurity.com/2016/11/new-mirai-worm-knocks-900k-germans-offline/"

	strings:
		$miname = "Myname--is:"
		$iptables1 = "busybox iptables -A INPUT -p tcp --destination-port 7547 -j DROP"
		$iptables2 = "busybox iptables -A INPUT -p tcp --destination-port 5555 -j DROP"
		$procnet = "/proc/net/tcp"

	condition:
		$miname and $iptables1 and $iptables2 and $procnet
}

rule Mirai_MIPS_LSB : MALW
{
	meta:
		description = "Mirai Botnet TR-069 Worm - MIPS LSB" 
		author = "Felipe Molina / @felmoltor"
		date = "2016-12-04"
		version = "1.0" 
		MD5 = "bf650d39eb603d92973052ca80a4fdda"
		SHA1 = "03ecd3b49aa19589599c64e4e7a51206a592b4ef"
		ref1 = "http://www.theregister.co.uk/2016/11/28/router_flaw_exploited_in_massive_attack/"	
		ref2 = "https://isc.sans.edu/forums/diary/Port+7547+SOAP+Remote+Code+Execution+Attack+Against+DSL+Modems/21759" 
		ref3 = "https://krebsonsecurity.com/2016/11/new-mirai-worm-knocks-900k-germans-offline/"

	strings:
		$miname = "Myname--is:"
		$iptables1 = "busybox iptables -A INPUT -p tcp --destination-port 7547 -j DROP"
		$iptables2 = "busybox iptables -A INPUT -p tcp --destination-port 5555 -j DROP"
		$procnet = "/proc/net/tcp"

	condition:
		$miname and $iptables1 and $iptables2 and $procnet and
		hash.sha1(0,filesize) == "03ecd3b49aa19589599c64e4e7a51206a592b4ef"
}
rule Mirai_MIPS_MSB : MALW
{
	meta:
		description = "Mirai Botnet TR-069 Worm - MIPS MSB" 
		author = "Felipe Molina / @felmoltor"
		date = "2016-12-04"
		version = "1.0" 
		MD5 = "0eb51d584712485300ad8e8126773941"	
		SHA1 = "18bce2f0107b5fab1b0b7c453e2a6b6505200cbd"
		ref1 = "http://www.theregister.co.uk/2016/11/28/router_flaw_exploited_in_massive_attack/"	
		ref2 = "https://isc.sans.edu/forums/diary/Port+7547+SOAP+Remote+Code+Execution+Attack+Against+DSL+Modems/21759" 
		ref3 = "https://krebsonsecurity.com/2016/11/new-mirai-worm-knocks-900k-germans-offline/"

	strings:
		$miname = "Myname--is:"
		$iptables1 = "busybox iptables -A INPUT -p tcp --destination-port 7547 -j DROP"
		$iptables2 = "busybox iptables -A INPUT -p tcp --destination-port 5555 -j DROP"
		$procnet = "/proc/net/tcp"

	condition:
		$miname and $iptables1 and $iptables2 and $procnet and 
		hash.sha1(0,filesize) == "18bce2f0107b5fab1b0b7c453e2a6b6505200cbd"
}

rule Mirai_ARM_LSB : MALW
{
	meta:
		description = "Mirai Botnet TR-069 Worm - ARM LSB" 
		author = "Felipe Molina / @felmoltor"
		date = "2016-12-04"
		version = "1.0" 
		MD5= "eba670256b816e2d11f107f629d08494"
		SHA1 = "8a25dee4ea7d61692b2b95bd047269543aaf0c81"
		ref1 = "http://www.theregister.co.uk/2016/11/28/router_flaw_exploited_in_massive_attack/"	
		ref2 = "https://isc.sans.edu/forums/diary/Port+7547+SOAP+Remote+Code+Execution+Attack+Against+DSL+Modems/21759" 
		ref3 = "https://krebsonsecurity.com/2016/11/new-mirai-worm-knocks-900k-germans-offline/"

	strings:
		$miname = "Myname--is:"
		$iptables1 = "busybox iptables -A INPUT -p tcp --destination-port 7547 -j DROP"
		$iptables2 = "busybox iptables -A INPUT -p tcp --destination-port 5555 -j DROP"
		$procnet = "/proc/net/tcp"

	condition:
		$miname and $iptables1 and $iptables2 and $procnet and 
		hash.sha1(0,filesize) == "8a25dee4ea7d61692b2b95bd047269543aaf0c81"
}

rule Mirai_Renesas_SH : MALW
{
	meta:
		description = "Mirai Botnet TR-069 Worm - Renesas SH LSB" 
		author = "Felipe Molina / @felmoltor"
		date = "2016-12-04"
		version = "1.0" 
		MD5 = "863dcf82883c885b0686dce747dcf502"
		SHA1 = "bdc86295fad70480f0c6edcc37981e3cf11d838c"
		ref1 = "http://www.theregister.co.uk/2016/11/28/router_flaw_exploited_in_massive_attack/"	
		ref2 = "https://isc.sans.edu/forums/diary/Port+7547+SOAP+Remote+Code+Execution+Attack+Against+DSL+Modems/21759" 
		ref3 = "https://krebsonsecurity.com/2016/11/new-mirai-worm-knocks-900k-germans-offline/"

	strings:
		$miname = "Myname--is:"
		$iptables1 = "busybox iptables -A INPUT -p tcp --destination-port 7547 -j DROP"
		$iptables2 = "busybox iptables -A INPUT -p tcp --destination-port 5555 -j DROP"
		$procnet = "/proc/net/tcp"

	condition:
		$miname and $iptables1 and $iptables2 and $procnet and 
		hash.sha1(0,filesize) == "bdc86295fad70480f0c6edcc37981e3cf11d838c"
}
rule Mirai_PPC_Cisco : MALW
{
	meta:
		description = "Mirai Botnet TR-069 Worm - PowerPC or Cisco 4500" 
		author = "Felipe Molina / @felmoltor"
		date = "2016-12-04"
		version = "1.0" 
		MD5= "dbd92b08cbff8455ff76c453ff704dc6"
		SHA1 = "6933d555a008a07b859a55cddb704441915adf68"
		ref1 = "http://www.theregister.co.uk/2016/11/28/router_flaw_exploited_in_massive_attack/"	
		ref2 = "https://isc.sans.edu/forums/diary/Port+7547+SOAP+Remote+Code+Execution+Attack+Against+DSL+Modems/21759" 
		ref3 = "https://krebsonsecurity.com/2016/11/new-mirai-worm-knocks-900k-germans-offline/"

	strings:
		$miname = "Myname--is:"
		$iptables1 = "busybox iptables -A INPUT -p tcp --destination-port 7547 -j DROP"
		$iptables2 = "busybox iptables -A INPUT -p tcp --destination-port 5555 -j DROP"
		$procnet = "/proc/net/tcp"

	condition:
		( $miname and $iptables1 and $iptables2 and $procnet ) and 
		hash.sha1(0,filesize) == "6933d555a008a07b859a55cddb704441915adf68"
}

rule Mirai_SPARC_MSB : MALW
{
	meta:
		description = "Mirai Botnet TR-069 Worm - SPARC MSB" 
		author = "Felipe Molina / @felmoltor"
		date = "2016-12-04"
		version = "1.0" 
		MD5= "05891dbabc42a36f33c30535f0931555"
		SHA1 = "3d770480b6410cba39e19b3a2ff3bec774cabe47"
		ref1 = "http://www.theregister.co.uk/2016/11/28/router_flaw_exploited_in_massive_attack/"	
		ref2 = "https://isc.sans.edu/forums/diary/Port+7547+SOAP+Remote+Code+Execution+Attack+Against+DSL+Modems/21759" 
		ref3 = "https://krebsonsecurity.com/2016/11/new-mirai-worm-knocks-900k-germans-offline/"

	strings:
		$miname = "Myname--is:"
		$iptables1 = "busybox iptables -A INPUT -p tcp --destination-port 7547 -j DROP"
		$iptables2 = "busybox iptables -A INPUT -p tcp --destination-port 5555 -j DROP"
		$procnet = "/proc/net/tcp"

	condition:
		( $miname and $iptables1 and $iptables2 and $procnet ) and 
		hash.sha1(0,filesize) == "3d770480b6410cba39e19b3a2ff3bec774cabe47"
}
