/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as    long as you use it under this license.

*/

/*
	Yara Rule Set
	Author: YarGen Rule Generator
	Date: 2016-07-21
	Identifier: NBXC4L
	ref = http://pastebin.com/raw/FdrnPwae
*/

/* Rule Set ----------------------------------------------------------------- */

rule d4fe01ea13cf9926c2cf51d0ffbd78f9a110f4b9 {
	meta:
		description = "Auto-generated rule - file d4fe01ea13cf9926c2cf51d0ffbd78f9a110f4b9.codex"
		author = "YarGen Rule Generator"
		reference = "not set"
		date = "2016-07-21"
		hash1 = "d1dc9b2905264da34dc97d6c005810fbcc99be1a6b4b41f883bb179dbcacba6e"
	strings:
		$s1 = ":&:-:=:J:O:\\:m:r:" fullword ascii
		$s2 = "6)6/666;6N6W6^6c6t6y6" fullword ascii
		$s3 = "666Q6V6b6g6~6" fullword ascii
		$s4 = "0%0,010A0F0K0\\0a0f0w0|0" fullword ascii
		$s5 = "6!6(63686E6J6W6\\6i6n6{6" fullword ascii
		$s6 = "3 3%33383=3J3R3`3e3o3t3~3" fullword ascii
		$s7 = "4 4'40454:4G4M4R4_4e4j4w4" fullword ascii
		$s8 = "1#1(141=1B1N1T1Y1e1k1p1|1" fullword ascii
		$s9 = "?(?2?<?C?J?Q?X?_?f?m?t?{?" fullword ascii
		$s10 = "?#?*?1?8???F?M?T?[?b?i?p?w?" fullword ascii
		$s11 = "6)6/646@6F6K6W6]6b6n6w6|6" fullword ascii
		$s12 = "4#40454:4G4L4Q4^4c4h4u4z4" fullword ascii
		$s13 = "<\"<'<3<8<=<I<N<S<_<d<i<u<z<" fullword ascii
		$s14 = ">%>/>9>@>G>N>U>\\>c>j>q>" fullword ascii
		$s15 = "WTZDAE" fullword ascii
		$s16 = "060>0E0K0P0\\0b0g0v0|0" fullword ascii
		$s17 = "4#4-474A4K4U4\\4f4p4z4" fullword ascii
		$s18 = "7\"7,767@7J7T7^7h7q7{7" fullword ascii
		$s19 = ";\";';4;E;J;W;k;p;};" fullword ascii
		$s20 = ";0;;;F;Q;\\;g;r;};" fullword ascii

		$op0 = { a1 b8 63 44 00 83 c4 14 53 ff 75 14 56 57 ff 90 } /* Opcode */
		$op1 = { 8b d8 8b 45 08 8b 40 3a 81 c3 00 10 00 00 03 c3 } /* Opcode */
		$op2 = { 5c 2d 44 00 c7 84 24 c0 } /* Opcode */
	condition:
		( uint16(0) == 0x5a4d and filesize < 900KB and ( 10 of ($s*) )and 1 of ($op*) ) or ( all of them )
}

rule sig_7acb8d6d4c062c3097a7d31df103bc4d018519f9 {
	meta:
		description = "Auto-generated rule - file 7acb8d6d4c062c3097a7d31df103bc4d018519f9.codex"
		author = "YarGen Rule Generator"
		reference = "not set"
		date = "2016-07-21"
		hash1 = "e1607486cbb2d111d5df314fe58948aa0dc5897f56f7fd763c62bb30651380e3"
	strings:
		$s1 = "5(666Z6c6" fullword ascii
		$s2 = "Wlm;y%UD%d" fullword ascii
		$s3 = ";1;9;@;G;N;U;\\;c;j;q;x;" fullword ascii
		$s4 = "8 8'8.858<8C8J8Q8X8_8f8m8t8" fullword ascii
		$s5 = "2 2,282=2B2G2P2U2Z2_2h2s2x2" fullword ascii
		$s6 = "4'5.555<5C5J5Q5X5_5f5m5t5{5" fullword ascii
		$s7 = "0#0*01080?0F0M0T0[0b0i0p0w0" fullword ascii
		$s8 = "6$6,616=6B6G6S6X6]6i6n6s6" fullword ascii
		$s9 = "=\"=)=0=7=>=E=L=S=Z=a=h=" fullword ascii
		$s10 = "6&6-646;6B6I6P6W6^6e6l6s6z6" fullword ascii
		$s11 = "O.QrH@" fullword ascii
		$s12 = ">\">/>4>A>F>S>X>e>j>w>|>" fullword ascii
		$s13 = "0#0(040=0B0N0T0Y0e0k0p0|0" fullword ascii
		$s14 = "5)5/545@5F5K5W5`5e5q5w5|5" fullword ascii
		$s15 = "=!=&=3=8=E=N=S=`=e=s=x=}=" fullword ascii
		$s16 = ":(:/:6:=:D:K:R:Y:`:g:n:u:|:" fullword ascii
		$s17 = "7\"727<7F7M7W7a7k7u7" fullword ascii
		$s18 = "2+21262E2K2P2\\2h2m2|2" fullword ascii
		$s19 = ";/;5;:;G;V;\\;a;n;};" fullword ascii
		$s20 = ";\";-;8;C;N;^;i;t;" fullword ascii

		$op0 = { ff 44 24 14 8d 47 44 50 a1 08 63 44 00 ff 90 84 } /* Opcode */
		$op1 = { 6d 43 00 c7 84 24 10 03 00 00 0c 6d 43 00 c7 84 } /* Opcode */
		$op2 = { c7 43 0c 20 02 00 00 89 5d f0 ff 90 f8 } /* Opcode */
	condition:
		( uint16(0) == 0x5a4d and filesize < 900KB and ( 10 of ($s*) )and 1 of ($op*) ) or ( all of them )
}

rule sig_5783b35b2eace55a5762df27fcb0b0fb28371b3e {
	meta:
		description = "Auto-generated rule - file 5783b35b2eace55a5762df27fcb0b0fb28371b3e.codex"
		author = "YarGen Rule Generator"
		reference = "not set"
		date = "2016-07-21"
		hash1 = "72513534f2e0f3e77a22023b887df3718c9df70686eb0ae58cbbde2f90f447e4"
	strings:
		$s1 = "B+P:\\6" fullword ascii
		$s2 = "6.666K6S6d6l6}6" fullword ascii
		$s3 = "0!0&0+0<0A0F0W0\\0a0n0z0" fullword ascii
		$s4 = ";#;);.;:;@;E;Q;W;\\;h;q;v;" fullword ascii
		$s5 = "2#2-222F2L2W2\\2b2g2x2~2" fullword ascii
		$s6 = "9\"9)90979>9E9L9S9Z9k9}9" fullword ascii
		$s7 = "6-747;7B7I7P7W7^7e7l7s7z7" fullword ascii
		$s8 = "4\"4'43494>4J4P4U4a4g4l4x4" fullword ascii
		$s9 = ":#:(:4:::?:K:T:Y:e:k:p:|:" fullword ascii
		$s10 = "WD.hyA" fullword ascii
		$s11 = "<\"<)<0<7<><E<L<S<Z<a<h<" fullword ascii
		$s12 = "=&=,=1=>=D=I=V=_=d=q=w=|=" fullword ascii
		$s13 = "; ;(;0;8;@;H;P;X;`;h;p;{;" fullword ascii
		$s14 = "<\"<)<0<7<><E<L<S<Z<a<h<o<v<" fullword ascii
		$s15 = "6#6(616;6@6I6S6X6d6n6s6|6" fullword ascii
		$s16 = "(%r-c;u" fullword ascii
		$s17 = "3%3G3N3U3\\3c3j3q3x3" fullword ascii
		$s18 = "7\"767T7[7b7i7p7w7~7" fullword ascii
		$s19 = "1 1-1>1C1P1a1f1s1" fullword ascii
		$s20 = "8 8&8,8A8M8^8d8i8" fullword ascii

		$op0 = { e0 b3 42 00 c7 84 24 ac } /* Opcode */
		$op1 = { a1 e0 79 44 00 57 ff 75 1c ff 90 78 01 00 00 83 } /* Opcode */
		$op2 = { 3c ee 42 00 c7 84 24 8c } /* Opcode */
	condition:
		( uint16(0) == 0x5a4d and filesize < 900KB and ( 10 of ($s*) )and 1 of ($op*) ) or ( all of them )
}

rule sig_2fb404bdcebc7acbeb598f8a2ddbecf48c60b113 {
	meta:
		description = "Auto-generated rule - file 2fb404bdcebc7acbeb598f8a2ddbecf48c60b113.codex"
		author = "YarGen Rule Generator"
		reference = "not set"
		date = "2016-07-21"
		hash1 = "4f39d3e70ed1278d5fa83ed9f148ca92383ec662ac34635f7e56cc42eeaee948"
	strings:
		$s1 = ":%:0:;:F:Q:\\:p:|:" fullword ascii
		$s2 = "6.666>6F6N6V6^6f6n6v6~6" fullword ascii
		$s3 = "6!6(6/666=6D6K6R6Y6r6:7" fullword ascii
		$s4 = "1t83jL.bjG" fullword ascii
		$s5 = "6!61666V6]6p6" fullword ascii
		$s6 = "2%2D2P2`2p2|2" fullword ascii
		$s7 = "42494@4G4N4U4\\4c4j4q4x4" fullword ascii
		$s8 = "9+92999@9G9N9U9\\9c9j9q9x9" fullword ascii
		$s9 = "4!4&43484E4J4W4\\4i4n4s4" fullword ascii
		$s10 = "5$5+52595@5G5N5U5\\5c5j5q5" fullword ascii
		$s11 = "1.252<2C2J2Q2X2_2f2m2t2{2" fullword ascii
		$s12 = "8 8%818:8?8K8Q8V8b8h8m8y8" fullword ascii
		$s13 = "9'93989=9B9K9P9U9Z9c9n9s9" fullword ascii
		$s14 = ":\":':,:8:=:B:R:Z:`:e:v:}:" fullword ascii
		$s15 = "=#=(=4=:=?=K=Q=V=b=k=p=|=" fullword ascii
		$s16 = "= =*=1=8=?=F=M=T=[=b=i=p=w=~=" fullword ascii
		$s17 = "3&3-343;3B3I3P3W3^3e3l3s3z3" fullword ascii
		$s18 = ":!:(:/:6:=:I:N:S:`:f:k:x:~:" fullword ascii
		$s19 = "cMDkAjy=" fullword ascii
		$s20 = "=#=/=4=9=E=J=O=[=`=e=q=v={=" fullword ascii

		$op0 = { e0 b3 42 00 c7 84 24 ac } /* Opcode */
		$op1 = { 3c ee 42 00 c7 84 24 8c } /* Opcode */
		$op2 = { a1 e0 79 44 00 83 c4 0c ff 74 24 1c ff 90 3c 01 } /* Opcode */
	condition:
		( uint16(0) == 0x5a4d and filesize < 900KB and ( 10 of ($s*) )and 1 of ($op*) ) or ( all of them )
}

/* Super Rules ------------------------------------------------------------- */

rule _84b76d765e7357fa5402b5af97d351424a8edf03_d0f90c1b3ebd79a816b5597a49ae8257df697591_da24c17f75cf0b7d6c5ab01832a827ee4b4c52eb_0 {
	meta:
		description = "Auto-generated rule - from files 84b76d765e7357fa5402b5af97d351424a8edf03.codex, d0f90c1b3ebd79a816b5597a49ae8257df697591.codex, da24c17f75cf0b7d6c5ab01832a827ee4b4c52eb.codex"
		author = "YarGen Rule Generator"
		reference = "not set"
		date = "2016-07-21"
		super_rule = 1
		hash1 = "add7ed26bc5bcacdf3159fcde71bdd429feeef94dff7d3b22bc9af9deb471c48"
		hash2 = "a9a62edbafa5932894ed53319c924932b94a0ccdf15644764256eed39fd46d86"
		hash3 = "efcc9e0377cf83a73bd5fbe42a51a2330936b8e362fc2ab99af6d932079893d9"
	strings:
		$s1 = ":\":':,:5:=:B:K:P:U:^:c:h:q:v:{:" fullword ascii
		$s2 = "Y@.hdd \\" fullword ascii
		$s3 = "0$0+02090@0G0N0U0\\0c0j0v0{0" fullword ascii
		$s4 = "6\"6(6-6:6I6O6T6a6p6v6{6" fullword ascii
		$s5 = "1\"1/14191F1K1P1]1b1g1t1y1~1" fullword ascii
		$s6 = "0\"0(0-0<0B0G0S0_0d0s0y0~0" fullword ascii
		$s7 = "9\"9'959:9?9L9Q9^9c9p9y9~9" fullword ascii
		$s8 = "3%3*363=3B3N3T3Y3e3k3p3|3" fullword ascii
		$s9 = "4#4)4.4:4C4H4T4Z4_4k4q4v4" fullword ascii
		$s10 = "|&.WTm" fullword ascii
		$s11 = "6#63686E6J6W6\\6i6n6{6" fullword ascii
		$s12 = ";\";(;7;F;W;];f;o;{;" fullword ascii
		$s13 = "0+02080>0B0P0\\0i0|0" fullword ascii
		$s14 = "1 1(10181C1N1Y1d1o1z1" fullword ascii
		$s15 = "3 3%3*3;3@3E3R3^3c3t3y3" fullword ascii
		$s16 = "8\"8)8.8:8?8S8X8f8r8x8" fullword ascii
		$s17 = "8$8+82898@8G8N8U8\\8" fullword ascii
		$s18 = "9-929?9P9U9b9s9x9" fullword ascii
		$s19 = "9*9/9<9A9N9T9`9e9r9w9" fullword ascii
		$s20 = "2-292?2G2N2U2\\2c2j2q2" fullword ascii

		$op0 = { e0b34200c78424ac } /* Opcode */
		$op1 = { 39750c598bd0598955fc7e4b0fb64c3e } /* Opcode */
		$op2 = { 3cee4200c784248c } /* Opcode */
		$op3 = { a1a8794400681c40430057ff90400100 } /* Opcode */
		$op4 = { 395814eb31a1a879440057ff75f456ff } /* Opcode */
		$op5 = { 663bd875438bc62b450c8945fceb038b } /* Opcode */
		$op6 = { f24200c784245c01000010f24200c784 } /* Opcode */
		$op7 = { 83c4108944241c8d4424345056ff7424 } /* Opcode */
		$op8 = { 83c41483f8ff74138b4de88d04868b04 } /* Opcode */
		$op9 = { 7cb34200c784249c } /* Opcode */
		$op10 = { f8ae4300c78424e0 } /* Opcode */
		$op11 = { 08b44200c78424b8 } /* Opcode */
		$op12 = { 57568944241c50a1a8794400ff907801 } /* Opcode */
		$op13 = { e0174300c78424d8 } /* Opcode */
		$op14 = { 8b4dfc8b0481050410000050a1a87944 } /* Opcode */
		$op15 = { 595985c00f8586010000685c5a4300ff } /* Opcode */
		$op16 = { 595933c05e5f5bc9c3ff75c88b7508ff } /* Opcode */
		$op17 = { 28424400c78424c4 } /* Opcode */
		$op18 = { 83c4188945fc837dfc000f848f } /* Opcode */
		$op19 = { 895dbc895dfcff90f8 } /* Opcode */
		$op20 = { 595985c00f8543050000689c534300ff } /* Opcode */
		$op21 = { ff90bc0200003d220000c075408d4424 } /* Opcode */
		$op22 = { 383c4400c78424e0 } /* Opcode */
		$op23 = { 85c07495eb03885dffa1a879440057ff } /* Opcode */
		$op24 = { 6a01ff75acff75f46a00ff750ca1a879 } /* Opcode */
		$op25 = { 40af4300c784240001000048af4300c7 } /* Opcode */
		$op26 = { 836508005959668b4b02664966894802 } /* Opcode */
		$op27 = { ff75108bd8ff750ca1a879440068385e } /* Opcode */
		$op28 = { c4b34200c78424a8 } /* Opcode */
		$op29 = { dc404400c7842498 } /* Opcode */
		$op30 = { 30af4300c78424fc } /* Opcode */
		$op31 = { bfb025440057894df0ff90c402000059 } /* Opcode */
		$op32 = { 806a4300c78424f0 } /* Opcode */
		$op33 = { 80ee4200c784249c } /* Opcode */
		$op34 = { 1f4300c7842468020000141f4300c784 } /* Opcode */
		$op35 = { 68feff0000ff750889442428a1a87944 } /* Opcode */
		$op36 = { 897424688974246cff904803000085c0 } /* Opcode */
		$op37 = { 85c00f8495fdffffff742414a1a87944 } /* Opcode */
		$op38 = { 10184300c78424e8 } /* Opcode */
		$op39 = { ff75fca1a8794400576868c64300688c } /* Opcode */
		$op40 = { 59598945888b458cff308b458c83c004 } /* Opcode */
		$op41 = { 595985c00f85130700006860524300ff } /* Opcode */
		$op42 = { 603c4400c78424ec } /* Opcode */
		$op43 = { 8b450cff742414668378023f50a1a879 } /* Opcode */
		$op44 = { 595985c00f85fa010000680c5a4300ff } /* Opcode */
		$op45 = { fcf84200c78424c0 } /* Opcode */
		$op46 = { 14f94200c78424c8 } /* Opcode */
		$op47 = { 3c6a4300c78424e8 } /* Opcode */
		$op48 = { 88424400c78424d4 } /* Opcode */
		$op49 = { 83c4188945fc837dfc000f8404010000 } /* Opcode */
		$op50 = { 595985c00f8568020000ff75dca1a879 } /* Opcode */
		$op51 = { 8b463a0345fc50a1a8794400ff900404 } /* Opcode */
		$op52 = { 85c00f84cdfdffffff742414a1a87944 } /* Opcode */
		$op53 = { a1a879440056ff90a0 } /* Opcode */
		$op54 = { 40ae4300c78424b0 } /* Opcode */
		$op55 = { 83c40cff7588ff7508a1a8794400ff90 } /* Opcode */
		$op56 = { 68585c4300ff7588a1a8794400ff9090 } /* Opcode */
		$op57 = { 78274300c78424b0 } /* Opcode */
		$op58 = { 3d230000c0740b3d050000800f85c7 } /* Opcode */
		$op59 = { a1a879440068345f440057ff90f40300 } /* Opcode */
		$op60 = { 0fbf40483b45cc751d508b45e483c04c } /* Opcode */
		$op61 = { 836424180059598bd8c74424207cb542 } /* Opcode */
		$op62 = { 681c5c4300ff7588a1a8794400ff9090 } /* Opcode */
		$op63 = { 5c284300c78424f0 } /* Opcode */
		$op64 = { 59593bc3744a837dcc00741fff75f8a1 } /* Opcode */
		$op65 = { 60f94200c78424d8 } /* Opcode */
		$op66 = { 94274300c78424b8 } /* Opcode */
		$op67 = { 895c2440895c2444ff90c40300005959 } /* Opcode */
		$op68 = { 8bd859598d45ec50a1a87944008d7b02 } /* Opcode */
		$op69 = { ff90680100008bf08d45fc50a1a87944 } /* Opcode */
		$op70 = { a1a879440068e85e440057ff90f40300 } /* Opcode */
		$op71 = { ff45f88d474450a1a8794400ff909803 } /* Opcode */
		$op72 = { ff45f88d474450a1a8794400ff909803 } /* Opcode */
		$op73 = { 44b44200c78424d0 } /* Opcode */
		$op74 = { 595985c0754f6834584300ff75b8a1a8 } /* Opcode */
		$op75 = { 8b44242483c00450ff7508e824e6ffff } /* Opcode */
		$op76 = { 60404400c7842488 } /* Opcode */
		$op77 = { 6a1a4000c781a40100004eaa4100c781 } /* Opcode */
		$op78 = { 8bf859593bfe750433c0eb353975107e } /* Opcode */
		$op79 = { 59596a055e3bc775103935d479440075 } /* Opcode */
		$op80 = { 8975ec8975f0ff900c0300005f5e85c0 } /* Opcode */
		$op81 = { 8975ec8975f0ff900c0300005f5e85c0 } /* Opcode */
		$op82 = { 57ff75088945dca1a8794400ff90b8 } /* Opcode */
		$op83 = { 583b4400c7842488 } /* Opcode */
		$op84 = { 83c40c8b45fc8b4df489086881 } /* Opcode */
		$op85 = { 0c274300c7842490 } /* Opcode */
		$op86 = { 2c184300c78424f4 } /* Opcode */
		$op87 = { a1a879440068185f440057ff90f40300 } /* Opcode */
		$op88 = { ff7424148bf0a1a879440056ff90fc } /* Opcode */
		$op89 = { a1a87944006894e5430053ff9090 } /* Opcode */
		$op90 = { 8d44240c50a1a8794400ff90f8010000 } /* Opcode */
		$op91 = { 85c00f95c0595984c0743dff75f4a1a8 } /* Opcode */
		$op92 = { 59598bf8eb308d471050ff75fca1a879 } /* Opcode */
		$op93 = { 50ff750ca1a879440057ff90ac020000 } /* Opcode */
		$op94 = { 595985c00f856901000068705a4300ff } /* Opcode */
		$op95 = { 914300c784245806000014914300c784 } /* Opcode */
		$op96 = { a1a87944006a006870e04300ff7508ff } /* Opcode */
		$op97 = { b0684300c78424ac } /* Opcode */
		$op98 = { 8b433a8b4dfc8d048803c650a1a87944 } /* Opcode */
		$op99 = { 04414400c78424a0 } /* Opcode */
		$op100 = { 883b4400c784249c } /* Opcode */
		$op101 = { 30284300c78424e4 } /* Opcode */
		$op102 = { c6059179440001892d9c794400892598 } /* Opcode */
		$op103 = { c6059179440001892d9c794400892598 } /* Opcode */
		$op104 = { 595985c00f85340200006804564300ff } /* Opcode */
		$op105 = { a13ca0420089819c030000a118a04200 } /* Opcode */
		$op106 = { 595985c00f858b02000068bc554300ff } /* Opcode */
		$op107 = { 6c684300c78424a0 } /* Opcode */
		$op108 = { 83c4108945ec8d45bc50a1a879440056 } /* Opcode */
		$op109 = { f0424400c78424e0 } /* Opcode */
		$op110 = { 30f84200c7842494 } /* Opcode */
		$op111 = { 8bf0a1a879440068b4b7420056ff90fc } /* Opcode */
		$op112 = { 595985c00f850905000068b8534300ff } /* Opcode */
		$op113 = { 595985c0756868b85b4300ff7588a1a8 } /* Opcode */
		$op114 = { a1a8794400beff7f00005653ff90b8 } /* Opcode */
		$op115 = { 595985c075686818584300ff75b8a1a8 } /* Opcode */
		$op116 = { 83c4148bc65ec3558bec83ec14837d0c } /* Opcode */
		$op117 = { 85c0a1a8794400750f5653ff902c0100 } /* Opcode */
		$op118 = { 3d220000c0740732c0e9be } /* Opcode */
		$op119 = { b4434400c7842400010000c4434400c7 } /* Opcode */
		$op120 = { ff75f88d431050ff7508a1a8794400ff } /* Opcode */
		$op121 = { 48f94200c78424d4 } /* Opcode */
		$op122 = { ff75f4a1a879440053683cc843006854 } /* Opcode */
		$op123 = { ff75fca1a8794400576814c743006830 } /* Opcode */
		$op124 = { 81f9d03f00000f8e9c } /* Opcode */
		$op125 = { 689461440068b06144008bf8a1a87944 } /* Opcode */
		$op126 = { b0ad4300c7842488 } /* Opcode */
		$op127 = { 85c07581881e837dfc02752c8d45d450 } /* Opcode */
		$op128 = { ff75fca1a87944005768e0c6430068fc } /* Opcode */
		$op129 = { ff751050ff7508a1a8794400ff905001 } /* Opcode */
		$op130 = { ff750c8945f86898e143006854e24300 } /* Opcode */
		$op131 = { 59598bf08d45f450a1a8794400680780 } /* Opcode */
		$op132 = { 83c40cff75fcff7508a1a8794400ff90 } /* Opcode */
		$op133 = { 83c40cff75fcff7508a1a8794400ff90 } /* Opcode */
		$op134 = { 83c40cff75fcff7508a1a8794400ff90 } /* Opcode */
		$op135 = { ff75fca1a87944006a0268a0c7430068 } /* Opcode */
		$op136 = { 8b50245685d20f8ee2 } /* Opcode */
		$op137 = { d4424400c78424dc } /* Opcode */
		$op138 = { 68feff0000ff7508ff90b8 } /* Opcode */
		$op139 = { a8414400c78424b4 } /* Opcode */
		$op140 = { 595985c00f858601000068ac564300ff } /* Opcode */
		$op141 = { 595985c0756868905c4300ff7588a1a8 } /* Opcode */
		$op142 = { 8365f8008365fc00578b7d0c85ff0f84 } /* Opcode */
		$op143 = { 80751583780800740fa1a87944005756 } /* Opcode */
		$op144 = { 85c07579ff74241ca1a8794400ff750c } /* Opcode */
		$op145 = { 83c428381dad7944007419ff75f8a1a8 } /* Opcode */
		$op146 = { a0ae4300c78424c8 } /* Opcode */
		$op147 = { 25a24100c781d40300008c514100c781 } /* Opcode */
		$op148 = { 595985c00f85b204000068f0534300ff } /* Opcode */
		$op149 = { 85c074b6ff75fca1a8794400ff906002 } /* Opcode */
		$op150 = { 8975d8894ddc8975e48975e8ff90bc02 } /* Opcode */
		$op151 = { e0674300c7842488 } /* Opcode */
		$op152 = { 58694300c78424cc } /* Opcode */
		$op153 = { 50284300c78424ec } /* Opcode */
		$op154 = { 595985c00f85dd0100006840564300ff } /* Opcode */
		$op155 = { 595985c0751d68105c4300ff7588a1a8 } /* Opcode */
		$op156 = { f4f94200c78424f8 } /* Opcode */
		$op157 = { 98164300c7842490 } /* Opcode */
		$op158 = { b54200c784240801000010b54200c784 } /* Opcode */
		$op159 = { acf94200c78424e4 } /* Opcode */
		$op160 = { a1a87944008d5f106814de430053ff90 } /* Opcode */
		$op161 = { 08af4300c78424e8 } /* Opcode */
		$op162 = { 20184300c78424ec } /* Opcode */
		$op163 = { 56689c56440068ff7f00008945f850a1 } /* Opcode */
		$op164 = { 8d45f850a1a8794400ff90f801000083 } /* Opcode */
		$op165 = { 595985c00f85c001000068345a4300ff } /* Opcode */
		$op166 = { 83c4188945fc837dfc00752a6880 } /* Opcode */
		$op167 = { 5f3d230000c075578b45ec03c0668945 } /* Opcode */
		$op168 = { 4c174300c78424b4 } /* Opcode */
		$op169 = { 8b45a4595985c075038b45b005001000 } /* Opcode */
		$op170 = { 8bd8595985db0f8490 } /* Opcode */
		$op171 = { a8ef4200c78424ec } /* Opcode */
		$op172 = { b870794400bf34b042002bc78945e40f } /* Opcode */
		$op173 = { 9cf94200c78424e0 } /* Opcode */
		$op174 = { 595985c00f853508000068bc514300ff } /* Opcode */
		$op175 = { 85c07405e9ef100000ff7514ff75c8ff } /* Opcode */
		$op176 = { 24f94200c78424cc } /* Opcode */
		$op177 = { ff7518ff75145753ff908402000083c4 } /* Opcode */
		$op178 = { 85c00f8464fcffffff74240ca1a87944 } /* Opcode */
		$op179 = { 595985c0756068f4584300ff75b8a1a8 } /* Opcode */
		$op180 = { 5f8b45fc5e5bc9c3558bec83e4f883ec } /* Opcode */
		$op181 = { b0b44200c78424f4 } /* Opcode */
		$op182 = { 595985c075365650a1a879440057ff90 } /* Opcode */
		$op183 = { 8bd88b450c8bf85903c659895d108945 } /* Opcode */
		$op184 = { 783b4400c7842494 } /* Opcode */
		$op185 = { 595985c0741ba1a87944006858e44300 } /* Opcode */
		$op186 = { f4404400c784249c } /* Opcode */
		$op187 = { 57ff75088945c8a1a8794400ff90b8 } /* Opcode */
		$op188 = { 50a1a8794400576864bf43006894c043 } /* Opcode */
		$op189 = { 8b450c8b4d142bc883e90651ff75fc8d } /* Opcode */
		$op190 = { 8b4e2485c90f84e6 } /* Opcode */
		$op191 = { d4414400c78424bc } /* Opcode */
		$op192 = { ff75f8a1a8794400576804c143006818 } /* Opcode */
		$op193 = { 68e0094400ff75fcff91600100008b0d } /* Opcode */
		$op194 = { 595985c00f8532020000ff75d4a1a879 } /* Opcode */
		$op195 = { 564000c741700a284000c78130040000 } /* Opcode */
		$op196 = { 508d44245450a1a8794400c744245818 } /* Opcode */
		$op197 = { 595985c00f856a0700006828524300ff } /* Opcode */
		$op198 = { b0694300c78424d8 } /* Opcode */
		$op199 = { 983b4400c78424a4 } /* Opcode */
		$op200 = { 08184300c78424e4 } /* Opcode */
		$op201 = { a1a879440056ff750cff907c0100008b } /* Opcode */
		$op202 = { 83c40cff75bcff75bc0fb705b8794400 } /* Opcode */
		$op203 = { 68b8584300ff75b8a1a8794400ff9090 } /* Opcode */
		$op204 = { 3935d47944000f859b } /* Opcode */
		$op205 = { 595985c00f85950400006808544300ff } /* Opcode */
		$op206 = { 83c4108944241c8d44242c5056ff7424 } /* Opcode */
		$op207 = { 8944241ca1a8794400680829440056ff } /* Opcode */
		$op208 = { 3b4300c7842438060000103b4300c784 } /* Opcode */
		$op209 = { f17a4000c78188010000f8944100c781 } /* Opcode */
		$op210 = { 837d0c007505e98d } /* Opcode */
		$op211 = { b44300c78424600200000cb44300c784 } /* Opcode */
		$op212 = { 143c4400c78424d4 } /* Opcode */
		$op213 = { 595985c00f85870700006818524300ff } /* Opcode */
		$op214 = { 40184300c78424f8 } /* Opcode */
		$op215 = { a1a87944005756ff902c01000083c428 } /* Opcode */
		$op216 = { 595985c00f859e020000ff75c4a1a879 } /* Opcode */
		$op217 = { ff74242ca1a879440068c863430053ff } /* Opcode */
		$op218 = { 8b413c3bc30f84e0 } /* Opcode */
		$op219 = { babebff202b91204ca01a3a479440089 } /* Opcode */
		$op220 = { 595985c00f8554010000a1a879440068 } /* Opcode */
		$op221 = { 224300c784242403000018224300c784 } /* Opcode */
		$op222 = { d83b4400c78424c0 } /* Opcode */
		$op223 = { 53684ce34300568945c050a1a8794400 } /* Opcode */
		$op224 = { 44ef4200c78424d4 } /* Opcode */
		$op225 = { 7c3c4400c78424f4 } /* Opcode */
		$op226 = { 598bf0598b4d0889750c85db7e6d578a } /* Opcode */
		$op227 = { 874300c78424a803000008874300c784 } /* Opcode */
		$op228 = { 84174300c78424bc } /* Opcode */
		$op229 = { b8404400c7842490 } /* Opcode */
		$op230 = { 8364241800c70500b04200222700008b } /* Opcode */
		$op231 = { 836424140059598bd8beff7f000033c0 } /* Opcode */
		$op232 = { 5f85c07404b001c9c3a1a87944005356 } /* Opcode */
		$op233 = { 85c00f851f020000ff742424a1a87944 } /* Opcode */
		$op234 = { 8bf0a1a87944006848b7420056ff9060 } /* Opcode */
		$op235 = { 6868574300ff75b8a1a8794400ff9090 } /* Opcode */
		$op236 = { 1cae4300c78424a8 } /* Opcode */
		$op237 = { 68284300c78424f4 } /* Opcode */
		$op238 = { 59598945f48b45fcff308b45fc83c004 } /* Opcode */
		$op239 = { 8bf00fb705b879440050a1a879440068 } /* Opcode */
		$op240 = { ac274300c78424c0 } /* Opcode */
		$op241 = { 568d441b0250ff7514a1a8794400ff90 } /* Opcode */
		$op242 = { 043c4400c78424d0 } /* Opcode */
		$op243 = { 595985c00f85e70300006874544300ff } /* Opcode */
		$op244 = { c4404400c7842494 } /* Opcode */
		$op245 = { 74754000c7812004000082964100c781 } /* Opcode */
		$op246 = { 78414400c78424ac } /* Opcode */
		$op247 = { 986a4300c78424f4 } /* Opcode */
		$op248 = { 595985c00f855603000068fc544300ff } /* Opcode */
		$op249 = { f0f84200c78424bc } /* Opcode */
		$op250 = { ff4b148b5f3a035d0c837da80059590f } /* Opcode */
		$op251 = { e8274300c78424d0 } /* Opcode */
		$op252 = { 895c2464895c2468ff90bc0200003d22 } /* Opcode */
		$op253 = { 834b1cff5959eb178b4df00500f0ffff } /* Opcode */
		$op254 = { a1a879440056ff9000040000a1a87944 } /* Opcode */
		$op255 = { 83c40c6814594300ff7588a1a8794400 } /* Opcode */
		$op256 = { fb4200c784243401000010fb4200c784 } /* Opcode */
		$op257 = { a1a879440083c40cff742418ff907401 } /* Opcode */
		$op258 = { 8975ec8975f0ff900c030000f7d81bc0 } /* Opcode */
		$op259 = { 20af4300c78424f4 } /* Opcode */
		$op260 = { 3c274300c78424a0 } /* Opcode */
		$op261 = { 595985c00f855102000068f0554300ff } /* Opcode */
		$op262 = { 595985c0754f68d45b4300ff7588a1a8 } /* Opcode */
		$op263 = { 60ef4200c78424dc } /* Opcode */
		$op264 = { 595985c00f85e20200006860554300ff } /* Opcode */
		$op265 = { 10af4300c78424ec } /* Opcode */
		$op266 = { 83c0083bc30f84ab } /* Opcode */
		$op267 = { 85db7456ff75108bf0ff750ca1a87944 } /* Opcode */
		$op268 = { d8ef4200c78424f4 } /* Opcode */
		$op269 = { 70424400c78424d0 } /* Opcode */
		$op270 = { 59598d4dec51568bf833c057508945fc } /* Opcode */
		$op271 = { 59593bc37461a1a879440068dce54300 } /* Opcode */
		$op272 = { 595985c00f85f60600006870524300ff } /* Opcode */
		$op273 = { 68b0424300ff75f057ff905001000083 } /* Opcode */
		$op274 = { 59598bd88d45f050565357897dfc57e9 } /* Opcode */
		$op275 = { ff750c8bd8a1a87944006800b1420068 } /* Opcode */
		$op276 = { 8d45ec50ff75fca1a8794400ff90f802 } /* Opcode */
		$op277 = { 595983670400836708008b450c5fc9c3 } /* Opcode */
		$op278 = { ff75f0a1a879440068f0c8430056ff50 } /* Opcode */
		$op279 = { 595985c00f8517020000ff75c0a1a879 } /* Opcode */
		$op280 = { 0f825affffff5f5e8be55dc3558bec83 } /* Opcode */
		$op281 = { 8975e48975e88975fcff90bc02000085 } /* Opcode */
		$op282 = { ff4424148d474450a1a8794400ff9098 } /* Opcode */
		$op283 = { 30174300c78424ac } /* Opcode */
		$op284 = { 595985c00f85a407000068fc514300ff } /* Opcode */
		$op285 = { 837d100159598bf07510ff750cff35bc } /* Opcode */
		$op286 = { 595985c00f85f10500006824534300ff } /* Opcode */
		$op287 = { fc274300c78424d4 } /* Opcode */
		$op288 = { 88f84200c78424a8 } /* Opcode */
		$op289 = { b24300c78424d401000008b24300c784 } /* Opcode */
		$op290 = { 30ae4300c78424ac } /* Opcode */
		$op291 = { 53ff75088bf0a1a8794400ff90780200 } /* Opcode */
		$op292 = { 8c404400c784248c } /* Opcode */
		$op293 = { 83c4188945fc837dfc00746c8b45fc81 } /* Opcode */
		$op294 = { 8b45fc8b008d44000250ff7508a1a879 } /* Opcode */
		$op295 = { c8ad4300c7842490 } /* Opcode */
		$op296 = { 64174300c78424b8 } /* Opcode */
		$op297 = { 85c07524ff74240ca1a8794400ff7508 } /* Opcode */
		$op298 = { 595985c00f85bc0600006894524300ff } /* Opcode */
		$op299 = { 895dd4897ddc895de0895de4ff90bc02 } /* Opcode */
		$op300 = { f4b34200c78424b4 } /* Opcode */
		$op301 = { 8b45fc0fb7400483f8250f85d9 } /* Opcode */
		$op302 = { 59595e837df40074198b470805001000 } /* Opcode */
		$op303 = { 50a1a87944005356ff90bc } /* Opcode */
		$op304 = { 8b463a03c350a1a8794400ff90040400 } /* Opcode */
		$op305 = { 44f84200c7842498 } /* Opcode */
		$op306 = { 595985c00f85fb07000068d4514300ff } /* Opcode */
		$op307 = { ff75fca1a8794400576804c643006820 } /* Opcode */
		$op308 = { 90414400c78424b0 } /* Opcode */
		$op309 = { 70164300c7842484 } /* Opcode */
		$op310 = { 1cf04200c784240001000038f04200c7 } /* Opcode */
		$op311 = { 68b4574300ff75b8a1a8794400ff9090 } /* Opcode */
		$op312 = { e0f94200c78424f4 } /* Opcode */
		$op313 = { 83c40c68fc8043008d45c050a1a87944 } /* Opcode */
		$op314 = { 59595656ff74243889442424508d4424 } /* Opcode */
		$op315 = { 8b45f88038030f85fc } /* Opcode */
		$op316 = { 14434400c78424e4 } /* Opcode */
		$op317 = { 30ee4200c7842488 } /* Opcode */
		$op318 = { 85c07405e9500100006a018d45e8508d } /* Opcode */
		$op319 = { 59598bf8895df4895df8c645ff01eb51 } /* Opcode */
		$op320 = { cc174300c78424d4 } /* Opcode */
		$op321 = { 68b34200c7842498 } /* Opcode */
		$op322 = { 354300c784247804000010354300c784 } /* Opcode */
		$op323 = { 10d54000b89ba64100898174030000c7 } /* Opcode */
		$op324 = { 48424400c78424c8 } /* Opcode */
		$op325 = { 85c07535a1a8794400538db8c4010000 } /* Opcode */
		$op326 = { 68feff0000ff750889442424a1a87944 } /* Opcode */
		$op327 = { b76c4000c781500200003e6f4000c741 } /* Opcode */
		$op328 = { 395d14598bf0598975f87e36578b4510 } /* Opcode */
		$op329 = { 8bf80fb705b879440050a1a879440068 } /* Opcode */
		$op330 = { 595985c00f851808000068c8514300ff } /* Opcode */
		$op331 = { a24300c78424440b000008a24300c784 } /* Opcode */
		$op332 = { ff75f8a1a8794400576898c0430068b0 } /* Opcode */
		$op333 = { 595985c00f856901000068d0564300ff } /* Opcode */
		$op334 = { d8274300c78424cc } /* Opcode */
		$op335 = { a1a879440083c450ff75fc5768a4c643 } /* Opcode */
		$op336 = { 663bd8740a46460fb7066685c075d333 } /* Opcode */
		$op337 = { 98b44200c78424ec } /* Opcode */
		$op338 = { 85c00f84f2feffffa1a879440053ff75 } /* Opcode */
		$op339 = { 595985c00f85390300006814554300ff } /* Opcode */
		$op340 = { ff35d079440089442428684474430056 } /* Opcode */
		$op341 = { 59598bf88d44241450ff7424188d4424 } /* Opcode */
		$op342 = { a1a87944008d5e0c68a8dd430053ff90 } /* Opcode */
		$op343 = { ff90c403000059598d45e050a1a87944 } /* Opcode */
		$op344 = { 5353ff35bc7944008945d4a1a8794400 } /* Opcode */
		$op345 = { 68478000006a008944242450a1a87944 } /* Opcode */
		$op346 = { 5068000010808d44245050a1a8794400 } /* Opcode */
		$op347 = { 543c4400c78424e8 } /* Opcode */
		$op348 = { 595985c00f851201000068ec5a4300ff } /* Opcode */
		$op349 = { d4164300c784249c } /* Opcode */
		$op350 = { a8ee4200c78424a4 } /* Opcode */
		$op351 = { f83b4400c78424cc } /* Opcode */
		$op352 = { 595985c00f8571010000a1a879440068 } /* Opcode */
		$op353 = { f4ee4200c78424bc } /* Opcode */
		$op354 = { 808d45f850a1a87944006a00ff5044c9 } /* Opcode */
		$op355 = { 83c40c8b45f85e5f5bc9c3558bec51a1 } /* Opcode */
		$op356 = { 895de4895de8ff90bc02000085c07d07 } /* Opcode */
		$op357 = { ff75148b45fc83c00450ff750ca1a879 } /* Opcode */
		$op358 = { 30b44200c78424c8 } /* Opcode */
		$op359 = { fc694300c78424e0 } /* Opcode */
		$op360 = { 68274300c78424ac } /* Opcode */
		$op361 = { bcef4200c78424f0 } /* Opcode */
		$op362 = { a1a879440083c440ff7510681cb74200 } /* Opcode */
		$op363 = { 7cb44200c78424e0 } /* Opcode */
		$op364 = { 24284300c78424e0 } /* Opcode */
		$op365 = { a0b44200c78424f0 } /* Opcode */
		$op366 = { 50a1a879440051ff90b8 } /* Opcode */
		$op367 = { 8d47fc50a1a879440053ff90b4 } /* Opcode */
		$op368 = { 5c274300c78424a8 } /* Opcode */
		$op369 = { 8975e48975e8ff90bc0200003d220000 } /* Opcode */
		$op370 = { 59598945ec0fb705b879440050687444 } /* Opcode */
		$op371 = { 56ff7424188bf8a1a879440057ff90d0 } /* Opcode */
		$op372 = { 194300c78424100100001c194300c784 } /* Opcode */
		$op373 = { a1a87944005653ff902c01000083c41c } /* Opcode */
		$op374 = { 8d4744685c61430050a1a8794400ff90 } /* Opcode */
		$op375 = { 8b46048b0d987944008988c4 } /* Opcode */
		$op376 = { a1a8794400536800080000ff7508ff90 } /* Opcode */
		$op377 = { 5150a1a8794400ff90b8 } /* Opcode */
		$op378 = { 5150a1a8794400ff90b8 } /* Opcode */
		$op379 = { ac174300c78424c8 } /* Opcode */
		$op380 = { 83c410ff75108945f88d45dc50a1a879 } /* Opcode */
		$op381 = { 595985c00f85120100006850574300ff } /* Opcode */
		$op382 = { 0f8260ffffffa1a879440068a0384400 } /* Opcode */
		$op383 = { 8b44240c83c04468dc7f430050a1a879 } /* Opcode */
		$op384 = { bcb44200c78424f8 } /* Opcode */
		$op385 = { 895dcc894dd0895dd8895ddcff90bc02 } /* Opcode */
		$op386 = { 20274300c7842498 } /* Opcode */
		$op387 = { 59598bf88d44242050ff7424248d4424 } /* Opcode */
		$op388 = { 59598bf08d45fc50ff75fc8d45f4566a } /* Opcode */
		$op389 = { a1a879440083c40cff74240cff907401 } /* Opcode */
		$op390 = { e989feffffa1a87944005357685cb042 } /* Opcode */
		$op391 = { 28af4300c78424f8 } /* Opcode */
		$op392 = { 595985c00f856e0200006870594300ff } /* Opcode */
		$op393 = { ff75108bf8a1a87944006810b7420056 } /* Opcode */
		$op394 = { 3935d47944000f85c6 } /* Opcode */
		$op395 = { 924300c78424a006000010924300c784 } /* Opcode */
		$op396 = { ecee4200c78424b8 } /* Opcode */
		$op397 = { 595985c00f852f01000068c85a4300ff } /* Opcode */
		$op398 = { 8b4e24c1e10251ff75fc8945f850a1a8 } /* Opcode */
		$op399 = { 6a228d45ec50ff757ca1a8794400c745 } /* Opcode */
		$op400 = { 58414400c78424a8 } /* Opcode */
		$op401 = { 897dc4897dc8ff904803000085c00f85 } /* Opcode */
		$op402 = { d03b4400c78424bc } /* Opcode */
		$op403 = { 895c2464895c2468ff90bc02000085c0 } /* Opcode */
		$op404 = { dcae4300c78424d8 } /* Opcode */
		$op405 = { a1a8794400538b5d08565768feff0000 } /* Opcode */
		$op406 = { 595985c00f858b0200006858594300ff } /* Opcode */
		$op407 = { 943c4400c78424fc } /* Opcode */
		$op408 = { b0ee4200c78424a8 } /* Opcode */
		$op409 = { ff90bc02000085c0a1a87944007412ff } /* Opcode */
		$op410 = { ff75108945f80fb7450c50a1a8794400 } /* Opcode */
		$op411 = { 8b1584a042008991a4020000c7813802 } /* Opcode */
		$op412 = { 895e10895e14ff90bc02000085c0742a } /* Opcode */
		$op413 = { ff7510a1a87944006834b742005657ff } /* Opcode */
		$op414 = { 595985c00f854d0700006844524300ff } /* Opcode */
		$op415 = { 30ef4200c78424d0 } /* Opcode */
		$op416 = { 595985c00f85c00100006864564300ff } /* Opcode */
		$op417 = { 94ee4200c78424a0 } /* Opcode */
		$op418 = { 8b6c24248b5c242059598bf8beff7f00 } /* Opcode */
		$op419 = { 33db395d14598bf0598975fc7e2e8b45 } /* Opcode */
		$op420 = { ff900c030000f7d81bc0f7d02345fc5f } /* Opcode */
		$op421 = { 24b44200c78424c4 } /* Opcode */
		$op422 = { 803b4400c7842498 } /* Opcode */
		$op423 = { 57ff75088945e0a1a8794400ff90b8 } /* Opcode */
		$op424 = { ff75fca1a8794400576838c643006850 } /* Opcode */
		$op425 = { 68e0574300ff75b8a1a8794400ff9090 } /* Opcode */
		$op426 = { 8b45fc8338040f8ee9 } /* Opcode */
		$op427 = { 38b44200c78424cc } /* Opcode */
		$op428 = { ff742448a1a879440053ff902c010000 } /* Opcode */
		$op429 = { 4c694300c78424c8 } /* Opcode */
		$op430 = { 85c07402eb60ff75f4ff7518ff7508a1 } /* Opcode */
		$op431 = { 6c434400c78424f4 } /* Opcode */
		$op432 = { a1a8794400682ce54300ff75f8ff9090 } /* Opcode */
		$op433 = { 8b44242083c00450ff7508a1a8794400 } /* Opcode */
		$op434 = { a1a8794400595968a86b440068e06b44 } /* Opcode */
		$op435 = { 28ee4200c7842484 } /* Opcode */
		$op436 = { 85c074258d45f450a1a8794400ff90a4 } /* Opcode */
		$op437 = { a1a879440056ff90d0030000a1a87944 } /* Opcode */
		$op438 = { ff7508a1a8794400ff7308ff909c } /* Opcode */
		$op439 = { e9b0feffffa1a879440053576850b042 } /* Opcode */
		$op440 = { 598945f8598d45fc508d45f4508d45ec } /* Opcode */
		$op441 = { 8bf8a1d079440033f65959897c24203b } /* Opcode */
		$op442 = { 8975d88975e48975e8ff90bc02000053 } /* Opcode */
		$op443 = { 59598bf88d45f450565753895dfc53e9 } /* Opcode */
		$op444 = { c0174300c78424d0 } /* Opcode */
		$op445 = { 8bf083c40c3bf375148d45fc50a1a879 } /* Opcode */
		$op446 = { 595985c00f853e0400006848544300ff } /* Opcode */
		$op447 = { e8ae4300c78424dc } /* Opcode */
		$op448 = { 80ae4300c78424c0 } /* Opcode */
		$op449 = { c7430c20020000895df0ff506853ff75 } /* Opcode */
		$op450 = { e962feffffa1a879440053576864b042 } /* Opcode */
		$op451 = { 595985c00f852605000068ac534300ff } /* Opcode */
		$op452 = { 668b4d0a663bc874c7464666833e000f } /* Opcode */
		$op453 = { 595985c00f85ec04000068c8534300ff } /* Opcode */
		$op454 = { c0414400c78424b8 } /* Opcode */
		$op455 = { 85c075d68d45c050a1a8794400ff501c } /* Opcode */
		$op456 = { 40284300c78424e8 } /* Opcode */
		$op457 = { 14284300c78424dc } /* Opcode */
		$op458 = { ff75f8a1a87944005768d0c0430068e4 } /* Opcode */
		$op459 = { ff75108bf8ff750ca1a879440068b460 } /* Opcode */
		$op460 = { b03b4400c78424b0 } /* Opcode */
		$op461 = { 836508008365f8008bd8668b46026648 } /* Opcode */
		$op462 = { 595985c07415b301a1a87944005657ff } /* Opcode */
		$op463 = { 59595656578bd8538d45f450a1a87944 } /* Opcode */
		$op464 = { 595985c0757968d4584300ff75b8a1a8 } /* Opcode */
		$op465 = { 595985c00f855b040000682c544300ff } /* Opcode */
		$op466 = { a1a87944005657beff7f000056ff7508 } /* Opcode */
		$op467 = { a1a87944005657beff7f000056ff7508 } /* Opcode */
		$op468 = { 83c40c5f33c05e5dc3558bec83e4f883 } /* Opcode */
		$op469 = { 59595f5ec3558bec83ec286a0a8d45d8 } /* Opcode */
		$op470 = { a1a8794400689477440056ff90740300 } /* Opcode */
		$op471 = { 595985c0754733c0668945b033c08d7d } /* Opcode */
		$op472 = { 40694300c78424c4 } /* Opcode */
		$op473 = { 595985c00f85300700006850524300ff } /* Opcode */
		$op474 = { 8d45dc5068000108008d45fc50a1a879 } /* Opcode */
		$op475 = { a14300c78424f80a00000ca14300c784 } /* Opcode */
		$op476 = { d0ae4300c78424d4 } /* Opcode */
		$op477 = { 30404400c7842484 } /* Opcode */
		$op478 = { f8264300c784248c } /* Opcode */
		$op479 = { e937feffff558bec83e4f881ec9c0100 } /* Opcode */
		$op480 = { 04fa4200c78424fc } /* Opcode */
		$op481 = { 20414400c78424a4 } /* Opcode */
		$op482 = { 80434400c78424f8 } /* Opcode */
		$op483 = { 34774000c781a4030000e3f940008991 } /* Opcode */
		$op484 = { 104000c7810c040000ae2b4000c781c8 } /* Opcode */
		$op485 = { 895c245c895c2460ff900c03000085c0 } /* Opcode */
		$op486 = { b23e4000c7814c020000361b4000c781 } /* Opcode */
		$op487 = { 595985c00f85040400006868544300ff } /* Opcode */
		$op488 = { bc164300c7842498 } /* Opcode */
		$op489 = { 50a1a8794400ff901c01000083c41ceb } /* Opcode */
		$op490 = { dc684300c78424b4 } /* Opcode */
		$op491 = { 3cf94200c78424d0 } /* Opcode */
		$op492 = { b8f94200c78424e8 } /* Opcode */
		$op493 = { cc274300c78424c8 } /* Opcode */
		$op494 = { 3b05d8794400751b8b4604ff80b8 } /* Opcode */
		$op495 = { ff750c8bd8a1a87944006880b0420068 } /* Opcode */
		$op496 = { 83c4508d45f450a1a8794400ff90f801 } /* Opcode */
		$op497 = { 58424400c78424cc } /* Opcode */
		$op498 = { 817c2410102700000f8fd8 } /* Opcode */
		$op499 = { 895de0895de4ff90bc02000089450c3d } /* Opcode */
		$op500 = { 8b45080500f0ffff89461c53ff7708e8 } /* Opcode */
		$op501 = { 50a1a87944005668306443005653ff90 } /* Opcode */
		$op502 = { a1a87944008b405083c40c3bc3740b8d } /* Opcode */
		$op503 = { 83c40c834b0c048b075e5b5fc9c3558b } /* Opcode */
		$op504 = { 72b6ff75f8a1a8794400ff7508ff902c } /* Opcode */
		$op505 = { f0ad4300c7842498 } /* Opcode */
		$op506 = { b4264300c7842484 } /* Opcode */
		$op507 = { 595985c00f858e010000a1a879440068 } /* Opcode */
		$op508 = { 38b34200c7842490 } /* Opcode */
		$op509 = { ff75108bf8ff750ca1a879440068d85f } /* Opcode */
		$op510 = { 50ee4200c7842494 } /* Opcode */
		$op511 = { 8cae4300c78424c4 } /* Opcode */
		$op512 = { 7cf94200c78424dc } /* Opcode */
		$op513 = { ff742454a1a879440068406343006848 } /* Opcode */
		$op514 = { ff750c50a1a8794400ff904001000059 } /* Opcode */
		$op515 = { 14274300c7842494 } /* Opcode */
		$op516 = { 89463a85c0744f897e288b7e3a037d08 } /* Opcode */
		$op517 = { c8674300c7842484 } /* Opcode */
		$op518 = { 3d230000c0740b3d050000800f85df } /* Opcode */
		$op519 = { 3d230000c075618b45fc8d4400025089 } /* Opcode */
		$op520 = { 83c41489451083f8ff0f84b6 } /* Opcode */
		$op521 = { 595985c00f853402000068c0594300ff } /* Opcode */
		$op522 = { 8974247489742478ff90bc02000085c0 } /* Opcode */
		$op523 = { 8974247489742478ff90bc02000085c0 } /* Opcode */
		$op524 = { a170a04200898128010000a19ca04200 } /* Opcode */
		$op525 = { 895db0895db4ff90bc020000bf340000 } /* Opcode */
		$op526 = { 83c414c60437008bc75f5ec3558bec83 } /* Opcode */
		$op527 = { ff900c0300003d220000c00f8586 } /* Opcode */
		$op528 = { 85c00f84a9fdffffff742418a1a87944 } /* Opcode */
		$op529 = { 7c164300c7842488 } /* Opcode */
		$op530 = { 59974100c7416cf8184000c781340100 } /* Opcode */
		$op531 = { 8b48103bcb0f84eb } /* Opcode */
		$op532 = { 8944241c8d474450ff750ca1a8794400 } /* Opcode */
		$op533 = { 85c075138b45f0668378023a7509668b } /* Opcode */
		$op534 = { 2a4300c7842468010000102a4300c784 } /* Opcode */
		$op535 = { c8ee4200c78424ac } /* Opcode */
		$op536 = { 83c40c6a0a83c71057568d45ec50ff75 } /* Opcode */
		$op537 = { 314300c78424500300000c314300c784 } /* Opcode */
		$op538 = { 80184300c7842400010000a4184300c7 } /* Opcode */
		$op539 = { ff7608a1a8794400ff50788bd8a1a879 } /* Opcode */
		$op540 = { 1c6a4300c78424e4 } /* Opcode */
		$op541 = { a1a87944006850e5430053ff9090 } /* Opcode */
		$op542 = { 595985c00f8551020000689c594300ff } /* Opcode */
		$op543 = { 8bd80fb705b879440050a1a879440068 } /* Opcode */
		$op544 = { 18684300c7842494 } /* Opcode */
		$op545 = { 8975dc8975e08975f4ff90f8 } /* Opcode */
		$op546 = { 595985c00f85c50200006828594300ff } /* Opcode */
		$op547 = { e0ee4200c78424b4 } /* Opcode */
		$op548 = { 4e914000a1cca04200898154030000c7 } /* Opcode */
		$op549 = { a34300c784248c0b00000ca34300c784 } /* Opcode */
		$op550 = { 5cae4300c78424b8 } /* Opcode */
		$op551 = { 68345b4300ff7588a1a8794400ff9090 } /* Opcode */
		$op552 = { 595985c00f85dd01000068245a4300ff } /* Opcode */
		$op553 = { 595985c00f85ad030000688c544300ff } /* Opcode */
		$op554 = { 83c424ff4e248b4624744f6a01c1e002 } /* Opcode */
		$op555 = { 595985c00f859f06000068b0524300ff } /* Opcode */
		$op556 = { 5f85c0740432c0c9c3568d45f850ff75 } /* Opcode */
		$op557 = { 68feff0000ff75088944241ca1a87944 } /* Opcode */
		$op558 = { 6a2f8d45b850ff757ca1a8794400c745 } /* Opcode */
		$op559 = { 688c41430050a1a879440053ff905001 } /* Opcode */
		$op560 = { 8c164300c784248c } /* Opcode */
		$op561 = { ecef4200c78424f8 } /* Opcode */
		$op562 = { 83c414381db17944007459a1a8794400 } /* Opcode */
		$op563 = { ff75f88bf8ff750ca1a8794400687014 } /* Opcode */
		$op564 = { 57ff751056ff909c02000053ff76088b } /* Opcode */
		$op565 = { 595985c07536684c584300ff75b8a1a8 } /* Opcode */
		$op566 = { 595985c00f85ff0200006848554300ff } /* Opcode */
		$op567 = { d6224100c7811801 } /* Opcode */
		$op568 = { 686a4300c78424ec } /* Opcode */
		$op569 = { 8975b88975bcff900c03000085c00f85 } /* Opcode */
		$op570 = { 568bd8a1a879440068d0b8410053ff90 } /* Opcode */
		$op571 = { 8b0da8794400536689450aff91e8 } /* Opcode */
		$op572 = { 6820b14200683cb142008bf0a1a87944 } /* Opcode */
		$op573 = { 14b44200c78424bc } /* Opcode */
		$op574 = { 595985c00f850e0600006810534300ff } /* Opcode */
		$op575 = { 595985c074156a005750a1a879440056 } /* Opcode */
		$op576 = { 08f04200c78424fc } /* Opcode */
		$op577 = { a1a879440083c450ff75fc576864c743 } /* Opcode */
		$op578 = { a46a4300c78424f8 } /* Opcode */
		$op579 = { 8c3c4400c78424f8 } /* Opcode */
		$op580 = { 8bf8a1a8794400684780000053ff90b8 } /* Opcode */
		$op581 = { 595985c0757ba1a87944006830de4300 } /* Opcode */
		$op582 = { 83c410894424108d4424245056ff7424 } /* Opcode */
		$op583 = { 903b4400c78424a0 } /* Opcode */
		$op584 = { bc3b4400c78424b4 } /* Opcode */
		$op585 = { 8945fc8d474450ff7510a1a879440068 } /* Opcode */
		$op586 = { 9c434400c78424fc } /* Opcode */
		$op587 = { ff75108bf8a1a879440068dcb6420056 } /* Opcode */
		$op588 = { 3c434400c78424e8 } /* Opcode */
		$op589 = { 595985c0754da1a8794400687cde4300 } /* Opcode */
		$op590 = { 6888574300ff75b8a1a8794400ff9090 } /* Opcode */
		$op591 = { 94ef4200c78424e8 } /* Opcode */
		$op592 = { 68b45b440050a1a879440053ff905001 } /* Opcode */
		$op593 = { ff75106a00ff750ca1a8794400ff909c } /* Opcode */
		$op594 = { ff75106a00ff750ca1a8794400ff909c } /* Opcode */
		$op595 = { a1a879440083c450ff742418687c6343 } /* Opcode */
		$op596 = { a43b4400c78424ac } /* Opcode */
		$op597 = { 59164000c781a0010000bc2f4000a188 } /* Opcode */
		$op598 = { 85c0754e50ff742414a1a8794400683c } /* Opcode */
		$op599 = { a4174300c78424c4 } /* Opcode */
		$op600 = { 30274300c784249c } /* Opcode */
		$op601 = { 740ac705d479440006 } /* Opcode */
		$op602 = { 595985c00f85a30100006878564300ff } /* Opcode */
		$op603 = { 18ef4200c78424c8 } /* Opcode */
		$op604 = { 84ef4200c78424e4 } /* Opcode */
		$op605 = { dcb44200c7842400010000ecb44200c7 } /* Opcode */
		$op606 = { 59598bd8ff74bd88a1a879440068d006 } /* Opcode */
		$op607 = { 60184300c78424fc } /* Opcode */
		$op608 = { 85c0752bff7510a1a8794400ff750cff } /* Opcode */
		$op609 = { 8945f0668b45ec59668945ee598d45ec } /* Opcode */
		$op610 = { 0f8252ffffffa1a879440053ff7508ff } /* Opcode */
		$op611 = { ff7510a1a879440056ff907402000083 } /* Opcode */
		$op612 = { 5c434400c78424f0 } /* Opcode */
		$op613 = { 68545b4300ff7588a1a8794400ff9090 } /* Opcode */
		$op614 = { 595985c00f85b7050000684c534300ff } /* Opcode */
		$op615 = { a1a879440056536a0468f8a04200ff90 } /* Opcode */
		$op616 = { 595985c00f85c50200006894554300ff } /* Opcode */
		$op617 = { 59598945fc8b45f4484850ff75188b45 } /* Opcode */
		$op618 = { 595985c00f851c0300006838554300ff } /* Opcode */
		$op619 = { 83c41889458c837d8c000f8407040000 } /* Opcode */
		$op620 = { 595985c00f851a010000a1a879440068 } /* Opcode */
		$op621 = { 595985c00f85d40500006838534300ff } /* Opcode */
		$op622 = { a1a87944006808624400ff75f856ff90 } /* Opcode */
		$op623 = { c8f94200c78424ec } /* Opcode */
		$op624 = { ff75f0a1a87944005368b4c8430068c8 } /* Opcode */
		$op625 = { ff75eca1a879440068e8c7430056ff50 } /* Opcode */
		$op626 = { 85c0754d8b450c668378023f50a1a879 } /* Opcode */
		$op627 = { 66837938020f86d5 } /* Opcode */
		$op628 = { ff75f4a1a8794400576820c84300682c } /* Opcode */
		$op629 = { ff75d08b4df88b45ccff751403c10345 } /* Opcode */
		$op630 = { 68805b4300ff7588a1a8794400ff9090 } /* Opcode */
		$op631 = { 4c274300c78424a4 } /* Opcode */
		$op632 = { a1a879440068e44443005653ff900801 } /* Opcode */
		$op633 = { 58ef4200c78424d8 } /* Opcode */
		$op634 = { 8d8500feffff689880430068ff } /* Opcode */
		$op635 = { 595985c00f859003000068ac544300ff } /* Opcode */
		$op636 = { 8b45fc8d048603433a50a1a8794400ff } /* Opcode */
		$op637 = { 54684300c784249c } /* Opcode */
		$op638 = { 68b0464300ff75088bf8a1a8794400ff } /* Opcode */
		$op639 = { 643b4400c784248c } /* Opcode */
		$op640 = { 894424608b44244883c04468cc7f4300 } /* Opcode */
		$op641 = { 595985c00f859a0500006860534300ff } /* Opcode */
		$op642 = { a1a879440053ff7508ff90b8 } /* Opcode */
		$op643 = { 8b5d1085c07535a1a8794400538db8c4 } /* Opcode */
		$op644 = { a1a879440056ff5028a1a87944006a13 } /* Opcode */
		$op645 = { 2c3c4400c78424dc } /* Opcode */
		$op646 = { 443c4400c78424e4 } /* Opcode */
		$op647 = { 08ae4300c78424a4 } /* Opcode */
		$op648 = { 94694300c78424d4 } /* Opcode */
		$op649 = { 83c8ffe95c010000836508008d450850 } /* Opcode */
		$op650 = { ff75fca1a87944006838b04200ff7514 } /* Opcode */
		$op651 = { 71324000c7814c0100006a6b4000a1d4 } /* Opcode */
		$op652 = { 3c684300c7842498 } /* Opcode */
		$op653 = { 595985c00f854c01000068a45a4300ff } /* Opcode */
		$op654 = { c0ae4300c78424d0 } /* Opcode */
		$op655 = { 703b4400c7842490 } /* Opcode */
		$op656 = { 595985c07520a1a87944005753ff9060 } /* Opcode */
		$op657 = { e43b4400c78424c4 } /* Opcode */
		$op658 = { d4f84200c78424b8 } /* Opcode */
		$op659 = { a18ca042008981bc020000a190a04200 } /* Opcode */
		$op660 = { 64ee4200c7842498 } /* Opcode */
		$op661 = { d4f94200c78424f0 } /* Opcode */
		$op662 = { 8945f48d474450ff750ca1a879440068 } /* Opcode */
		$op663 = { 8945f48d474450ff750ca1a879440068 } /* Opcode */
		$op664 = { ff503c8d44242c894424588d842480 } /* Opcode */
		$op665 = { 6cf84200c78424a0 } /* Opcode */
		$op666 = { 68385c4300ff7588a1a8794400ff9090 } /* Opcode */
		$op667 = { 595985c0745aa1a879440068feff0000 } /* Opcode */
		$op668 = { 595985c0745aa1a879440068feff0000 } /* Opcode */
		$op669 = { 24184300c78424f0 } /* Opcode */
		$op670 = { 59598945bc8b45c0ff70108b45c083c0 } /* Opcode */
		$op671 = { 8b45088b50183bca0f82270100008b40 } /* Opcode */
		$op672 = { 10f84200c7842488 } /* Opcode */
		$op673 = { ff75f4a1a8794400683f420f006864c8 } /* Opcode */
		$op674 = { 8d45e450a1a8794400ff90f801000083 } /* Opcode */
		$op675 = { 85c00f8420faffff5fff75f0a1a87944 } /* Opcode */
		$op676 = { 30694300c78424c0 } /* Opcode */
		$op677 = { 8d4300c7842440050000148d4300c784 } /* Opcode */
		$op678 = { 6898584300ff75b8a1a8794400ff9090 } /* Opcode */
		$op679 = { 8b5dfc3bde75053975f4747b33c03bde } /* Opcode */
		$op680 = { 85c075158d45f850ffd68d45f850a1a8 } /* Opcode */
		$op681 = { 595985c00f85de07000068e0514300ff } /* Opcode */
		$op682 = { 0fb748486685c97e770fbfd13955f07f } /* Opcode */
		$op683 = { 595985c00f85210400006858544300ff } /* Opcode */
		$op684 = { 595985c00f855208000068b0514300ff } /* Opcode */
		$op685 = { a0284300c7842400010000b0284300c7 } /* Opcode */
		$op686 = { a4424400c78424d8 } /* Opcode */
		$op687 = { 817c2414102700000f8fcc } /* Opcode */
		$op688 = { 24ef4200c78424cc } /* Opcode */
		$op689 = { 595985c00f85ab010000a1a879440068 } /* Opcode */
		$op690 = { a194a04200898194 } /* Opcode */
		$op691 = { 8cb34200c78424a0 } /* Opcode */
		$op692 = { 8b5d088bf8a1a8794400688049430053 } /* Opcode */
		$op693 = { 895c2464895c2468ff900c03000085c0 } /* Opcode */
		$op694 = { 895c2464895c2468ff900c03000085c0 } /* Opcode */
		$op695 = { ff75108b5d0c8bf8a1a879440053897d } /* Opcode */
		$op696 = { 518db884020000ff907c0100005903c0 } /* Opcode */
		$op697 = { 54b44200c78424d4 } /* Opcode */
		$op698 = { 08284300c78424d8 } /* Opcode */
		$op699 = { fbd94000c78110040000cb584100c781 } /* Opcode */
		$op700 = { ccb44200c78424fc } /* Opcode */
		$op701 = { 595985c0751d6870584300ff75b8a1a8 } /* Opcode */
		$op702 = { 595985c00f85cf04000068e0534300ff } /* Opcode */
		$op703 = { 578b7d088d45fe508b450cff34b0a1a8 } /* Opcode */
		$op704 = { 595985c00f85fc010000a1a879440068 } /* Opcode */
		$op705 = { 8944246c8b44244483c04450ff742450 } /* Opcode */
		$op706 = { 595985c00f8583020000ff75e0a1a879 } /* Opcode */
		$op707 = { 59598d44240850a1a8794400ff90a402 } /* Opcode */
		$op708 = { 85c0753aa1a87944006a01683c3d4400 } /* Opcode */
		$op709 = { 74b44200c78424dc } /* Opcode */
		$op710 = { a8b34200c78424a4 } /* Opcode */
		$op711 = { a1e0a04200898128040000a144a04200 } /* Opcode */
		$op712 = { 60b44200c78424d8 } /* Opcode */
		$op713 = { f4674300c784248c } /* Opcode */
		$op714 = { 59598945d08d45d85068ff8f0000ff75 } /* Opcode */
		$op715 = { 6814e34300ff75f88945cca1a8794400 } /* Opcode */
		$op716 = { a1a879440083c450ff74240c681c6643 } /* Opcode */
		$op717 = { 78f84200c78424a4 } /* Opcode */
		$op718 = { 9c3c4400c7842400010000a83c4400c7 } /* Opcode */
		$op719 = { 9c4300c784248c0900000c9c4300c784 } /* Opcode */
		$op720 = { b4174300c78424cc } /* Opcode */
		$op721 = { 6c3c4400c78424f0 } /* Opcode */
		$op722 = { 894da4ff503c8d45dc8945bc8d459c50 } /* Opcode */
		$op723 = { 78ef4200c78424e0 } /* Opcode */
		$op724 = { 54b34200c7842494 } /* Opcode */
		$op725 = { 8365fc0059598945f88b45fc8b9c8590 } /* Opcode */
		$op726 = { 90284300c78424fc } /* Opcode */
		$op727 = { c4684300c78424b0 } /* Opcode */
		$op728 = { bcad4300c784248c } /* Opcode */
		$op729 = { 0fb70db879440053516824e343005689 } /* Opcode */
		$op730 = { 24b34200c784248c } /* Opcode */
		$op731 = { 534c4100c781a8020000dd284100c781 } /* Opcode */
		$op732 = { ff75f8a1a87944005768b4c0430068cc } /* Opcode */
		$op733 = { 833dcc79440000750ac705cc7944009c } /* Opcode */
		$op734 = { 344400c78424ec02000010344400c784 } /* Opcode */
		$op735 = { 85c0753cff742424a1a879440068a82c } /* Opcode */
		$op736 = { 1cb44200c78424c0 } /* Opcode */
		$op737 = { 8d45e050ff75f4a1a8794400ff905402 } /* Opcode */
		$op738 = { c43b4400c78424b8 } /* Opcode */
		$op739 = { 595985c00f856506000068e0524300ff } /* Opcode */
		$op740 = { ff76088bf88d460c50a1a879440057ff } /* Opcode */
		$op741 = { 50a1a8794400ff500c84c0a1a8794400 } /* Opcode */
		$op742 = { 595985c0754f68b05c4300ff7588a1a8 } /* Opcode */
		$op743 = { 836508008365f8005959668b4e026649 } /* Opcode */
		$op744 = { 8bf033c0668945dc8d7ddeab6a08ff75 } /* Opcode */
		$op745 = { 904300c78424100600000c904300c784 } /* Opcode */
		$op746 = { 595985c00f858206000068c8524300ff } /* Opcode */
		$op747 = { 595985c07564a1a87944006858de4300 } /* Opcode */
		$op748 = { 59598945e88365cc008365e40068feff } /* Opcode */
		$op749 = { 85c074148d45d050a1a8794400ff90a4 } /* Opcode */
		$op750 = { a1a8794400566800100000ff7508ff90 } /* Opcode */
		$op751 = { 595985c00f85a8020000683c594300ff } /* Opcode */
		$op752 = { 515350a1a879440057ff90bc0100008b } /* Opcode */
		$op753 = { 374400c78424ac03000010374400c784 } /* Opcode */
		$op754 = { 895ddc895de0ff90bc02000085c00f85 } /* Opcode */
		$op755 = { 895ddc895de0ff90bc02000085c00f85 } /* Opcode */
		$op756 = { 68b8094400ff75fcff91600100008b0d } /* Opcode */
		$op757 = { 595985c0753668ec5b4300ff7588a1a8 } /* Opcode */
		$op758 = { ff90840100005f85c0740432c0c9c38b } /* Opcode */
		$op759 = { 84b44200c78424e4 } /* Opcode */
		$op760 = { 595985c00f8578040000681c544300ff } /* Opcode */
		$op761 = { 595985c00f85d9060000687c524300ff } /* Opcode */
		$op762 = { a8ad4300c7842484 } /* Opcode */
		$op763 = { 93364000c781640100006e984100a178 } /* Opcode */
		$op764 = { 78284300c78424f8 } /* Opcode */
		$op765 = { 8d8500feffff686c80430068ff } /* Opcode */
		$op766 = { a1a879440083c44056ff90e4030000a1 } /* Opcode */
		$op767 = { 83c41c894424146a01e99b0300008b44 } /* Opcode */
		$op768 = { 2e4300c7842470020000102e4300c784 } /* Opcode */
		$op769 = { a16ca04200c7411c1f4c41008981f8 } /* Opcode */
		$op770 = { f0174300c78424dc } /* Opcode */
		$op771 = { bc274300c78424c4 } /* Opcode */
		$op772 = { 59598b45c0050010000050a1a8794400 } /* Opcode */
		$op773 = { 595985c00f854c01000068f8564300ff } /* Opcode */
		$op774 = { 8d44242450ff74241ca1a8794400ff90 } /* Opcode */
		$op775 = { ff742434a1a879440068ac65430068bc } /* Opcode */
		$op776 = { 964300c78424cc0700000c964300c784 } /* Opcode */
		$op777 = { 33f6803d9379440000751aa1a8794400 } /* Opcode */
		$op778 = { 595985c00f85fa0100006830564300ff } /* Opcode */
		$op779 = { 8bf0a1a879440083c4108975fc85f675 } /* Opcode */
		$op780 = { a1a8794400686ce5430053ff9090 } /* Opcode */
		$op781 = { 59598d4de4515650538945f8895dfc53 } /* Opcode */
		$op782 = { acae4300c78424cc } /* Opcode */
		$op783 = { 48ee4200c7842490 } /* Opcode */
		$op784 = { 0faf459c8d7008a1a879440056ff750c } /* Opcode */
		$op785 = { 0cf94200c78424c4 } /* Opcode */
		$op786 = { 894424188d474450ff750ca1a8794400 } /* Opcode */
		$op787 = { 8b7d0ceb2550a1a8794400ff90e8 } /* Opcode */
		$op788 = { 85c00f85e905000057bffeff0000eb02 } /* Opcode */
		$op789 = { 595989463a85c074bc33ff8b46282bc7 } /* Opcode */
		$op790 = { 8bf08b450c6683385c59598975f87516 } /* Opcode */
		$op791 = { 8bf08b450c6683385c59598975f87516 } /* Opcode */
		$op792 = { 595985c00f857d0500006870534300ff } /* Opcode */
		$op793 = { 895de0895de4ff90bc0200008bf881ff } /* Opcode */
		$op794 = { bc6a4300c7842400010000cc6a4300c7 } /* Opcode */
		$op795 = { 84684300c78424a4 } /* Opcode */
		$op796 = { 85c00f84b4feffffff75f8a1a8794400 } /* Opcode */
		$op797 = { a1a87944006820de430053ff9090 } /* Opcode */
		$op798 = { e0ad4300c7842494 } /* Opcode */
		$op799 = { dcce4000c78130010000bd184000c781 } /* Opcode */
		$op800 = { 595985c00f854d020000ff75d8a1a879 } /* Opcode */
		$op801 = { 595985c00f85ca0300006880544300ff } /* Opcode */
		$op802 = { 5933db5989442410895c2414be80 } /* Opcode */
		$op803 = { 50a1a879440057689cc8430068acc843 } /* Opcode */
		$op804 = { ff75fca1a8794400576848c74300685c } /* Opcode */
		$op805 = { a1a879440068d45e440057ff90f40300 } /* Opcode */
		$op806 = { a1a879440056ff9080020000a1a87944 } /* Opcode */
		$op807 = { ff7424148bf0a1a879440056ff906003 } /* Opcode */
		$op808 = { a1a879440083c4485753ff902c010000 } /* Opcode */
		$op809 = { ff742420a1a8794400686866430053ff } /* Opcode */
		$op810 = { fcb24200c7842484 } /* Opcode */
		$op811 = { 834f28ff8367240059595e5b5fc9c355 } /* Opcode */
		$op812 = { 64ae4300c78424bc } /* Opcode */
		$op813 = { 50a1a8794400ff901c01000083c418a1 } /* Opcode */
		$op814 = { ff75108bf8ff750ca1a879440068185f } /* Opcode */
		$op815 = { 595985c00f8537010000a1a879440068 } /* Opcode */
		$op816 = { e4264300c7842488 } /* Opcode */
		$op817 = { ff45fc817dfc102700000f8ffe } /* Opcode */
		$op818 = { 595985c00f85a802000068a4554300ff } /* Opcode */
		$op819 = { a1a8794400683440430057ff90400100 } /* Opcode */
		$op820 = { 595985c00f856e02000068d8554300ff } /* Opcode */
		$op821 = { 568bf8a1a87944006a0057ff90780100 } /* Opcode */
		$op822 = { a1a879440068f0464300ff7508ff902c } /* Opcode */
		$op823 = { 595985c00f85c107000068f0514300ff } /* Opcode */
		$op824 = { 85c00f8444ffffff32dbeb02b301a1a8 } /* Opcode */
		$op825 = { 4c3b4400c7842484 } /* Opcode */
		$op826 = { 8bf8a1a87944005653897dfcff90b8 } /* Opcode */
		$op827 = { 0cef4200c78424c4 } /* Opcode */
		$op828 = { 8cb44200c78424e8 } /* Opcode */
		$op829 = { 59598d4c244c51575056894424248974 } /* Opcode */
		$op830 = { a0684300c78424a8 } /* Opcode */
		$op831 = { 10174300c78424a4 } /* Opcode */
		$op832 = { a1a879440068fc5e440057ff90f40300 } /* Opcode */
		$op833 = { ff742440a1a8794400680c634300681c } /* Opcode */
		$op834 = { ff75f0a1a87944005368d0c8430068e0 } /* Opcode */
		$op835 = { 8b46048b0d9c7944008988b4 } /* Opcode */
		$op836 = { f8ad4300c784249c } /* Opcode */
		$op837 = { 87194000c741487b614000c781b80300 } /* Opcode */
		$op838 = { 50ae4300c78424b4 } /* Opcode */
		$op839 = { 18af4300c78424f0 } /* Opcode */
		$op840 = { ff75f8a1a87944005356ff5014ff75f8 } /* Opcode */
		$op841 = { a8f84200c78424b0 } /* Opcode */
		$op842 = { 8d45fc50a1a8794400ff90f801000083 } /* Opcode */
		$op843 = { 8d45fc50a1a8794400ff90f801000083 } /* Opcode */
		$op844 = { 595985c00f854806000068f0524300ff } /* Opcode */
		$op845 = { a1a8794400685440430057ff90400100 } /* Opcode */
		$op846 = { bbd03f00003bf36a010f8e9f } /* Opcode */
		$op847 = { 85c07549a1a879440053ff74241868d8 } /* Opcode */
		$op848 = { 68cc574300ff75b8a1a8794400ff9090 } /* Opcode */
		$op849 = { 85c0754fa1a87944006a01ff74241c68 } /* Opcode */
		$op850 = { 9c3b4400c78424a8 } /* Opcode */
		$op851 = { ff742448a1a879440068e065430068e8 } /* Opcode */
		$op852 = { 5cf84200c784249c } /* Opcode */
		$op853 = { 6800080000ff75088945f0a1a8794400 } /* Opcode */
		$op854 = { 595985c00f85a3010000684c5a4300ff } /* Opcode */
		$op855 = { 88274300c78424b4 } /* Opcode */
		$op856 = { 24f84200c7842490 } /* Opcode */
		$op857 = { 85c00f84ddfeffffa1a87944005753ff } /* Opcode */
		$op858 = { 8b55f80fb6120fb63f8b450803d75981 } /* Opcode */
		$op859 = { 558beca1a879440083ec14538b5d0856 } /* Opcode */
		$op860 = { 24174300c78424a8 } /* Opcode */
		$op861 = { 8b75108b363bf30f8d92 } /* Opcode */
		$op862 = { 595985c00f852b0600006800534300ff } /* Opcode */
		$op863 = { 59598bf0a1a87944005668ff7f0000ff } /* Opcode */
		$op864 = { ec3b4400c78424c8 } /* Opcode */
		$op865 = { 689842430050a1a879440057ff905001 } /* Opcode */
		$op866 = { c4694300c78424dc } /* Opcode */
		$op867 = { 83c43885c00f85bb020000a1a8794400 } /* Opcode */
		$op868 = { 18f84200c784248c } /* Opcode */
		$op869 = { 0cb34200c7842488 } /* Opcode */
		$op870 = { 6818494300ff75088bf8a1a8794400ff } /* Opcode */
		$op871 = { e4b34200c78424b0 } /* Opcode */
		$op872 = { ff7604a1a8794400ff75fc5368145d44 } /* Opcode */
		$op873 = { 85c074148d45f450a1a8794400ff90a4 } /* Opcode */
		$op874 = { 668bd80fb70750a1a8794400ff90e8 } /* Opcode */
		$op875 = { 668bd80fb70750a1a8794400ff90e8 } /* Opcode */
		$op876 = { 83c410ff45fc8b45fc3b45f87caf5ba1 } /* Opcode */
		$op877 = { 6683780a3a0f85b6 } /* Opcode */
		$op878 = { 8bf8a1a879440083c41857c7071c0100 } /* Opcode */
		$op879 = { b8f84200c78424b4 } /* Opcode */
		$op880 = { 8944241833c066894424308d7c2432ab } /* Opcode */
		$op881 = { a1a8794400ff742434681080430056ff } /* Opcode */
		$op882 = { ff75fca1a8794400536888c743006898 } /* Opcode */
		$op883 = { a1a879440056ff9008020000a1a87944 } /* Opcode */
		$op884 = { 837d0c02598bf0598975f8750dff35c0 } /* Opcode */
		$op885 = { 10fa4200c784240001000024fa4200c7 } /* Opcode */
		$op886 = { 576800654400682865440056ff903c03 } /* Opcode */
		$op887 = { 8975e88975ecff90f8 } /* Opcode */
		$op888 = { 595985c00f8560050000687c534300ff } /* Opcode */
		$op889 = { 595985c00f852f0100006820574300ff } /* Opcode */
		$op890 = { 57ff75088945d8a1a8794400ff90b8 } /* Opcode */
		$op891 = { 59598945f88b45fcff308b45fc83c004 } /* Opcode */
		$op892 = { 59598945f88b45fcff308b45fc83c004 } /* Opcode */
		$op893 = { 5733ff397d7c0f84f5010000a1a87944 } /* Opcode */
		$op894 = { 681c5b4300ff7588a1a8794400ff9090 } /* Opcode */
		$op895 = { 8b55148b1285d20f8c1f0100000fbf70 } /* Opcode */
		$op896 = { 8946048b442418893083c40c8bc65ec3 } /* Opcode */
		$op897 = { 595985c075368b45a44050ff7590ff75 } /* Opcode */
		$op898 = { 344300c784243404000010344300c784 } /* Opcode */
		$op899 = { 04694300c78424bc } /* Opcode */
		$op900 = { 595985c00f851702000068f4594300ff } /* Opcode */
		$op901 = { 836004008320005959c3558beca1a879 } /* Opcode */
		$op902 = { 68c07344008945f0578d45f050a1a879 } /* Opcode */
		$op903 = { 8b75fca1a87944006a0056ff506483c4 } /* Opcode */
		$op904 = { 11654000c74164e7744000c741241a74 } /* Opcode */
		$op905 = { 59593bc37478a1a879440068c0e54300 } /* Opcode */
		$op906 = { 595985c00f85c8010000a1a879440068 } /* Opcode */
		$op907 = { 68745c4300ff7588a1a8794400ff9090 } /* Opcode */
		$op908 = { 595985c00f856f08000068a4514300ff } /* Opcode */
		$op909 = { 595985c00f8517020000681c564300ff } /* Opcode */
		$op910 = { ff35c87944008bf8a1a8794400688477 } /* Opcode */
		$op911 = { a0274300c78424bc } /* Opcode */
		$op912 = { 44174300c78424b0 } /* Opcode */
		$op913 = { 98174300c78424c0 } /* Opcode */
		$op914 = { 686c5b4300ff7588a1a8794400ff9090 } /* Opcode */
		$op915 = { 687c584300ff75b8a1a8794400ff9090 } /* Opcode */
		$op916 = { ff4424108d474450a1a8794400ff9098 } /* Opcode */
		$op917 = { ec164300c78424a0 } /* Opcode */
		$op918 = { 4c434400c78424ec } /* Opcode */
		$op919 = { 8b75108b363bf20f8dd5 } /* Opcode */
		$op920 = { 6834484300ff75088bf8a1a8794400ff } /* Opcode */
		$op921 = { 85c0753cff74242ca1a8794400683038 } /* Opcode */
		$op922 = { 1d4300c78424e00100000c1d4300c784 } /* Opcode */
		$op923 = { a1a87944006860e5430053ff9090 } /* Opcode */
		$op924 = { f8684300c78424b8 } /* Opcode */
		$op925 = { 595981ffd03f00008945f889380f8eb0 } /* Opcode */
		$op926 = { fcf74200c7842484 } /* Opcode */
		$op927 = { fec3660fb6c35959663b450c750232db } /* Opcode */
		$op928 = { 836424200089442428a100b042005959 } /* Opcode */
		$op929 = { 50a1a87944005668d06643005653ff90 } /* Opcode */
		$op930 = { 8b45f40145f02945ec83c40cff45fc8b } /* Opcode */
		$op931 = { 83c42c85c00f852e030000ff75100fb7 } /* Opcode */
		$op932 = { 6c694300c78424d0 } /* Opcode */
		$op933 = { 595985c00f857303000068d8544300ff } /* Opcode */
		$op934 = { 9cf84200c78424ac } /* Opcode */
		$op935 = { a8164300c7842494 } /* Opcode */
		$op936 = { ff45fc817dfce80300000f8fac } /* Opcode */
		$op937 = { e9adfeffffa1a87944006a006affff90 } /* Opcode */
		$op938 = { 33c0668944242c8d7c242eab66ab6810 } /* Opcode */
		$op939 = { fc414400c78424c0 } /* Opcode */
		$op940 = { a1a879440083c450ff75f85768e8c043 } /* Opcode */
		$op941 = { 59881daf794400ff0500b04200381daf } /* Opcode */
		$op942 = { d4ee4200c78424b0 } /* Opcode */
		$op943 = { 203c4400c78424d8 } /* Opcode */
	condition:
		( uint16(0) == 0x5a4d and filesize < 900KB and ( 5 of ($s*) )and 1 of ($op*) ) or ( all of them )
}
rule _370c433dd61ec21d2677cfe02ef93a5f32a2b50d_5bf48d77bade79f2421ae3d258fe8262c043fb8f_08bdf374b28b234e824797145206f4df79eac6ea_1 {
	meta:
		description = "Auto-generated rule - from files 370c433dd61ec21d2677cfe02ef93a5f32a2b50d.codex, 5bf48d77bade79f2421ae3d258fe8262c043fb8f.codex, 08bdf374b28b234e824797145206f4df79eac6ea.codex"
		author = "YarGen Rule Generator"
		reference = "not set"
		date = "2016-07-21"
		super_rule = 1
		hash1 = "29b4498ac81d654b52cd0a32bdf29ed955f046ef9db1e0eba7da47ab2f950a3e"
		hash2 = "84ab50a9e325f64a54d84fb6798d8e74f46c21fd8b935d6c47a44bb140effad9"
		hash3 = "3f326fb6a79842c657efa09b71ce5e46dc110dd324bfabfcd32730d86de0bcf5"
	strings:
		$s1 = ":$:+:2:9:@:G:N:U:\\:s:" fullword ascii
		$s2 = "6%6+606<6H6M6\\6b6g6v6}6" fullword ascii
		$s3 = "8\"8,818;8@8J8O8Y8^8h8m8w8" fullword ascii
		$s4 = "6 6'6.656<6C6J6Q6X6_6f6m6t6" fullword ascii
		$s5 = "4\"4)40474>4E4L4S4Z4a4h4" fullword ascii
		$s6 = "9\"9+91969?9E9J9S9\\9a9j9p9u9~9" fullword ascii
		$s7 = "9\"9'91999C9H9R9W9a9f9p9u9" fullword ascii
		$s8 = "4\"4(4-4<4B4G4S4_4d4s4y4~4" fullword ascii
		$s9 = "6\"6'6,6=6B6G6X6]6b6o6{6" fullword ascii
		$s10 = "?\"?/?4?B?G?L?Y?^?k?p?}?" fullword ascii
		$s11 = "3)31383>3C3L3R3W3c3i3n3w3}3" fullword ascii
		$s12 = ";&;+;5;:;D;I;S;X;b;j;t;y;" fullword ascii
		$s13 = "='=,=6=>=H=M=W=\\=a=m=r=w=" fullword ascii
		$s14 = ":!:*:/:9:>:H:P:Z:_:i:n:x:}:" fullword ascii
		$s15 = "3$3.383B3L3S3Z3a3h3o3v3}3" fullword ascii
		$s16 = "<$<.<3<=<B<L<Q<^<c<m<r<|<" fullword ascii
		$s17 = "31383?3F3M3T3[3b3i3p3w3~3" fullword ascii
		$s18 = "?*?1?8???F?M?T?[?b?i?p?w?" fullword ascii
		$s19 = "9!9(9/969=9D9K9R9Y9`9g9n9x9" fullword ascii
		$s20 = ":$:*:/:8:>:C:L:U:Z:c:i:n:w:|:" fullword ascii

		$op0 = { fc014300c78424f0 } /* Opcode */
		$op1 = { a1d860440068d0cd430053ff90200300 } /* Opcode */
		$op2 = { c7819c0300000ca64000c78124030000 } /* Opcode */
		$op3 = { 59395df8759d8d45fc505353538d45a8 } /* Opcode */
		$op4 = { 663bd875438bc62b450c8945fceb038b } /* Opcode */
		$op5 = { 895de4895de8ff901404000085c07d07 } /* Opcode */
		$op6 = { c82a4400c78424c8 } /* Opcode */
		$op7 = { 6c514300c7842498 } /* Opcode */
		$op8 = { d8014300c78424e0 } /* Opcode */
		$op9 = { 84a44200c78424e4 } /* Opcode */
		$op10 = { 59598b460485c0741250ff74240ca1d8 } /* Opcode */
		$op11 = { 33db83c4203bfb0f84a0 } /* Opcode */
		$op12 = { 83c4188945fc837dfc000f848f } /* Opcode */
		$op13 = { 74294400c784249c } /* Opcode */
		$op14 = { 04024300c78424f4 } /* Opcode */
		$op15 = { 50974300c78424d0 } /* Opcode */
		$op16 = { 68feff0000ff7508ff90040200008945 } /* Opcode */
		$op17 = { 59ff75eca1d8604400680cb1430056ff } /* Opcode */
		$op18 = { 59385d0c0f844e010000535357575756 } /* Opcode */
		$op19 = { ecdd4200c78424d4 } /* Opcode */
		$op20 = { a1d86044008d5f106894c6430053ff90 } /* Opcode */
		$op21 = { bf300e440057894df0ff904002000059 } /* Opcode */
		$op22 = { 24244400c78424ac } /* Opcode */
		$op23 = { ff90a80300003d220000c00f8586 } /* Opcode */
		$op24 = { a1d860440057ff7508ff909001000033 } /* Opcode */
		$op25 = { 598d45b450a1d8604400ff90e0030000 } /* Opcode */
		$op26 = { a1d86044005653ff742424ff90d40300 } /* Opcode */
		$op27 = { 0cdd4200c7842498 } /* Opcode */
		$op28 = { 8975ec8975f0ff90a8030000f7d81bc0 } /* Opcode */
		$op29 = { 88114300c78424c4 } /* Opcode */
		$op30 = { 18244400c78424a4 } /* Opcode */
		$op31 = { 3cdd4200c78424a0 } /* Opcode */
		$op32 = { 83c40c894590ff75a4ff75ac8b4590ff } /* Opcode */
		$op33 = { a1d86044006a0068f0c84300ff7508ff } /* Opcode */
		$op34 = { 6c124300c78424000100007c124300c7 } /* Opcode */
		$op35 = { 3935046144000f85c6 } /* Opcode */
		$op36 = { 59a1d8604400566a00ff75f0ff90d403 } /* Opcode */
		$op37 = { 542b4400c78424dc } /* Opcode */
		$op38 = { a0294400c78424a4 } /* Opcode */
		$op39 = { 83c4188945fc837dfc000f8404010000 } /* Opcode */
		$op40 = { 8d45e050ff75f4a1d8604400ff90d8 } /* Opcode */
		$op41 = { 598d44000250ff751433db43536a008d } /* Opcode */
		$op42 = { 58dd4200c78424a8 } /* Opcode */
		$op43 = { 53ff76088bf8a1d8604400ff90dc } /* Opcode */
		$op44 = { 53ff76088bf8a1d8604400ff90dc } /* Opcode */
		$op45 = { 53ff76088bf8a1d8604400ff90dc } /* Opcode */
		$op46 = { 54114300c78424b4 } /* Opcode */
		$op47 = { 83c420803de2604400007430ff74241c } /* Opcode */
		$op48 = { ff7604a1d8604400ff75fc5368b04444 } /* Opcode */
		$op49 = { 59a1d8604400566a0053ff90d4030000 } /* Opcode */
		$op50 = { 3d230000c0740b3d050000800f85c7 } /* Opcode */
		$op51 = { a1d86044008b80d402000083c40c3bc3 } /* Opcode */
		$op52 = { 83c40c5f5e5b8be55dc3558bec83ec28 } /* Opcode */
		$op53 = { 68fc404300ff75b8a1d8604400ff9020 } /* Opcode */
		$op54 = { 8d4744688c4a430050a1d8604400ff90 } /* Opcode */
		$op55 = { 50a1d86044005668604d43005653ff90 } /* Opcode */
		$op56 = { 5932c0eb628a451057ff750c88068d46 } /* Opcode */
		$op57 = { 44e84200c78424d8 } /* Opcode */
		$op58 = { 50e74200c78424a8 } /* Opcode */
		$op59 = { e0244400c78424ec } /* Opcode */
		$op60 = { a1d860440068a0c6430053ff90200300 } /* Opcode */
		$op61 = { e0524300c78424d8 } /* Opcode */
		$op62 = { 895e10895e14ff901404000085c0742a } /* Opcode */
		$op63 = { 83c40c68fc6943008d45c050a1d86044 } /* Opcode */
		$op64 = { 83c40c5e5f5bc9c3558bec8b4d088a01 } /* Opcode */
		$op65 = { 54a34200c7842494 } /* Opcode */
		$op66 = { 8b7c2410a1d860440083c744c70424c8 } /* Opcode */
		$op67 = { 595f5e5bc9c3558bec83ec0ca1d86044 } /* Opcode */
		$op68 = { e0114300c78424dc } /* Opcode */
		$op69 = { 595984c00f85e80b0000a1d860440056 } /* Opcode */
		$op70 = { 9c964300c78424a4 } /* Opcode */
		$op71 = { c4004300c78424a0 } /* Opcode */
		$op72 = { 4003c050ff742414a1d8604400ff9004 } /* Opcode */
		$op73 = { 02724100c78110040000fd234100c781 } /* Opcode */
		$op74 = { 83c40c8b45fc8b4df489086881 } /* Opcode */
		$op75 = { 598d45f450a1d8604400ff90b8030000 } /* Opcode */
		$op76 = { 1a9f4100c781fc03000021224100c781 } /* Opcode */
		$op77 = { 83c410eb0233c05b5f5e5dc3558bec83 } /* Opcode */
		$op78 = { f0e74200c78424cc } /* Opcode */
		$op79 = { 6a085933c0897dcc8d7dd0f3ab8d45f4 } /* Opcode */
		$op80 = { 83c4208d44241850a1d8604400ff90b8 } /* Opcode */
		$op81 = { 598d44000250536a01568d45ec50ff75 } /* Opcode */
		$op82 = { 598d44000250536a01568d45ec50ff75 } /* Opcode */
		$op83 = { 83c42ca1d860440057689ca9430068c0 } /* Opcode */
		$op84 = { 595f5ec9c3a1d86044006a00ff74240c } /* Opcode */
		$op85 = { 59a1d860440056ff90dc020000a1d860 } /* Opcode */
		$op86 = { 942b4400c78424e4 } /* Opcode */
		$op87 = { ff37a1d8604400ff9098 } /* Opcode */
		$op88 = { ff37a1d8604400ff9098 } /* Opcode */
		$op89 = { 34124300c78424f4 } /* Opcode */
		$op90 = { bca44200c78424f8 } /* Opcode */
		$op91 = { a1d860440057ff9098 } /* Opcode */
		$op92 = { 85c075078b45cc488945ccff75bcff75 } /* Opcode */
		$op93 = { a1d860440068e0cd430053ff90200300 } /* Opcode */
		$op94 = { 70e84200c78424e4 } /* Opcode */
		$op95 = { 60964300c7842490 } /* Opcode */
		$op96 = { d8234400c7842488 } /* Opcode */
		$op97 = { 83c40c6844424300ff7588a1d8604400 } /* Opcode */
		$op98 = { 83c40c8d45dc50568d45fc50a1d86044 } /* Opcode */
		$op99 = { 8d45dc5068000108008d45fc50a1d860 } /* Opcode */
		$op100 = { 83c4148945f4ff75f0ff7508a1d86044 } /* Opcode */
		$op101 = { 30514300c7842490 } /* Opcode */
		$op102 = { ff75fca1d860440056ff90e4030000ff } /* Opcode */
		$op103 = { 895c245c895c2460ff90a803000085c0 } /* Opcode */
		$op104 = { 1c254400c784240001000028254400c7 } /* Opcode */
		$op105 = { 59a1d8604400566a0057ff90d4030000 } /* Opcode */
		$op106 = { 7b4300c78424a8060000107b4300c784 } /* Opcode */
		$op107 = { 8b4dfc8b0481050410000050a1d86044 } /* Opcode */
		$op108 = { 81f9d03f00000f8e96 } /* Opcode */
		$op109 = { a1d8604400680446440057ff50405959 } /* Opcode */
		$op110 = { e934feffff558bec83ec746a1d8d458c } /* Opcode */
		$op111 = { 88974300c78424e4 } /* Opcode */
		$op112 = { 102a4400c78424b0 } /* Opcode */
		$op113 = { 10514300c7842488 } /* Opcode */
		$op114 = { 83c40c5f5e5b8be55dc3558bec83ec14 } /* Opcode */
		$op115 = { b4dd4200c78424c4 } /* Opcode */
		$op116 = { 20974300c78424c4 } /* Opcode */
		$op117 = { 8b50245685d20f8ee2 } /* Opcode */
		$op118 = { 8ca44200c78424e8 } /* Opcode */
		$op119 = { e0284400c7842488 } /* Opcode */
		$op120 = { f61c4000c7412cbb584100c781100300 } /* Opcode */
		$op121 = { 08114300c78424a0 } /* Opcode */
		$op122 = { 83c40c5b5f5ec9c3558bec83ec348365 } /* Opcode */
		$op123 = { fca24200c7842484 } /* Opcode */
		$op124 = { 4c534300c78424e4 } /* Opcode */
		$op125 = { c605c160440001892dcc6044008925c8 } /* Opcode */
		$op126 = { c605c160440001892dcc6044008925c8 } /* Opcode */
		$op127 = { a0244400c78424d8 } /* Opcode */
		$op128 = { e95ffeffffa1d860440053576864a042 } /* Opcode */
		$op129 = { 4ca54000c741143c574100c7819c0200 } /* Opcode */
		$op130 = { 814300c78424780800000c814300c784 } /* Opcode */
		$op131 = { c0964300c78424ac } /* Opcode */
		$op132 = { 44244400c78424b8 } /* Opcode */
		$op133 = { ff742410a1d860440053ff9090010000 } /* Opcode */
		$op134 = { ff742410a1d860440053ff9090010000 } /* Opcode */
		$op135 = { 44114300c78424b0 } /* Opcode */
		$op136 = { f0234400c7842490 } /* Opcode */
		$op137 = { 18114300c78424a4 } /* Opcode */
		$op138 = { 744300c78424c004000014744300c784 } /* Opcode */
		$op139 = { 83c4188945fc837dfc00752a6880 } /* Opcode */
		$op140 = { ccdd4200c78424cc } /* Opcode */
		$op141 = { 595b5f5ec9c3558bec535633f633db33 } /* Opcode */
		$op142 = { b0de4200c78424fc } /* Opcode */
		$op143 = { fc114300c78424e4 } /* Opcode */
		$op144 = { fc104300c784249c } /* Opcode */
		$op145 = { 8c744000c74108501e4100c781e0 } /* Opcode */
		$op146 = { a1d8604400895dfcff50108945f8a1d8 } /* Opcode */
		$op147 = { 2c534300c78424e0 } /* Opcode */
		$op148 = { 88524300c78424cc } /* Opcode */
		$op149 = { b0284400c7842484 } /* Opcode */
		$op150 = { 83c41089450885c0751b3945fc0f845d } /* Opcode */
		$op151 = { f4524300c78424dc } /* Opcode */
		$op152 = { 50de4200c78424ec } /* Opcode */
		$op153 = { 094300c784247002000014094300c784 } /* Opcode */
		$op154 = { 8b4e2485c90f84e6 } /* Opcode */
		$op155 = { 14254400c78424fc } /* Opcode */
		$op156 = { d8104300c7842490 } /* Opcode */
		$op157 = { 895c2464895c2468ff90a803000085c0 } /* Opcode */
		$op158 = { 895c2464895c2468ff90a803000085c0 } /* Opcode */
		$op159 = { 0f825affffff5f5e8be55dc3568b7424 } /* Opcode */
		$op160 = { 104000c7819c010000a1a04100c78124 } /* Opcode */
		$op161 = { 6c244400c78424c8 } /* Opcode */
		$op162 = { 542a4400c78424bc } /* Opcode */
		$op163 = { 83c414e965020000f645144175158b45 } /* Opcode */
		$op164 = { 3d220000c0740732c0e9c8 } /* Opcode */
		$op165 = { b4514300c78424a4 } /* Opcode */
		$op166 = { b0964300c78424a8 } /* Opcode */
		$op167 = { a1d86044005653ff742420ff90d40300 } /* Opcode */
		$op168 = { 593974241c742cff742418a1d8604400 } /* Opcode */
		$op169 = { 83c41884c00f849f020000ff75100fb7 } /* Opcode */
		$op170 = { 8b4f3a8945f88d440104b96462000066 } /* Opcode */
		$op171 = { 6e4300c7842428030000086e4300c784 } /* Opcode */
		$op172 = { 894da4ff90380100008d45dc8945bc8d } /* Opcode */
		$op173 = { a1d860440068c0304300ff7508ff9044 } /* Opcode */
		$op174 = { c8974300c7842400010000d8974300c7 } /* Opcode */
		$op175 = { a54200c784240801000010a54200c784 } /* Opcode */
		$op176 = { 59ff742420a1d86044005653ff906402 } /* Opcode */
		$op177 = { 9ce84200c78424f0 } /* Opcode */
		$op178 = { 13a24000898180010000c74150645a40 } /* Opcode */
		$op179 = { a1d860440053ff7508ff900402000068 } /* Opcode */
		$op180 = { 96144100c781b401000026b14000c781 } /* Opcode */
		$op181 = { ff7604a1d8604400ff75fc5368d04444 } /* Opcode */
		$op182 = { 83c40cff75bcff75bc0fb705e8604400 } /* Opcode */
		$op183 = { ff75f8a1d8604400ff7508ff90900100 } /* Opcode */
		$op184 = { 8b463aff750c03c78b40100504100000 } /* Opcode */
		$op185 = { 8b413c3bc30f84e0 } /* Opcode */
		$op186 = { 6810414300ff75b8a1d8604400ff9020 } /* Opcode */
		$op187 = { c0974300c78424fc } /* Opcode */
		$op188 = { 6a418d45d05f8945f8c745f020 } /* Opcode */
		$op189 = { 80751583780800740fa1d86044005756 } /* Opcode */
		$op190 = { 80974300c78424e0 } /* Opcode */
		$op191 = { 984300c78424100100000c984300c784 } /* Opcode */
		$op192 = { 184300c784247c0200000c184300c784 } /* Opcode */
		$op193 = { 6898404300ff75b8a1d8604400ff9020 } /* Opcode */
		$op194 = { 03c02b45c8590345f883e0fe83f80c75 } /* Opcode */
		$op195 = { 8bd8595985db0f848d } /* Opcode */
		$op196 = { 83c42085ff750583c8ffeb258b463a8d } /* Opcode */
		$op197 = { c8534300c78424f4 } /* Opcode */
		$op198 = { a1d8604400687822440056ff90f0 } /* Opcode */
		$op199 = { 83c4145e32c05bc9c3558bec83ec24a1 } /* Opcode */
		$op200 = { 83c40ceb65e82ac200003d0d0000c0e9 } /* Opcode */
		$op201 = { 68682c430050a1d860440057ff902c03 } /* Opcode */
		$op202 = { 04e74200c7842494 } /* Opcode */
		$op203 = { 83c430ff45f847ff4df00f855affffff } /* Opcode */
		$op204 = { a1d860440068eccd430053ff90200300 } /* Opcode */
		$op205 = { 8364241800c70500a04200222700008b } /* Opcode */
		$op206 = { 8ca34200c78424a0 } /* Opcode */
		$op207 = { 685c2b430050a1d860440053ff902c03 } /* Opcode */
		$op208 = { 8bf08d45f850a1d8604400ff90b80300 } /* Opcode */
		$op209 = { a1d8604400684846440057ff50405959 } /* Opcode */
		$op210 = { 598d44245050a1d8604400ff90e00300 } /* Opcode */
		$op211 = { ff75148b45fc83c00450ff750ca1d860 } /* Opcode */
		$op212 = { 8975b88975bcff90a803000085c00f85 } /* Opcode */
		$op213 = { a1d8604400ff742434681069430056ff } /* Opcode */
		$op214 = { 83c4148945f8ff75ecff7508a1d86044 } /* Opcode */
		$op215 = { 0c254400c78424f8 } /* Opcode */
		$op216 = { 80de4200c78424f4 } /* Opcode */
		$op217 = { a1d8604400536800080000ff7508ff90 } /* Opcode */
		$op218 = { 895de0895de4ff901404000089450c3d } /* Opcode */
		$op219 = { 8b4f3a8b55f88365fc008945f40500f0 } /* Opcode */
		$op220 = { 154300c78424b401000010154300c784 } /* Opcode */
		$op221 = { 1b4400c7842498020000181b4400c784 } /* Opcode */
		$op222 = { 83c41084c00f85030c0000a1d8604400 } /* Opcode */
		$op223 = { 83c0083bc30f84ab } /* Opcode */
		$op224 = { 342c4400c7842400010000442c4400c7 } /* Opcode */
		$op225 = { 83c4188d45f050a1d8604400ff90f8 } /* Opcode */
		$op226 = { ff4424148d474450a1d8604400ff9008 } /* Opcode */
		$op227 = { a1d860440068b42e43005653ff903002 } /* Opcode */
		$op228 = { 9c524300c78424d0 } /* Opcode */
		$op229 = { b8a0604400bf34a042002bc78945e40f } /* Opcode */
		$op230 = { 5c014300c78424bc } /* Opcode */
		$op231 = { 83c41485c0740cc7461002 } /* Opcode */
		$op232 = { 837d0c007505e990 } /* Opcode */
		$op233 = { 14e74200c7842498 } /* Opcode */
		$op234 = { f11c4100c7812c020000b31f4100c781 } /* Opcode */
		$op235 = { a1d860440056ff750cff9098 } /* Opcode */
		$op236 = { 83c40cff75fcff7508a1d8604400ff90 } /* Opcode */
		$op237 = { 83c40cff75fcff7508a1d8604400ff90 } /* Opcode */
		$op238 = { 83c40cff75fcff7508a1d8604400ff90 } /* Opcode */
		$op239 = { 0c294400c784248c } /* Opcode */
		$op240 = { 40974300c78424cc } /* Opcode */
		$op241 = { 6e1a4100c78164010000cbc74000c781 } /* Opcode */
		$op242 = { d82a4400c78424cc } /* Opcode */
		$op243 = { 64244400c78424c4 } /* Opcode */
		$op244 = { 83c4188945fc837dfc00746c8b45fc81 } /* Opcode */
		$op245 = { 8975d8894ddc8975e48975e8ff901404 } /* Opcode */
		$op246 = { 03c02b45cc590345f883e0fe83f80874 } /* Opcode */
		$op247 = { ec2b4400c78424f4 } /* Opcode */
		$op248 = { 50a1d8604400ff90a402000083c418a1 } /* Opcode */
		$op249 = { 6f4300c78424640300000c6f4300c784 } /* Opcode */
		$op250 = { 8b750c8b50048b4f3a83c40c8945d089 } /* Opcode */
		$op251 = { 7ca44200c78424e0 } /* Opcode */
		$op252 = { 8b45fc0fb7400483f8250f85d9 } /* Opcode */
		$op253 = { 7ce74200c78424b0 } /* Opcode */
		$op254 = { 8975e88975ecff90800300005f8b45fc } /* Opcode */
		$op255 = { 8945f08d45d050a1d8604400ff90b803 } /* Opcode */
		$op256 = { e4234400c784248c } /* Opcode */
		$op257 = { 5c124300c78424fc } /* Opcode */
		$op258 = { ff7604a1d8604400ff75fc53688c4444 } /* Opcode */
		$op259 = { cce84200c78424fc } /* Opcode */
		$op260 = { 83c40c8d5c4302a1d860440057ff9098 } /* Opcode */
		$op261 = { f4a34200c78424b4 } /* Opcode */
		$op262 = { 83c4148945fcff75f8ff7508a1d86044 } /* Opcode */
		$op263 = { 83c4188364240c00c7442438a8124400 } /* Opcode */
		$op264 = { 1641008b151c9042008991180400008b } /* Opcode */
		$op265 = { bc2b4400c78424e8 } /* Opcode */
		$op266 = { ec104300c7842498 } /* Opcode */
		$op267 = { 5768304c440068584c440056ff5024a1 } /* Opcode */
		$op268 = { 68e8414300ff75b8a1d8604400ff9020 } /* Opcode */
		$op269 = { cca44200c78424fc } /* Opcode */
		$op270 = { 50244400c78424bc } /* Opcode */
		$op271 = { 8f4300c78424780c0000108f4300c784 } /* Opcode */
		$op272 = { 5903c0508d8500feffff5068c0694300 } /* Opcode */
		$op273 = { 0faf459c8d7008a1d860440056ff750c } /* Opcode */
		$op274 = { ec534300c7842400010000fc534300c7 } /* Opcode */
		$op275 = { 56ff75088ad8a1d8604400ff90900100 } /* Opcode */
		$op276 = { 663bd8740a46460fb7066685c075d333 } /* Opcode */
		$op277 = { 83c4145f5e5b8be55dc3cccccccccccc } /* Opcode */
		$op278 = { a1d8604400682c46440057ff50405959 } /* Opcode */
		$op279 = { c8014300c78424dc } /* Opcode */
		$op280 = { a82a4400c78424c4 } /* Opcode */
		$op281 = { a1d86044006814ce430053ff90200300 } /* Opcode */
		$op282 = { 402a4400c78424b8 } /* Opcode */
		$op283 = { 98e74200c78424b4 } /* Opcode */
		$op284 = { 395814eb34a1d860440057ff75f456ff } /* Opcode */
		$op285 = { 6c114300c78424bc } /* Opcode */
		$op286 = { 57ff751056ff90b8 } /* Opcode */
		$op287 = { 684c454300ff7588a1d8604400ff9020 } /* Opcode */
		$op288 = { 8b4dfc8d044150ff7514b8001000002b } /* Opcode */
		$op289 = { ec244400c78424f0 } /* Opcode */
		$op290 = { 60524300c78424c0 } /* Opcode */
		$op291 = { a1d860440068002a430057ff90c40300 } /* Opcode */
		$op292 = { 48964300c784248c } /* Opcode */
		$op293 = { 33f6803dc360440000751aa1d8604400 } /* Opcode */
		$op294 = { 54e84200c78424dc } /* Opcode */
		$op295 = { a1d860440056536a0468f8904200ff90 } /* Opcode */
		$op296 = { 558bec83e4f881ec8c } /* Opcode */
		$op297 = { 8b45f483c00450ff7508a1d8604400ff } /* Opcode */
		$op298 = { 64de4200c78424f0 } /* Opcode */
		$op299 = { c78120040000ba4241008b15b8904200 } /* Opcode */
		$op300 = { 8b46048b0dcc6044008988b4 } /* Opcode */
		$op301 = { 6860f24300ff75fcff91500300008b0d } /* Opcode */
		$op302 = { 894300c78424b40a00000c894300c784 } /* Opcode */
		$op303 = { 684c444300ff7588a1d8604400ff9020 } /* Opcode */
		$op304 = { a1d86044005653ff742418ff90d40300 } /* Opcode */
		$op305 = { 895dd4897ddc895de0895de4ff901404 } /* Opcode */
		$op306 = { 1c244400c78424a8 } /* Opcode */
		$op307 = { 6864444300ff7588a1d8604400ff9020 } /* Opcode */
		$op308 = { 24014300c78424b4 } /* Opcode */
		$op309 = { a1d860440068accd4300ff75f8ff9020 } /* Opcode */
		$op310 = { 48004300c7842484 } /* Opcode */
		$op311 = { c0dd4200c78424c8 } /* Opcode */
		$op312 = { 83c41c803de260440000742cff750ca1 } /* Opcode */
		$op313 = { 8b45f88038030f858d } /* Opcode */
		$op314 = { 0c124300c78424e8 } /* Opcode */
		$op315 = { 18024300c78424f8 } /* Opcode */
		$op316 = { 59b001c9c38b4c24048b513a33c033c9 } /* Opcode */
		$op317 = { 78974300c78424dc } /* Opcode */
		$op318 = { 8c014300c78424cc } /* Opcode */
		$op319 = { 5959837df400750cc605c160440000e9 } /* Opcode */
		$op320 = { 508d44245450a1d8604400c744245818 } /* Opcode */
		$op321 = { 084300c784243002000010084300c784 } /* Opcode */
		$op322 = { b4114300c78424d0 } /* Opcode */
		$op323 = { 70964300c7842494 } /* Opcode */
		$op324 = { d0964300c78424b0 } /* Opcode */
		$op325 = { 28124300c78424f0 } /* Opcode */
		$op326 = { 895c2464895c2468ff90140400003d22 } /* Opcode */
		$op327 = { 5933c03bfb0f94c05f5e5bc9c3cccccc } /* Opcode */
		$op328 = { c9c3558bec83ec3c6a0f8d45c450ff75 } /* Opcode */
		$op329 = { 5c294400c7842498 } /* Opcode */
		$op330 = { ff75106a00ff750ca1d8604400ff90b8 } /* Opcode */
		$op331 = { ff75106a00ff750ca1d8604400ff90b8 } /* Opcode */
		$op332 = { 59b0015f5e5bc9c3558bec8b450c85c0 } /* Opcode */
		$op333 = { 20e74200c784249c } /* Opcode */
		$op334 = { 8975dc8975e08975f4ff90800300008b } /* Opcode */
		$op335 = { e4dc4200c784248c } /* Opcode */
		$op336 = { a1d860440056ff90fc020000a1d86044 } /* Opcode */
		$op337 = { a1d860440068f045440057ff50405959 } /* Opcode */
		$op338 = { 595f5ec9c3558bec83ec70535733db33 } /* Opcode */
		$op339 = { 204400c78424cc03000018204400c784 } /* Opcode */
		$op340 = { 895dcc894dd0895dd8895ddcff901404 } /* Opcode */
		$op341 = { 8d7c47028d4702593b450c729f43438b } /* Opcode */
		$op342 = { 8a45ff595bc9c3cc558bec83e4f881ec } /* Opcode */
		$op343 = { 8b46048b0dc86044008988c4 } /* Opcode */
		$op344 = { 598d45ec50a1d8604400ff90f8 } /* Opcode */
		$op345 = { 854300c784249809000014854300c784 } /* Opcode */
		$op346 = { 8b463a0345fc50a1d8604400ff907802 } /* Opcode */
		$op347 = { 8d44242450ff74241ca1d8604400ff90 } /* Opcode */
		$op348 = { 30244400c78424b0 } /* Opcode */
		$op349 = { 70004300c7842490 } /* Opcode */
		$op350 = { 08244400c784249c } /* Opcode */
		$op351 = { 1c124300c78424ec } /* Opcode */
		$op352 = { 8b45fc8338040f8ee9 } /* Opcode */
		$op353 = { f02a4400c78424d0 } /* Opcode */
		$op354 = { b0974300c78424f8 } /* Opcode */
		$op355 = { 9cdd4200c78424bc } /* Opcode */
		$op356 = { a0974300c78424f0 } /* Opcode */
		$op357 = { 598d45f4505656568d45cc50683f000f } /* Opcode */
		$op358 = { d8dd4200c78424d0 } /* Opcode */
		$op359 = { 59ff75f88b7d08a1d860440057ff9090 } /* Opcode */
		$op360 = { a1d86044006880fd420057ff90f0 } /* Opcode */
		$op361 = { 83c440ff75eca1d8604400576840b043 } /* Opcode */
		$op362 = { cc234400c7842484 } /* Opcode */
		$op363 = { 595056ff17a1d860440083c40c684853 } /* Opcode */
		$op364 = { 83c40c8b45f85e5f5bc9c38b54240456 } /* Opcode */
		$op365 = { 3cde4200c78424e8 } /* Opcode */
		$op366 = { 60a44200c78424d8 } /* Opcode */
		$op367 = { 668b4d0a663bc874c7464666833e000f } /* Opcode */
		$op368 = { 5959837dfc0074206880 } /* Opcode */
		$op369 = { 668bd80fb70750a1d8604400ff90e8 } /* Opcode */
		$op370 = { 668bd80fb70750a1d8604400ff90e8 } /* Opcode */
		$op371 = { fcb04000c78100010000a6c84000c781 } /* Opcode */
		$op372 = { 44e74200c78424a4 } /* Opcode */
		$op373 = { 83c428ff742418a1d86044005653ff90 } /* Opcode */
		$op374 = { f8294400c78424ac } /* Opcode */
		$op375 = { 78114300c78424c0 } /* Opcode */
		$op376 = { 59ff75f8a1d8604400ff7508ff909001 } /* Opcode */
		$op377 = { 59ff75f8a1d8604400ff7508ff909001 } /* Opcode */
		$op378 = { 59ff442410837c2410040f825affffff } /* Opcode */
		$op379 = { 8d45ec50ff75fca1d8604400ff9090 } /* Opcode */
		$op380 = { ff45f88d474450a1d8604400ff900804 } /* Opcode */
		$op381 = { ff45f88d474450a1d8604400ff900804 } /* Opcode */
		$op382 = { 44a44200c78424d0 } /* Opcode */
		$op383 = { a1d8604400538b5d08565768feff0000 } /* Opcode */
		$op384 = { 08014300c78424ac } /* Opcode */
		$op385 = { 8d47fc50a1d860440053ff504c83c424 } /* Opcode */
		$op386 = { bce74200c78424c0 } /* Opcode */
		$op387 = { 83c410eb098d430881ce } /* Opcode */
		$op388 = { ff74241ca1d8604400ff7508ff909001 } /* Opcode */
		$op389 = { 8975d88975e48975e8ff901404000053 } /* Opcode */
		$op390 = { 8945088b45c083c41085c0740d8b4f3a } /* Opcode */
		$op391 = { c4de4200c7842400010000e0de4200c7 } /* Opcode */
		$op392 = { 83c41885f6750732c05f5e5bc9c38d46 } /* Opcode */
		$op393 = { 44294400c7842494 } /* Opcode */
		$op394 = { b0a44200c78424f4 } /* Opcode */
		$op395 = { ff90380100008d44242c894424588d84 } /* Opcode */
		$op396 = { ac004300c784249c } /* Opcode */
		$op397 = { ff7604a1d8604400ff75fc53689c4444 } /* Opcode */
		$op398 = { b0104300c7842488 } /* Opcode */
		$op399 = { d8594000c78148030000fd2b4100c781 } /* Opcode */
		$op400 = { dca44200c7842400010000eca44200c7 } /* Opcode */
		$op401 = { 74a44200c78424dc } /* Opcode */
		$op402 = { ff901404000085c0a1d86044007412ff } /* Opcode */
		$op403 = { 21ab4000c74134e3384100c7417c832b } /* Opcode */
		$op404 = { 895c2440895c2444ff90240400005959 } /* Opcode */
		$op405 = { a0a44200c78424f0 } /* Opcode */
		$op406 = { 80964300c784249c } /* Opcode */
		$op407 = { 10244400c78424a0 } /* Opcode */
		$op408 = { 72b3ff75f8a1d8604400ff7508ff9090 } /* Opcode */
		$op409 = { ace84200c78424f4 } /* Opcode */
		$op410 = { 578b7d088d45fe508b450cff34b0a1d8 } /* Opcode */
		$op411 = { 764300c784244805000010764300c784 } /* Opcode */
		$op412 = { 8975e48975e8ff90140400003d220000 } /* Opcode */
		$op413 = { 817c2410102700000f8fd8 } /* Opcode */
		$op414 = { 804300c784242008000008804300c784 } /* Opcode */
		$op415 = { 6884444300ff7588a1d8604400ff9020 } /* Opcode */
		$op416 = { a8dd4200c78424c0 } /* Opcode */
		$op417 = { 78964300c7842498 } /* Opcode */
		$op418 = { 598d44000250566a026a008d45f050ff } /* Opcode */
		$op419 = { 83c40c834b0c048b075e5b5fc9c3558b } /* Opcode */
		$op420 = { 174400c784249801000014174400c784 } /* Opcode */
		$op421 = { e8004300c78424a4 } /* Opcode */
		$op422 = { d4114300c78424d8 } /* Opcode */
		$op423 = { 56ff75148bf8a1d8604400ff90900100 } /* Opcode */
		$op424 = { e0514300c78424ac } /* Opcode */
		$op425 = { 08a44200c78424b8 } /* Opcode */
		$op426 = { 5959c605c1604400005fc9c3837c2408 } /* Opcode */
		$op427 = { 80104300c7842484 } /* Opcode */
		$op428 = { 8bf803ff8d471450ff7514a1d8604400 } /* Opcode */
		$op429 = { e9adfeffffa1d860440053576850a042 } /* Opcode */
		$op430 = { 83c4148bc65ec3558bec83ec7033c056 } /* Opcode */
		$op431 = { a1d8604400ff0500a04200536a0356ff } /* Opcode */
		$op432 = { 897dc4897dc8ff905001000085c00f85 } /* Opcode */
		$op433 = { 5733ff397d7c0f84ea010000a1d86044 } /* Opcode */
		$op434 = { 94244400c78424d4 } /* Opcode */
		$op435 = { 3d230000c0740b3d050000800f85df } /* Opcode */
		$op436 = { 68e4404300ff75b8a1d8604400ff9020 } /* Opcode */
		$op437 = { a1d8604400681846440057ff50405959 } /* Opcode */
		$op438 = { 5150a1d8604400ff9004020000595981 } /* Opcode */
		$op439 = { 598ac3ebaab301ebe8568b7424088b46 } /* Opcode */
		$op440 = { 6868454300ff7588a1d8604400ff9020 } /* Opcode */
		$op441 = { a1949042008981b0030000a170904200 } /* Opcode */
		$op442 = { a8974300c78424f4 } /* Opcode */
		$op443 = { 595056ff1783c40ca1d860440056ff90 } /* Opcode */
		$op444 = { 8d44240c50a1d8604400ff90f8 } /* Opcode */
		$op445 = { 8d44240c50a1d8604400ff90f8 } /* Opcode */
		$op446 = { 33db3bc30f84f30100008b40103bc30f } /* Opcode */
		$op447 = { 568d441b0250ff7514a1d8604400ff90 } /* Opcode */
		$op448 = { 98974300c78424ec } /* Opcode */
		$op449 = { 83c430833d0461440005751ba1d86044 } /* Opcode */
		$op450 = { 204300c78424d804000010204300c784 } /* Opcode */
		$op451 = { 8b48103bcb0f84eb } /* Opcode */
		$op452 = { 934300c78424840d000004934300c784 } /* Opcode */
		$op453 = { 593bf37415e943ffffff8d450c50a1d8 } /* Opcode */
		$op454 = { 24514300c784248c } /* Opcode */
		$op455 = { 1c2c4400c78424fc } /* Opcode */
		$op456 = { 83c41885c0740cc7461001 } /* Opcode */
		$op457 = { 598bc65f5ec9c3558bec51a1d8604400 } /* Opcode */
		$op458 = { 83c40c6a0a83c71057568d45ec50ff75 } /* Opcode */
		$op459 = { ff4424108d474450a1d8604400ff9008 } /* Opcode */
		$op460 = { 8b45fc8b008d44000250ff7508a1d860 } /* Opcode */
		$op461 = { 6a01ff75acff75f46a00ff750ca1d860 } /* Opcode */
		$op462 = { 8974247489742478ff901404000085c0 } /* Opcode */
		$op463 = { 8974247489742478ff901404000085c0 } /* Opcode */
		$op464 = { e4964300c78424b8 } /* Opcode */
		$op465 = { 8bd883c41885db0f840c010000a1d860 } /* Opcode */
		$op466 = { 3b0508614400751b8b4604ff80b8 } /* Opcode */
		$op467 = { 194300c78424c40200000c194300c784 } /* Opcode */
		$op468 = { d0514300c78424a8 } /* Opcode */
		$op469 = { 48514300c7842494 } /* Opcode */
		$op470 = { c8114300c78424d4 } /* Opcode */
		$op471 = { ff75f4a1d860440068c843440056ff75 } /* Opcode */
		$op472 = { f4514300c78424b0 } /* Opcode */
		$op473 = { 50a1d860440051ff9004020000836508 } /* Opcode */
		$op474 = { 164400c784244c0100000c164400c784 } /* Opcode */
		$op475 = { 83c4188d44242050a1d8604400ff90b8 } /* Opcode */
		$op476 = { 54a44200c78424d4 } /* Opcode */
		$op477 = { a4e74200c78424b8 } /* Opcode */
		$op478 = { a1d860440068e829430057ff90c40300 } /* Opcode */
		$op479 = { a1d8604400682012440056ff90f0 } /* Opcode */
		$op480 = { a1d860440068202a430057ff90c40300 } /* Opcode */
		$op481 = { 6c534300c78424e8 } /* Opcode */
		$op482 = { 59a1d860440053ff7508ff9090010000 } /* Opcode */
		$op483 = { 59ff442414817c2414af0100000f8276 } /* Opcode */
		$op484 = { 2c974300c78424c8 } /* Opcode */
		$op485 = { c7430c20020000895df0ff90c0030000 } /* Opcode */
		$op486 = { a138904200898160020000a1c0904200 } /* Opcode */
		$op487 = { 593bfe7415a1d860440053ff7508ff90 } /* Opcode */
		$op488 = { 83c40c5f8ac35ee9e7feffff558bec53 } /* Opcode */
		$op489 = { d0dc4200c7842484 } /* Opcode */
		$op490 = { ff90a8030000f7d81bc0f7d02345fc5f } /* Opcode */
		$op491 = { 80004300c7842494 } /* Opcode */
		$op492 = { 5150a1d8604400ff9004020000836508 } /* Opcode */
		$op493 = { 5933c03bfe5f5e0f94c05bc9c3558bec } /* Opcode */
		$op494 = { 3935046144000f859b } /* Opcode */
		$op495 = { 83c40c32c0ebdb837c240400750333c0 } /* Opcode */
		$op496 = { 68802c4300ff75f057ff902c03000083 } /* Opcode */
		$op497 = { 8b4f08988d048504 } /* Opcode */
		$op498 = { 98a44200c78424ec } /* Opcode */
		$op499 = { ac244400c78424dc } /* Opcode */
		$op500 = { 30e74200c78424a0 } /* Opcode */
		$op501 = { 895db0895db4ff9014040000bf340000 } /* Opcode */
		$op502 = { 5933c0395d0c5f5e0f94c05bc9c3558b } /* Opcode */
		$op503 = { 5933c0395d0c5f5e0f94c05bc9c3558b } /* Opcode */
		$op504 = { 83c40c5656566a016a0753568d45f450 } /* Opcode */
		$op505 = { 83c40c5656566a016a0753568d45f450 } /* Opcode */
		$op506 = { 84294400c78424a0 } /* Opcode */
		$op507 = { a1d8604400566800100000ff7508ff90 } /* Opcode */
		$op508 = { 874300c78424280a00000c874300c784 } /* Opcode */
		$op509 = { 59a1d860440056ff903c020000a1d860 } /* Opcode */
		$op510 = { 33c0668944242c8d7c242eab66ab6840 } /* Opcode */
		$op511 = { 702b4400c78424e0 } /* Opcode */
		$op512 = { 598ac3ebaab301ebe8558bec83ec4456 } /* Opcode */
		$op513 = { e0104300c7842494 } /* Opcode */
		$op514 = { 83c40c5f5e5bc9c3cccc558bec83ec20 } /* Opcode */
		$op515 = { 83c41cebc333c08b4c24043b88089242 } /* Opcode */
		$op516 = { ff0500a04200381dea604400740da1d8 } /* Opcode */
		$op517 = { 64004300c784248c } /* Opcode */
		$op518 = { 60114300c78424b8 } /* Opcode */
		$op519 = { 895ddc895de0ff901404000085c00f85 } /* Opcode */
		$op520 = { 895ddc895de0ff901404000085c00f85 } /* Opcode */
		$op521 = { b8244400c78424e0 } /* Opcode */
		$op522 = { 895c2464895c2468ff901404000085c0 } /* Opcode */
		$op523 = { ff742414a1d8604400ff742414ff9000 } /* Opcode */
		$op524 = { c4104300c784248c } /* Opcode */
		$op525 = { 5f85c0740633c033d2c9c38b45e88b55 } /* Opcode */
		$op526 = { 90974300c78424e8 } /* Opcode */
		$op527 = { 4c274100c781a403000087094100c781 } /* Opcode */
		$op528 = { 88e84200c78424ec } /* Opcode */
		$op529 = { 5983f8027669a1d86044005368feff00 } /* Opcode */
		$op530 = { 83c41889458c837d8c000f8407040000 } /* Opcode */
		$op531 = { a1d86044008d5e0c6828c6430053ff90 } /* Opcode */
		$op532 = { ff7508a1d8604400ff7308ff90ac0300 } /* Opcode */
		$op533 = { 66837938020f86d5 } /* Opcode */
		$op534 = { 94dd4200c78424b8 } /* Opcode */
		$op535 = { 83c414c60437008bc75f5ec3568b7424 } /* Opcode */
		$op536 = { 83c40c3bfb0f94c05e5f5bc9c3558bec } /* Opcode */
		$op537 = { a1d86044005657beff7f000056ff7508 } /* Opcode */
		$op538 = { a1d86044005657beff7f000056ff7508 } /* Opcode */
		$op539 = { 68a4454300ff7588a1d8604400ff9020 } /* Opcode */
		$op540 = { 0f8260ffffffa1d86044006820214400 } /* Opcode */
		$op541 = { 8b45fc8d048603433a50a1d8604400ff } /* Opcode */
		$op542 = { 84244400c78424d0 } /* Opcode */
		$op543 = { f0114300c78424e0 } /* Opcode */
		$op544 = { 0c974300c78424c0 } /* Opcode */
		$op545 = { 282a4400c78424b4 } /* Opcode */
		$op546 = { 83c8ffe95c010000836508008d450850 } /* Opcode */
		$op547 = { 7c524300c78424c8 } /* Opcode */
		$op548 = { 34524300c78424bc } /* Opcode */
		$op549 = { d8e64200c784248c } /* Opcode */
		$op550 = { 98114300c78424c8 } /* Opcode */
		$op551 = { 68b8404300ff75b8a1d8604400ff9020 } /* Opcode */
		$op552 = { 7ce84200c78424e8 } /* Opcode */
		$op553 = { 8b0dd8604400536689450aff91e8 } /* Opcode */
		$op554 = { 598d44000250ff75108d45f46a026a00 } /* Opcode */
		$op555 = { 598d44000250ff75108d45f46a026a00 } /* Opcode */
		$op556 = { 20de4200c78424e0 } /* Opcode */
		$op557 = { 59803de2604400007443a1d860440057 } /* Opcode */
		$op558 = { 8b45088b50183bca0f82270100008b40 } /* Opcode */
		$op559 = { 83c41ca1d860440053ff7508ff909001 } /* Opcode */
		$op560 = { 1c014300c78424b0 } /* Opcode */
		$op561 = { e986feffffa1d86044005357685ca042 } /* Opcode */
		$op562 = { d4534300c78424f8 } /* Opcode */
		$op563 = { 0ca34200c7842488 } /* Opcode */
		$op564 = { 8b7d0ceb2550a1d8604400ff90e8 } /* Opcode */
		$op565 = { 8b5dfc3bde75053975f4747b33c03bde } /* Opcode */
		$op566 = { 598d4400028945f4ff7508a1d8604400 } /* Opcode */
		$op567 = { 8b48048945f8b80010000083c40c3945 } /* Opcode */
		$op568 = { ff750c50a1d8604400ff90c403000059 } /* Opcode */
		$op569 = { 817c2414102700000f8fcc } /* Opcode */
		$op570 = { ff75e8a1d8604400ff75ecff7508ff50 } /* Opcode */
		$op571 = { a1a890420089818c020000a1dc904200 } /* Opcode */
		$op572 = { 24a34200c784248c } /* Opcode */
		$op573 = { 28524300c78424b8 } /* Opcode */
		$op574 = { 84514300c784249c } /* Opcode */
		$op575 = { a1d860440033db536838234400685823 } /* Opcode */
		$op576 = { 34114300c78424ac } /* Opcode */
		$op577 = { f0dc4200c7842490 } /* Opcode */
		$op578 = { 6888454300ff7588a1d8604400ff9020 } /* Opcode */
		$op579 = { 8b44242483c00450ff7508e830bfffff } /* Opcode */
		$op580 = { 83c41803c050ff75ec8b45e853ff1050 } /* Opcode */
		$op581 = { ff90480200005f85c0740432c0c9c38b } /* Opcode */
		$op582 = { ff90a00300008bf08d45fc50a1d86044 } /* Opcode */
		$op583 = { 59a1d86044006a0468dcb3430068e8b3 } /* Opcode */
		$op584 = { 5c974300c78424d4 } /* Opcode */
		$op585 = { 70014300c78424c0 } /* Opcode */
		$op586 = { 6a228d45ec50ff757ca1d8604400c745 } /* Opcode */
		$op587 = { 8b55fc8b4f3a0500f0ffff83c410ff45 } /* Opcode */
		$op588 = { d8294400c78424a8 } /* Opcode */
		$op589 = { c7812801000020ca4000c78118030000 } /* Opcode */
		$op590 = { 83c40c8d45dc5068000104008d45fc50 } /* Opcode */
		$op591 = { e4e74200c78424c8 } /* Opcode */
		$op592 = { 895de0895de4ff90140400008bf881ff } /* Opcode */
		$op593 = { 595985c075e38b45e08946288b4608ff } /* Opcode */
		$op594 = { a1d860440083c448ff7604ff75fc5368 } /* Opcode */
		$op595 = { dc964300c78424b4 } /* Opcode */
		$op596 = { 6848f24300ff75fcff91500300008b0d } /* Opcode */
		$op597 = { 515350a1d860440057ff90700100008b } /* Opcode */
		$op598 = { b8e84200c78424f8 } /* Opcode */
		$op599 = { 14a44200c78424bc } /* Opcode */
		$op600 = { 689c444300ff7588a1d8604400ff9020 } /* Opcode */
		$op601 = { 7e4300c7842484070000087e4300c784 } /* Opcode */
		$op602 = { 3c964300c7842488 } /* Opcode */
		$op603 = { 94de4200c78424f8 } /* Opcode */
		$op604 = { 50a1d86044005356ff900c040000ff75 } /* Opcode */
		$op605 = { 3e834100c781400100006a664100c781 } /* Opcode */
		$op606 = { 60e84200c78424e0 } /* Opcode */
		$op607 = { 79fe4000a104904200898100030000c7 } /* Opcode */
		$op608 = { 7ca34200c784249c } /* Opcode */
		$op609 = { ff90140400003d220000c075408d4424 } /* Opcode */
		$op610 = { 68974300c78424d8 } /* Opcode */
		$op611 = { 58244400c78424c0 } /* Opcode */
		$op612 = { 83c410a1d86044005756ff74241cff90 } /* Opcode */
		$op613 = { 83c428ff74240ca1d86044005653ff90 } /* Opcode */
		$op614 = { a1d860440068c821440056ff90f0 } /* Opcode */
		$op615 = { 8975e48975e88975fcff901404000085 } /* Opcode */
		$op616 = { 68ac414300ff75b8a1d8604400ff9020 } /* Opcode */
		$op617 = { 50a1d8604400ff900403000084c0a1d8 } /* Opcode */
		$op618 = { ff902404000059598d45e050a1d86044 } /* Opcode */
		$op619 = { 8975ec8975f0ff90a80300005f5e85c0 } /* Opcode */
		$op620 = { 8975ec8975f0ff90a80300005f5e85c0 } /* Opcode */
		$op621 = { 83c41485c0740cc7461003 } /* Opcode */
		$op622 = { 85c0740583c8ffeb088b45e889461433 } /* Opcode */
		$op623 = { 50dd4200c78424a4 } /* Opcode */
		$op624 = { 895dbc895dfcff90800300003bc30f84 } /* Opcode */
		$op625 = { c4524300c78424d4 } /* Opcode */
		$op626 = { f8504300c7842484 } /* Opcode */
		$op627 = { c0e64200c7842484 } /* Opcode */
		$op628 = { a4014300c78424d4 } /* Opcode */
		$op629 = { b4e74200c78424bc } /* Opcode */
		$op630 = { a1d860440057ff7508ff90900100008b } /* Opcode */
		$op631 = { 33ff83c4103bc7743b8b5b3a8b4d0c03 } /* Opcode */
		$op632 = { a19c904200c781000200008d9d4100c7 } /* Opcode */
		$op633 = { 68a84000c7812c0400008a5b4100c781 } /* Opcode */
		$op634 = { 6a06bf10f3430057894df0ff90400200 } /* Opcode */
		$op635 = { fc244400c78424f4 } /* Opcode */
		$op636 = { 5959837df8007505e982 } /* Opcode */
		$op637 = { 082b4400c78424d4 } /* Opcode */
		$op638 = { 33c03bfb590f94c05f5e5bc9c3558bec } /* Opcode */
		$op639 = { a8a34200c78424a4 } /* Opcode */
		$op640 = { 08de4200c78424dc } /* Opcode */
		$op641 = { 28dd4200c784249c } /* Opcode */
		$op642 = { d4244400c78424e8 } /* Opcode */
		$op643 = { 5933ffeb1fff75100fb7450c50a1d860 } /* Opcode */
		$op644 = { a1d860440057ff7508ff909001000083 } /* Opcode */
		$op645 = { a1d860440057ff7508ff909001000083 } /* Opcode */
		$op646 = { e4a34200c78424b0 } /* Opcode */
		$op647 = { ff7518ff75145753ff90b0 } /* Opcode */
		$op648 = { 1ca44200c78424c0 } /* Opcode */
		$op649 = { 8d8500feffff689869430068ff } /* Opcode */
		$op650 = { a3594000c7814404000014864100c781 } /* Opcode */
		$op651 = { 598b0685c0740e50ff7608e8b7ffffff } /* Opcode */
		$op652 = { a1d860440056ff9068010000a1d86044 } /* Opcode */
		$op653 = { 897424688974246cff905001000085c0 } /* Opcode */
		$op654 = { f8014300c78424ec } /* Opcode */
		$op655 = { 83c40ceb2aff7308508d471450a1d860 } /* Opcode */
		$op656 = { 83c41084db7510a1d8604400682cfe42 } /* Opcode */
		$op657 = { 8b450cff742414668378023f50a1d860 } /* Opcode */
		$op658 = { 24e84200c78424d4 } /* Opcode */
		$op659 = { 595f5e8ac35bc9c3558bec83ec1ca1d8 } /* Opcode */
		$op660 = { e0014300c78424e4 } /* Opcode */
		$op661 = { 83c40c5e5b5fc9c3558bec5151a1d860 } /* Opcode */
		$op662 = { fc004300c78424a8 } /* Opcode */
		$op663 = { eb16ff71080fbfca83c04c5150a1d860 } /* Opcode */
		$op664 = { 88964300c78424a0 } /* Opcode */
		$op665 = { cce64200c7842488 } /* Opcode */
		$op666 = { 83c40c5f33c05e5dc38b4c24040fbe41 } /* Opcode */
		$op667 = { b8014300c78424d8 } /* Opcode */
		$op668 = { 6868f24300ff75fcff91500300008b0d } /* Opcode */
		$op669 = { 8b433a8b4dfc8d048803c650a1d86044 } /* Opcode */
		$op670 = { ea4200c784243c01000010ea4200c784 } /* Opcode */
		$op671 = { 83c42085ff750433c0eb4b8b763a8d44 } /* Opcode */
		$op672 = { 24a44200c78424c4 } /* Opcode */
		$op673 = { 83c40cff7588ff7508a1d8604400ff90 } /* Opcode */
		$op674 = { 7c2a4400c78424c0 } /* Opcode */
		$op675 = { 8b4300c78424540b00000c8b4300c784 } /* Opcode */
		$op676 = { 50a1d860440057681cb14300682cb143 } /* Opcode */
		$op677 = { f8234400c7842494 } /* Opcode */
		$op678 = { 808d45f850a1d86044006a00ff902001 } /* Opcode */
		$op679 = { 8b463a03c350a1d8604400ff90780200 } /* Opcode */
		$op680 = { ff7608a1d8604400ff901c0100008bd8 } /* Opcode */
		$op681 = { ff45fc817dfc102700000f8ffb } /* Opcode */
		$op682 = { 740ac7050461440006 } /* Opcode */
		$op683 = { 7a4300c784245c0600001c7a4300c784 } /* Opcode */
		$op684 = { 94004300c7842498 } /* Opcode */
		$op685 = { 9c4300c784243c0200000c9c4300c784 } /* Opcode */
		$op686 = { a1d86044006a006828c84300ff7508ff } /* Opcode */
		$op687 = { 70524300c78424c4 } /* Opcode */
		$op688 = { d6e94000c781b801000076d14000c781 } /* Opcode */
		$op689 = { 598d440002506844c743006a016a008d } /* Opcode */
		$op690 = { 598d440002508b442434576840474400 } /* Opcode */
		$op691 = { a1d860440057ff7508ff9090010000ff } /* Opcode */
		$op692 = { 88dd4200c78424b4 } /* Opcode */
		$op693 = { 50a1d86044005668005043005653ff90 } /* Opcode */
		$op694 = { 98534300c78424ec } /* Opcode */
		$op695 = { 8b44240c83c04468dc68430050a1d860 } /* Opcode */
		$op696 = { 5068000010808d44245050a1d8604400 } /* Opcode */
		$op697 = { 98014300c78424d0 } /* Opcode */
		$op698 = { 3c014300c78424b8 } /* Opcode */
		$op699 = { 9c514300c78424a0 } /* Opcode */
		$op700 = { 59ff75e8ff7508a1d8604400ff909001 } /* Opcode */
		$op701 = { e9aafeffffa1d86044006a006affff50 } /* Opcode */
		$op702 = { ff742414a1d8604400ff7508ff903404 } /* Opcode */
		$op703 = { bbd03f00003bf36a010f8e9f } /* Opcode */
		$op704 = { 2cde4200c78424e4 } /* Opcode */
		$op705 = { 28114300c78424a8 } /* Opcode */
		$op706 = { 38a34200c7842490 } /* Opcode */
		$op707 = { 38a44200c78424cc } /* Opcode */
		$op708 = { 682c43440050a1d860440053ff902c03 } /* Opcode */
		$op709 = { f8dc4200c7842494 } /* Opcode */
		$op710 = { ff0500a04200a2c3604400a1d8604400 } /* Opcode */
		$op711 = { 68b0444300ff7588a1d8604400ff9020 } /* Opcode */
		$op712 = { 50ff750ca1d860440057ff9094 } /* Opcode */
		$op713 = { 242b4400c78424d8 } /* Opcode */
		$op714 = { 833dfc60440000750ac705fc6044006c } /* Opcode */
		$op715 = { 68a34200c7842498 } /* Opcode */
		$op716 = { cce74200c78424c4 } /* Opcode */
		$op717 = { 83c41485c00f8440feffffc7461004 } /* Opcode */
		$op718 = { 83c40c8d34463b5d1474024646433b5d } /* Opcode */
		$op719 = { e0a34200c78424ac } /* Opcode */
		$op720 = { 8b75108b363bf30f8d92 } /* Opcode */
		$op721 = { e8014300c78424e8 } /* Opcode */
		$op722 = { 38024300c78424fc } /* Opcode */
		$op723 = { 0c524300c78424b4 } /* Opcode */
		$op724 = { 60e74200c78424ac } /* Opcode */
		$op725 = { d8dc4200c7842488 } /* Opcode */
		$op726 = { 3c244400c78424b4 } /* Opcode */
		$op727 = { 6a2f8d45b850ff757ca1d8604400c745 } /* Opcode */
		$op728 = { 6683780a3a0f85b6 } /* Opcode */
		$op729 = { b0534300c78424f0 } /* Opcode */
		$op730 = { 68c8414300ff75b8a1d8604400ff9020 } /* Opcode */
		$op731 = { 44124300c78424f8 } /* Opcode */
		$op732 = { 78244400c78424cc } /* Opcode */
		$op733 = { 8d8500feffff686c69430068ff } /* Opcode */
		$op734 = { 7c014300c78424c4 } /* Opcode */
		$op735 = { a1d86044005653ff909001000083c41c } /* Opcode */
		$op736 = { 65fb4000c7811402000051624100c781 } /* Opcode */
		$op737 = { ff751050ff7508a1d8604400ff902c03 } /* Opcode */
		$op738 = { ff75f88d431050ff7508a1d8604400ff } /* Opcode */
		$op739 = { 8b55148b1285d20f8c1f0100000fbf70 } /* Opcode */
		$op740 = { 58024300c78424000100007c024300c7 } /* Opcode */
		$op741 = { 84014300c78424c8 } /* Opcode */
		$op742 = { 83c40c433b5d148d7446027cd233c066 } /* Opcode */
		$op743 = { 50a1d8604400ff90a402000083c41ceb } /* Opcode */
		$op744 = { 70dd4200c78424ac } /* Opcode */
		$op745 = { 7cdd4200c78424b0 } /* Opcode */
		$op746 = { ff742444894424588b44242c83c04450 } /* Opcode */
		$op747 = { 50a1d86044005768e4a743006814a943 } /* Opcode */
		$op748 = { cc2b4400c78424ec } /* Opcode */
		$op749 = { a4114300c78424cc } /* Opcode */
		$op750 = { 68f05a44008945f0578d45f050a1d860 } /* Opcode */
		$op751 = { 1f4400c7842490030000101f4400c784 } /* Opcode */
		$op752 = { 38294400c7842490 } /* Opcode */
		$op753 = { dc2b4400c78424f0 } /* Opcode */
		$op754 = { 9a4300c78424a8010000089a4300c784 } /* Opcode */
		$op755 = { 8b44242083c00450ff7508a1d8604400 } /* Opcode */
		$op756 = { 595f5ec9c3558bec83ec2c6a0b8d45d4 } /* Opcode */
		$op757 = { 598d44000250536a016a008d45ec50ff } /* Opcode */
		$op758 = { e4e84200c7842400010000fce84200c7 } /* Opcode */
		$op759 = { 8b75108b363bf20f8dd5 } /* Opcode */
		$op760 = { 8a44242783c4145f5e5b8be55dc3558b } /* Opcode */
		$op761 = { 8a44242783c4145f5e5b8be55dc3558b } /* Opcode */
		$op762 = { 08e84200c78424d0 } /* Opcode */
		$op763 = { 54004300c7842488 } /* Opcode */
		$op764 = { 8b45f40145f02945ec83c40cff45fc8b } /* Opcode */
		$op765 = { ece64200c7842490 } /* Opcode */
		$op766 = { 59a1d86044005653ff75f8ff90d40300 } /* Opcode */
		$op767 = { 59a1d8604400536808b3430056c745c8 } /* Opcode */
		$op768 = { 30a44200c78424c8 } /* Opcode */
		$op769 = { c4244400c78424e4 } /* Opcode */
		$op770 = { ff45fc817dfce80300000f8fac } /* Opcode */
		$op771 = { c4a34200c78424a8 } /* Opcode */
		$op772 = { e56d4100c781880200004e9e4100c781 } /* Opcode */
		$op773 = { 30964300c7842484 } /* Opcode */
		$op774 = { 0f8252ffffffa1d860440053ff7508ff } /* Opcode */
	condition:
		( uint16(0) == 0x5a4d and filesize < 900KB and ( 5 of ($s*) )and 1 of ($op*) ) or ( all of them )
}
