/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as    long as you use it under this license.

*/

import "pe"

rule LIGHTDART_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "ret.log" wide ascii
        $s2 = "Microsoft Internet Explorer 6.0" wide ascii
        $s3 = "szURL Fail" wide ascii
        $s4 = "szURL Successfully" wide ascii
        $s5 = "%s&sdate=%04ld-%02ld-%02ld" wide ascii

    condition:
        all of them
}

rule AURIGA_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "superhard corp." wide ascii
        $s2 = "microsoft corp." wide ascii
        $s3 = "[Insert]" wide ascii
        $s4 = "[Delete]" wide ascii
        $s5 = "[End]" wide ascii
        $s6 = "!(*@)(!@KEY" wide ascii
        $s7 = "!(*@)(!@SID=" wide ascii

    condition:
        all of them
}

rule AURIGA_driver_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Services\\riodrv32" wide ascii
        $s2 = "riodrv32.sys" wide ascii
        $s3 = "svchost.exe" wide ascii
        $s4 = "wuauserv.dll" wide ascii
        $s5 = "arp.exe" wide ascii
        $pdb = "projects\\auriga" wide ascii

    condition:
        all of ($s*) or $pdb
}

rule BANGAT_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "superhard corp." wide ascii
        $s2 = "microsoft corp." wide ascii
        $s3 = "[Insert]" wide ascii
        $s4 = "[Delete]" wide ascii
        $s5 = "[End]" wide ascii
        $s6 = "!(*@)(!@KEY" wide ascii
        $s7 = "!(*@)(!@SID=" wide ascii
        $s8 = "end      binary output" wide ascii
        $s9 = "XriteProcessMemory" wide ascii
        $s10 = "IE:Password-Protected sites" wide ascii
        $s11 = "pstorec.dll" wide ascii

    condition:
        all of them
}

rule BISCUIT_GREENCAT_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "zxdosml" wide ascii
        $s2 = "get user name error!" wide ascii
        $s3 = "get computer name error!" wide ascii
        $s4 = "----client system info----" wide ascii
        $s5 = "stfile" wide ascii
        $s6 = "cmd success!" wide ascii

    condition:
        all of them
}

rule BOUNCER_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "*Qd9kdgba33*%Wkda0Qd3kvn$*&><(*&%$E#%$#1234asdgKNAg@!gy565dtfbasdg" wide ascii
        $s2 = "IDR_DATA%d" wide ascii
        $s3 = "asdfqwe123cxz" wide ascii
        $s4 = "Mode must be 0(encrypt) or 1(decrypt)." wide ascii

    condition:
        ($s1 and $s2) or ($s3 and $s4)
}

rule BOUNCER_DLL_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "new_connection_to_bounce():" wide ascii
        $s2 = "usage:%s IP port [proxip] [port] [key]" wide ascii

    condition:
        all of them
}

rule CALENDAR_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
       
    strings:
        $s1 = "content" wide ascii
        $s2 = "title" wide ascii
        $s3 = "entry" wide ascii
        $s4 = "feed" wide ascii
        $s5 = "DownRun success" wide ascii
        $s6 = "%s@gmail.com" wide ascii
        $s7 = "<!--%s-->" wide ascii
        $b8 = "W4qKihsb+So=" wide ascii
        $b9 = "PoqKigY7ggH+VcnqnTcmhFCo9w==" wide ascii
        $b10 = "8oqKiqb5880/uJLzAsY=" wide ascii

    condition:
        all of ($s*) or all of ($b*)
}

rule COMBOS_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Mozilla4.0 (compatible; MSIE 7.0; Win32)" wide ascii
        $s2 = "Mozilla5.1 (compatible; MSIE 8.0; Win32)" wide ascii
        $s3 = "Delay" wide ascii
        $s4 = "Getfile" wide ascii
        $s5 = "Putfile" wide ascii
        $s6 = "---[ Virtual Shell]---" wide ascii
        $s7 = "Not Comming From Our Server %s." wide ascii

    condition:
        all of them
}

rule DAIRY_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Mozilla/4.0 (compatible; MSIE 7.0;)" wide ascii
        $s2 = "KilFail" wide ascii
        $s3 = "KilSucc" wide ascii
        $s4 = "pkkill" wide ascii
        $s5 = "pklist" wide ascii

    condition:
        all of them
}

rule GLOOXMAIL_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Kill process success!" wide ascii
        $s2 = "Kill process failed!" wide ascii
        $s3 = "Sleep success!" wide ascii
        $s4 = "based on gloox" wide ascii
        $pdb = "glooxtest.pdb" wide ascii

    condition:
        all of ($s*) or $pdb
}

rule GOGGLES_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Kill process success!" wide ascii
        $s2 = "Kill process failed!" wide ascii
        $s3 = "Sleep success!" wide ascii
        $s4 = "based on gloox" wide ascii
        $pdb = "glooxtest.pdb" wide ascii

    condition:
        all of ($s*) or $pdb
}

rule HACKSFASE1_APT1
{
    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = {cb 39 82 49 42 be 1f 3a}

    condition:
        all of them
}

rule HACKSFASE2_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Send to Server failed." wide ascii
        $s2 = "HandShake with the server failed. Error:" wide ascii
        $s3 = "Decryption Failed. Context Expired." wide ascii

    condition:
        all of them
}

rule KURTON_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Mozilla/4.0 (compatible; MSIE8.0; Windows NT 5.1)" wide ascii
        $s2 = "!(*@)(!@PORT!(*@)(!@URL" wide ascii
        $s3 = "MyTmpFile.Dat" wide ascii
        $s4 = "SvcHost.DLL.log" wide ascii

    condition:
        all of them
}

rule LONGRUN_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Mozilla/4.0 (compatible; Windows NT 5.1; MSIE 7.0; Trident/4.0)" wide ascii
        $s2 = "%s\\%c%c%c%c%c%c%c" wide ascii
        $s3 = "wait:" wide ascii
        $s4 = "Dcryption Error! Invalid Character" wide ascii

    condition:
        all of them
}

rule MACROMAIL_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "svcMsn.dll" wide ascii
        $s2 = "RundllInstall" wide ascii
        $s3 = "Config service %s ok." wide ascii
        $s4 = "svchost.exe" wide ascii

    condition:
        all of them
}

rule MANITSME_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Install an Service hosted by SVCHOST." wide ascii
        $s2 = "The Dll file that to be released." wide ascii
        $s3 = "SYSTEM\\CurrentControlSet\\Services\\" wide ascii
        $s4 = "svchost.exe" wide ascii
        $e1 = "Man,it's me" wide ascii
        $e2 = "Oh,shit" wide ascii
        $e3 = "Hallelujah" wide ascii
        $e4 = "nRet == SOCKET_ERROR" wide ascii
        $pdb1 = "rouji\\release\\Install.pdb" wide ascii
        $pdb2 = "rouji\\SvcMain.pdb" wide ascii

    condition:
        (all of ($s*)) or (all of ($e*)) or $pdb1 or $pdb2
}

rule MINIASP_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "miniasp" wide ascii
        $s2 = "wakeup=" wide ascii
        $s3 = "download ok!" wide ascii
        $s4 = "command is null!" wide ascii
        $s5 = "device_input.asp?device_t=" wide ascii

    condition:
        all of them
}

rule NEWSREELS_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "Mozilla/4.0 (compatible; Windows NT 5.1; MSIE 7.0)" wide ascii
        $s2 = "name=%s&userid=%04d&other=%c%s" wide ascii
        $s3 = "download ok!" wide ascii
        $s4 = "command is null!" wide ascii
        $s5 = "noclient" wide ascii
        $s6 = "wait" wide ascii
        $s7 = "active" wide ascii
        $s8 = "hello" wide ascii

    condition:
        all of them
}

rule SEASALT_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
      
    strings:
        $s1 = "User-Agent: Mozilla/4.0 (compatible; MSIE 5.00; Windows 98) KSMM" wide ascii
        $s2 = "upfileok" wide ascii
        $s3 = "download ok!" wide ascii
        $s4 = "upfileer" wide ascii
        $s5 = "fxftest" wide ascii

    condition:
        all of them
}

rule STARSYPOUND_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "*(SY)# cmd" wide ascii
        $s2 = "send = %d" wide ascii
        $s3 = "cmd.exe" wide ascii
        $s4 = "*(SY)#" wide ascii

    condition:
        all of them
}

rule SWORD_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
       
    strings:
        $s1 = "@***@*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@>>>" wide ascii
        $s2 = "sleep:" wide ascii
        $s3 = "down:" wide ascii
        $s4 = "*========== Bye Bye ! ==========*" wide ascii

    condition:
        all of them
}

rule thequickbrow_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "thequickbrownfxjmpsvalzydg" wide ascii

    condition:
        all of them
}

rule TABMSGSQL_APT1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "letusgohtppmmv2.0.0.1" wide ascii
        $s2 = "Mozilla/4.0 (compatible; )" wide ascii
        $s3 = "filestoc" wide ascii
        $s4 = "filectos" wide ascii
        $s5 = "reshell" wide ascii

    condition:
        all of them
}

rule CCREWBACK1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "postvalue" wide ascii
        $b = "postdata" wide ascii
        $c = "postfile" wide ascii
        $d = "hostname" wide ascii
        $e = "clientkey" wide ascii
        $f = "start Cmd Failure!" wide ascii
        $g = "sleep:" wide ascii
        $h = "downloadcopy:" wide ascii
        $i = "download:" wide ascii
        $j = "geturl:" wide ascii
        $k = "1.234.1.68" wide ascii

    condition:
        4 of ($a,$b,$c,$d,$e) or $f or 3 of ($g,$h,$i,$j) or $k
}

rule TrojanCookies_CCREW
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
     strings:
        $a = "sleep:" wide ascii
        $b = "content=" wide ascii
        $c = "reqpath=" wide ascii
        $d = "savepath=" wide ascii
        $e = "command=" wide ascii

    condition:
        4 of ($a,$b,$c,$d,$e)
}

rule GEN_CCREW1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "W!r@o#n$g" wide ascii
        $b = "KerNel32.dll" wide ascii

    condition:
        any of them
}

rule Elise
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
       
    strings:
        $a = "SetElise.pdb" wide ascii

    condition:
        $a
}

rule EclipseSunCloudRAT
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "Eclipse_A" wide ascii
        $b = "\\PJTS\\" wide ascii
        $c = "Eclipse_Client_B.pdb" wide ascii
        $d = "XiaoME" wide ascii
        $e = "SunCloud-Code" wide ascii
        $f = "/uc_server/data/forum.asp" wide ascii

    condition:
        any of them
}

rule MoonProject
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
       
    strings:
        $a = "Serverfile is smaller than Clientfile" wide ascii
        $b = "\\M tools\\" wide ascii
        $c = "MoonDLL" wide ascii
        $d = "\\M tools\\" wide ascii

  condition:
        any of them
}

rule ccrewDownloader1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = {DD B5 61 F0 20 47 20 57 D6 65 9C CB 31 1B 65 42}

    condition:
        any of them
}

rule ccrewDownloader2
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "3gZFQOBtY3sifNOl" wide ascii
        $b = "docbWUWsc2gRMv9HN7TFnvnKcrWUUFdAEem9DkqRALoD" wide ascii
        $c = "6QVSOZHQPCMc2A8HXdsfuNZcmUnIqWrOIjrjwOeagILnnScxadKEr1H2MZNwSnaJ" wide ascii

    condition:
        any of them
}

rule ccrewMiniasp
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        

  strings:
        $a = "MiniAsp.pdb" wide ascii
        $b = "device_t=" wide ascii

  condition:
        any of them
}

rule ccrewSSLBack2
{
    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = {39 82 49 42 BE 1F 3A}

    condition:
        any of them
}

rule ccrewSSLBack3
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "SLYHKAAY" wide ascii

  condition:
        any of them
}

rule ccrewSSLBack1
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "!@#%$^#@!" wide ascii
        $b = "64.91.80.6" wide ascii

  condition:
        any of them
}

rule ccrewDownloader3
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "ejlcmbv" wide ascii
        $b = "bhxjuisv" wide ascii
        $c = "yqzgrh" wide ascii
        $d = "uqusofrp" wide ascii
        $e = "Ljpltmivvdcbb" wide ascii
        $f = "frfogjviirr" wide ascii
        $g = "ximhttoskop" wide ascii

    condition:
        4 of them
}

rule ccrewQAZ
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "!QAZ@WSX" wide ascii

  condition:
        $a
}

rule metaxcd
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "<meta xcd=" wide ascii

    condition:
        $a
}

rule MiniASP
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $KEY = { 71 30 6E 63 39 77 38 65 64 61 6F 69 75 6B 32 6D 7A 72 66 79 33 78 74 31 70 35 6C 73 36 37 67 34 62 76 68 6A }
        $PDB = "MiniAsp.pdb" nocase wide ascii

    condition:
        any of them
}

rule DownloaderPossibleCCrew
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $a = "%s?%.6u" wide ascii
        $b = "szFileUrl=%s" wide ascii
        $c = "status=%u" wide ascii
        $d = "down file success" wide ascii
        $e = "Mozilla/4.0 (compatible; MSIE 6.0; Win32)" wide ascii

  condition:
        all of them
}

rule APT1_MAPIGET
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "%s\\Attachment.dat" wide ascii
        $s2 = "MyOutlook" wide ascii
        $s3 = "mail.txt" wide ascii
        $s4 = "Recv Time:" wide ascii
        $s5 = "Subject:" wide ascii

    condition:
       all of them
}

rule APT1_LIGHTBOLT
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $str1 = "bits.exe" wide ascii
        $str2 = "PDFBROW" wide ascii
        $str3 = "Browser.exe" wide ascii
        $str4 = "Protect!" wide ascii

    condition:
        2 of them
}

rule APT1_GETMAIL
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $stra1 = "pls give the FULL path" wide ascii
        $stra2 = "mapi32.dll" wide ascii
        $stra3 = "doCompress" wide ascii
        $strb1 = "getmail.dll" wide ascii
        $strb2 = "doCompress" wide ascii
        $strb3 = "love" wide ascii

    condition:
        all of ($stra*) or all of ($strb*)
}

rule APT1_GDOCUPLOAD
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $str1 = "name=\"GALX\"" wide ascii
        $str2 = "User-Agent: Shockwave Flash" wide ascii
        $str3 = "add cookie failed..." wide ascii
        $str4 = ",speed=%f" wide ascii

    condition:
        3 of them
}

rule APT1_WEBC2_Y21K
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "Y29ubmVjdA" wide ascii // connect
        $2 = "c2xlZXA" wide ascii // sleep
        $3 = "cXVpdA" wide ascii // quit
        $4 = "Y21k" wide ascii // cmd
        $5 = "dW5zdXBwb3J0" wide ascii // unsupport

    condition:
        4 of them
}

rule APT1_WEBC2_YAHOO
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $http1 = "HTTP/1.0" wide ascii
        $http2 = "Content-Type:" wide ascii
        $uagent = "IPHONE8.5(host:%s,ip:%s)" wide ascii

    condition:
        all of them
}

rule APT1_WEBC2_UGX
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $persis = "SOFTWARE\\MICROSOFT\\WINDOWS\\CURRENTVERSION\\RUN" wide ascii
        $exe = "DefWatch.exe" wide ascii
        $html = "index1.html" wide ascii
        $cmd1 = "!@#tiuq#@!" wide ascii
        $cmd2 = "!@#dmc#@!" wide ascii
        $cmd3 = "!@#troppusnu#@!" wide ascii

    condition:
        3 of them
}

rule APT1_WEBC2_TOCK
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "InprocServer32" wide ascii
        $2 = "HKEY_PERFORMANCE_DATA" wide ascii
        $3 = "<!---[<if IE 5>]id=" wide ascii

    condition:
        all of them
}

rule APT1_WEBC2_TABLE
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $msg1 = "Fail To Execute The Command" wide ascii
        $msg2 = "Execute The Command Successfully" wide ascii
        /*
    	$gif1 = /\w+\.gif/
    	*/
        $gif2 = "GIF89" wide ascii

    condition:
        3 of them
}

rule APT1_WEBC2_RAVE
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "iniet.exe" wide ascii
        $2 = "cmd.exe" wide ascii
        $3 = "SYSTEM\\CurrentControlSet\\Services\\DEVFS" wide ascii
        $4 = "Device File System" wide ascii

    condition:
        3 of them
}

rule APT1_WEBC2_QBP
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "2010QBP" wide ascii
        $2 = "adobe_sl.exe" wide ascii
        $3 = "URLDownloadToCacheFile" wide ascii
        $4 = "dnsapi.dll" wide ascii
        $5 = "urlmon.dll" wide ascii

    condition:
        4 of them
}

rule APT1_WEBC2_HEAD
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "Ready!" wide ascii
        $2 = "connect ok" wide ascii
        $3 = "WinHTTP 1.0" wide ascii
        $4 = "<head>" wide ascii

    condition:
        all of them
}

rule APT1_WEBC2_GREENCAT
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "reader_sl.exe" wide ascii
        $2 = "MS80547.bat" wide ascii
        $3 = "ADR32" wide ascii
        $4 = "ControlService failed!" wide ascii

    condition:
        3 of them
}

rule APT1_WEBC2_DIV
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "3DC76854-C328-43D7-9E07-24BF894F8EF5" wide ascii
        $2 = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Run" wide ascii
        $3 = "Hello from MFC!" wide ascii
        $4 = "Microsoft Internet Explorer" wide ascii

    condition:
        3 of them
}

rule APT1_WEBC2_CSON
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $httpa1 = "/Default.aspx?INDEX=" wide ascii
        $httpa2 = "/Default.aspx?ID=" wide ascii
        $httpb1 = "Win32" wide ascii
        $httpb2 = "Accept: text*/*" wide ascii
        $exe1 = "xcmd.exe" wide ascii
        $exe2 = "Google.exe" wide ascii

    condition:
        1 of ($exe*) and 1 of ($httpa*) and all of ($httpb*)
}

rule APT1_WEBC2_CLOVER
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $msg1 = "BUILD ERROR!" wide ascii
        $msg2 = "SUCCESS!" wide ascii
        $msg3 = "wild scan" wide ascii
        $msg4 = "Code too clever" wide ascii
        $msg5 = "insufficient lookahead" wide ascii
        $ua1 = "Mozilla/4.0 (compatible; MSIE 6.1; Windows NT 5.1; SV1)" wide ascii
        $ua2 = "Mozilla/5.0 (Windows; Windows NT 5.1; en-US; rv:1.8.0.12) Firefox/1.5.0.12" wide ascii

    condition:
        2 of ($msg*) and 1 of ($ua*)
}

rule APT1_WEBC2_BOLID
{
    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
      
    strings:
        $vm = "VMProtect" wide ascii
        $http = "http://[c2_location]/[page].html" wide ascii

    condition:
        all of them
}

rule APT1_WEBC2_ADSPACE
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "<!---HEADER ADSPACE style=" wide ascii
        $2 = "ERSVC.DLL" wide ascii

    condition:
        all of them
}

rule APT1_WEBC2_AUSOV
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "ntshrui.dll" wide ascii
        $2 = "%SystemRoot%\\System32\\" wide ascii
        $3 = "<!--DOCHTML" wide ascii
        $4 = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)" wide ascii
        $5 = "Ausov" wide ascii

    condition:
        4 of them
}

rule APT1_WARP
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $err1 = "exception..." wide ascii
        $err2 = "failed..." wide ascii
        $err3 = "opened..." wide ascii
        $exe1 = "cmd.exe" wide ascii
        $exe2 = "ISUN32.EXE" wide ascii

    condition:
        2 of ($err*) and all of ($exe*)
}

rule APT1_TARSIP_ECLIPSE
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $1 = "\\pipe\\ssnp" wide ascii
        $2 = "toobu.ini" wide ascii
        $3 = "Serverfile is not bigger than Clientfile" wide ascii
        $4 = "URL download success" wide ascii

    condition:
        3 of them
}

rule APT1_TARSIP_MOON
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $s1 = "\\XiaoME\\SunCloud-Code\\moon" wide ascii
        $s2 = "URL download success!" wide ascii
        $s3 = "Kugoosoft" wide ascii
        $msg1 = "Modify file failed!! So strange!" wide ascii
        $msg2 = "Create cmd process failed!" wide ascii
        $msg3 = "The command has not been implemented!" wide ascii
        $msg4 = "Runas success!" wide ascii
        $onec1 = "onec.php" wide ascii
        $onec2 = "/bin/onec" wide ascii

    condition:
        1 of ($s*) and 1 of ($msg*) and 1 of ($onec*)
}

/*
rule APT1_payloads
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"

    strings:
        $pay1 = "rusinfo.exe" wide ascii
        $pay2 = "cmd.exe" wide ascii
        $pay3 = "AdobeUpdater.exe" wide ascii
        $pay4 = "buildout.exe" wide ascii
        $pay5 = "DefWatch.exe" wide ascii
        $pay6 = "d.exe" wide ascii
        $pay7 = "em.exe" wide ascii
        $pay8 = "IMSCMig.exe" wide ascii
        $pay9 = "localfile.exe" wide ascii
        $pay10 = "md.exe" wide ascii
        $pay11 = "mdm.exe" wide ascii
        $pay12 = "mimikatz.exe" wide ascii
        $pay13 = "msdev.exe" wide ascii
        $pay14 = "ntoskrnl.exe" wide ascii
        $pay15 = "p.exe" wide ascii
        $pay16 = "otepad.exe" wide ascii
        $pay17 = "reg.exe" wide ascii
        $pay18 = "regsvr.exe" wide ascii
        $pay19 = "runinfo.exe" wide ascii
        $pay20 = "AdobeUpdate.exe" wide ascii
        $pay21 = "inetinfo.exe" wide ascii
        $pay22 = "svehost.exe" wide ascii
        $pay23 = "update.exe" wide ascii
        $pay24 = "NTLMHash.exe" wide ascii
        $pay25 = "wpnpinst.exe" wide ascii
        $pay26 = "WSDbg.exe" wide ascii
        $pay27 = "xcmd.exe" wide ascii
        $pay28 = "adobeup.exe" wide ascii
        $pay29 = "0830.bin" wide ascii
        $pay30 = "1001.bin" wide ascii
        $pay31 = "a.bin" wide ascii
        $pay32 = "ISUN32.EXE" wide ascii
        $pay33 = "AcroRD32.EXE" wide ascii
        $pay34 = "INETINFO.EXE" wide ascii

    condition:
        1 of them
}
*/

rule APT1_RARSilent_EXE_PDF
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $winrar1 = "WINRAR.SFX" wide ascii
        $str2 = "Steup=" wide ascii

    condition:
        all of them
}

rule APT1_aspnetreport
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $url = "aspnet_client/report.asp" wide ascii
        $param = "name=%s&Gender=%c&Random=%04d&SessionKey=%s" wide ascii
        $pay1 = "rusinfo.exe" wide ascii
        $pay2 = "cmd.exe" wide ascii
        $pay3 = "AdobeUpdater.exe" wide ascii
        $pay4 = "buildout.exe" wide ascii
        $pay5 = "DefWatch.exe" wide ascii
        $pay6 = "d.exe" wide ascii
        $pay7 = "em.exe" wide ascii
        $pay8 = "IMSCMig.exe" wide ascii
        $pay9 = "localfile.exe" wide ascii
        $pay10 = "md.exe" wide ascii
        $pay11 = "mdm.exe" wide ascii
        $pay12 = "mimikatz.exe" wide ascii
        $pay13 = "msdev.exe" wide ascii
        $pay14 = "ntoskrnl.exe" wide ascii
        $pay15 = "p.exe" wide ascii
        $pay16 = "otepad.exe" wide ascii
        $pay17 = "reg.exe" wide ascii
        $pay18 = "regsvr.exe" wide ascii
        $pay19 = "runinfo.exe" wide ascii
        $pay20 = "AdobeUpdate.exe" wide ascii
        $pay21 = "inetinfo.exe" wide ascii
        $pay22 = "svehost.exe" wide ascii
        $pay23 = "update.exe" wide ascii
        $pay24 = "NTLMHash.exe" wide ascii
        $pay25 = "wpnpinst.exe" wide ascii
        $pay26 = "WSDbg.exe" wide ascii
        $pay27 = "xcmd.exe" wide ascii
        $pay28 = "adobeup.exe" wide ascii
        $pay29 = "0830.bin" wide ascii
        $pay30 = "1001.bin" wide ascii
        $pay31 = "a.bin" wide ascii
        $pay32 = "ISUN32.EXE" wide ascii
        $pay33 = "AcroRD32.EXE" wide ascii
        $pay34 = "INETINFO.EXE" wide ascii

    condition:
        $url and $param and 1 of ($pay*)
}

rule APT1_Revird_svc
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $dll1 = "nwwwks.dll" wide ascii
        $dll2 = "rdisk.dll" wide ascii
        $dll3 = "skeys.dll" wide ascii
        $dll4 = "SvcHost.DLL.log" wide ascii
        $svc1 = "InstallService" wide ascii
        $svc2 = "RundllInstallA" wide ascii
        $svc3 = "RundllUninstallA" wide ascii
        $svc4 = "ServiceMain" wide ascii
        $svc5 = "UninstallService" wide ascii

    condition:
        1 of ($dll*) and 2 of ($svc*)
}

rule APT1_dbg_mess
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"
        
    strings:
        $dbg1 = "Down file ok!" wide ascii
        $dbg2 = "Send file ok!" wide ascii
        $dbg3 = "Command Error!" wide ascii
        $dbg4 = "Pls choose target first!" wide ascii
        $dbg5 = "Alert!" wide ascii
        $dbg6 = "Pls press enter to make sure!" wide ascii
        $dbg7 = "Are you sure to " wide ascii
        $pay1 = "rusinfo.exe" wide ascii
        $pay2 = "cmd.exe" wide ascii
        $pay3 = "AdobeUpdater.exe" wide ascii
        $pay4 = "buildout.exe" wide ascii
        $pay5 = "DefWatch.exe" wide ascii
        $pay6 = "d.exe" wide ascii
        $pay7 = "em.exe" wide ascii
        $pay8 = "IMSCMig.exe" wide ascii
        $pay9 = "localfile.exe" wide ascii
        $pay10 = "md.exe" wide ascii
        $pay11 = "mdm.exe" wide ascii
        $pay12 = "mimikatz.exe" wide ascii
        $pay13 = "msdev.exe" wide ascii
        $pay14 = "ntoskrnl.exe" wide ascii
        $pay15 = "p.exe" wide ascii
        $pay16 = "otepad.exe" wide ascii
        $pay17 = "reg.exe" wide ascii
        $pay18 = "regsvr.exe" wide ascii
        $pay19 = "runinfo.exe" wide ascii
        $pay20 = "AdobeUpdate.exe" wide ascii
        $pay21 = "inetinfo.exe" wide ascii
        $pay22 = "svehost.exe" wide ascii
        $pay23 = "update.exe" wide ascii
        $pay24 = "NTLMHash.exe" wide ascii
        $pay25 = "wpnpinst.exe" wide ascii
        $pay26 = "WSDbg.exe" wide ascii
        $pay27 = "xcmd.exe" wide ascii
        $pay28 = "adobeup.exe" wide ascii
        $pay29 = "0830.bin" wide ascii
        $pay30 = "1001.bin" wide ascii
        $pay31 = "a.bin" wide ascii
        $pay32 = "ISUN32.EXE" wide ascii
        $pay33 = "AcroRD32.EXE" wide ascii
        $pay34 = "INETINFO.EXE" wide ascii

    condition:
        4 of ($dbg*) and 1 of ($pay*)
}

rule APT1_known_malicious_RARSilent
{

    meta:
        author = "AlienVault Labs"
        info = "CommentCrew-threat-apt1"

    strings:
        $str1 = "Analysis And Outlook.doc" wide ascii
        $str2 = "North Korean launch.pdf" wide ascii
        $str3 = "Dollar General.doc" wide ascii
        $str4 = "Dow Corning Corp.pdf" wide ascii

    condition:
        1 of them and APT1_RARSilent_EXE_PDF
}
