/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as    long as you use it under this license.

*/
/*
ref : https://github.com/gwillem/magento-malware-scanner
author : https://github.com/gwillem

*/


rule onepage_or_checkout {
    strings: $ = "\\x6F\\x6E\\x65\\x70\\x61\\x67\\x65\\x7C\\x63\\x68\\x65\\x63\\x6B\\x6F\\x75\\x74"
    condition: any of them
}
rule sinlesspleasure_com {
    strings: $ = "5e908r948q9e605j8t9b915n5o9f8r5e5d969g9d795b4s6p8t9h9f978o8p8s9590936l6k8j9670524p7490915l5f8r90878t917f7g8p8o8p8k9c605i8d937t7m8i8q8o8q959h7p828e7r8e7q7e8m8o5g5e9199918o9g7q7c8c8t99905a5i8l94989h7r7g8i8t8m5f5o92917q7k9i9e948c919h925a5d8j915h608t8p8t9f937b7k9i9e948c919h92"
    condition: any of them
}
rule amasty_biz {
    strings: $ = "118,97,114,32,115,110,100,32,61,110,117,108,108,59,10,10,102,117"
    condition: any of them
}
rule amasty_biz_js {
    strings: $ = "t_p#0.qlb#0.#1Blsjj#1@#.?#.?dslargml#0.qr_pr#06#07#5@#.?#0"
    condition: any of them
}
rule returntosender {
    strings: $ = "\\x2F\\x6D\\x65\\x64\\x69\\x61\\x2F\\x63\\x61\\x74\\x61\\x6C\\x6F\\x67\\x2F\\x70\\x72\\x6F\\x64\\x75\\x63\\x74\\x2F\\x63\\x61\\x63\\x68\\x65\\x2F\\x31\\x2F\\x74\\x68\\x75\\x6D\\x62\\x6E\\x61\\x69\\x6C\\x2F\\x37\\x30\\x30\\x78\\x2F\\x32\\x62\\x66\\x38\\x66\\x32\\x62\\x38\\x64\\x30\\x32\\x38\\x63\\x63\\x65\\x39\\x36\\x2F\\x42\\x2F\\x57\\x2F\\x64\\x61\\x34\\x31\\x38\\x30\\x33\\x63\\x63\\x39\\x38\\x34\\x62\\x38\\x63\\x2E\\x70\\x68\\x70"
    condition: any of them
}
rule ip_5uu8_com {
    strings: $ = "\\x69\\x70\\x2e\\x35\\x75\\x75\\x38\\x2e\\x63\\x6f\\x6d"
    condition: any of them
}
rule cloudfusion_me {
    strings: $ = "&#99;&#108;&#111;&#117;&#100;&#102;&#117;&#115;&#105;&#111;&#110;&#46;&#109;&#101;"
    condition: any of them
}
rule grelos_v {
    strings: $ = "var grelos_v"
    condition: any of them
}
rule hacked_domains {
    strings: 
        $ = "infopromo.biz"
        $ = "jquery-code.su"
        $ = "jquery-css.su"
        $ = "megalith-games.com"
        $ = "cdn-cloud.pw"
        $ = "animalzz921.pw"
        $ = "statsdot.eu"
    condition: any of them
}
rule mage_cdn_link {
    strings: $ = "\\x6D\\x61\\x67\\x65\\x2D\\x63\\x64\\x6E\\x2E\\x6C\\x69\\x6E\\x6B"
    condition: any of them
}
rule credit_card_regex {
    strings: $ = "RegExp(\"[0-9]{13,16}\")"
    condition: any of them
}
rule jquery_code_su {
    strings: $ = "105,102,40,40,110,101,119,32,82,101,103,69,120,112,40,39,111,110,101,112,97,103,101"
    condition: any of them
}
rule jquery_code_su_multi {
    strings: $ = "=oQKpkyJ8dCK0lGbwNnLn42bpRXYj9GbENDft12bkBjM8V2Ypx2c8Rnbl52bw12bDlkUVVGZvNWZkZ0M85WavpGfsJXd8R1UPB1NywXZtFmb0N3box"
    condition: any of them
}
rule Trafficanalyzer_js {
    strings: $ = "z=x['length'];for(i=0;i<z;i++){y+=String['fromCharCode'](x['charCodeAt'](i)-10) }w=this['unescape'](y);this['eval'](w);"
    condition: any of them
}
rule atob_js {
    strings: $ = "this['eval'](this['atob']('"
    condition: any of them
}
rule gate_php_js {
    /* token=KjsS29Msl&host= */
    strings: 
		$ = /\/gate.php\?token=.{,10}&host=/
    condition: any of them
}
rule googieplay_js {
    strings: $ = "tdsjqu!tsd>#iuuq;00hpphjfqmbz/jogp0nbhfoup`hpphjfqmbz/kt#?=0tdsjqu?"
    condition: any of them
}
rule mag_php_js {
    strings: 
        $ = "onepage|checkout|onestep|firecheckout|onestepcheckout"
        $ = "'one|check'"
    condition: any of them
}
rule thetech_org_js {
    strings: $ = "|RegExp|onepage|checkout|"
    condition: any of them
}
rule md5_cdn_js_link_js {
    strings: $ = "grelos_v= null"
    condition: any of them
}
