/*
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html) and open to any user or organization, as    long as you use it under this license.

*/
rule Adwind_JAR_PACKA : binary 
{
 meta:
  author = "Vitaly Kamluk, Vitaly.Kamluk@kaspersky.com"
  reference = "https://securelist.com/securelist/files/2016/02/KL_AdwindPublicReport_2016.pdf"
  last_modified = "2015-11-30"
 strings:
  $b1 = ".class" ascii
  $b2 = "c/a/a/" ascii
  $b3 = "b/a/" ascii
  $b4 = "a.dat" ascii
  $b5 = "META-INF/MANIFEST.MF" ascii
 condition:
  int16(0) == 0x4B50 and ($b1 and $b2 and $b3 and $b4 and $b5)
}
