TEST_DICT = {
    "file_type": {"mime": "application/x-tar", "full": "POSIX tar archive (GNU)",
                  "summary": {"application/font-sfnt": [324], "application/gzip": ["well, that's compressed!"],
                              "application/octet-stream": [42], "application/pdf": ["nice document here"],
                              "application/x-archive": [42, 42, 42], "application/x-cpio": [13],
                              "application/x-executable": [123, 21],
                              "application/x-object": [1, 23, 56, 78, 3, 23, 67, 34, 1309, 35, 5454],
                              "application/x-sharedlib": [1, 2, 3, 4, 5], "application/x-tex-tfm": [42],
                              "audio/mpeg": ["nice song there."],
                              "compression/zlib": [1, 3, 5, 6, 3, 6, 4, 2, 5, 4, 21, 5, 7, 9, 5, 3],
                              "data/raw": ["hi there.", 1, 2, 3, 4, 5, 6, "wanna have some raw data?"],
                              "filesystem/dosmbr": [1, 2, 3, 44, 56, 67, 2],
                              "filesystem/squashfs": [1, 2, 3, 4, 5, 4, 5, 32, 6, 7, 89, 3],
                              "image/gif": [1, 2, 3, 4, 5, 6, 7, "gif time"], "image/png": ["boom. an image"],
                              "linux/avm-kernel-image-v1": ["some kernel data"],
                              "text/plain": [1, 2, 3, 4, 5, 6, "there was data"],
                              "video/mp4": ["there was a video"]}, "analysis_date": 1591092558.1460986,
                  "plugin_version": "1.0"},
    "crypto_material": {"summary": {"SSLCertificate": ["nothing to see here"]},
                        "analysis_date": 1591092560.042629, "plugin_version": "0.5.2",
                        "system_version": "3.7.1_1588174612"},
    "software_components": {
        "summary": {"BusyBox 1.24.2": [8], "Linux Kernel 2.6.39": [7], "OpenSSL 1.0.2r": [5], "hostapd 2.7": [3],
                    "libFLAC 1.3.2": [2], "wpa_supplicant 2.7": [1]}, "analysis_date": 1591092560.6536422,
        "plugin_version": "0.4.1", "system_version": "3.7.1_1588174612"},
    "exploit_mitigations": {"skipped": "blacklisted file type",
                            "summary": {"Canary disabled": [1, 2, 3, 4, 5], "Canary enabled": [6, 7, 8, 9],
                                        "FORTIFY_SOURCE disabled": [1, 2, 3],
                                        "FORTIFY_SOURCE enabled": [4, 5, 6, 7, 8, 9],
                                        "NX disabled": [1, 2, 3, 4], "NX enabled": [5, 6, 7, 8, 9],
                                        "PIE - invalid ELF file": [1, 2, 3, 4, 5, 6, 7, 8, 9],
                                        "RELRO disabled": [1, 2, 3, 4, 5], "RELRO fully enabled": [6, 7],
                                        "RELRO partially enabled": [8, 9]},
                            "analysis_date": 1591092560.9982054, "plugin_version": "0.1.2"},
    "cve_lookup": {"cve_results": {}, "summary": {"BusyBox 1.24.2 (CRITICAL)": ["dat data."],
                                                  "Linux Kernel 2.6.39 (CRITICAL)": ["some data"],
                                                  "OpenSSL 1.0.2r": ["also some data"],
                                                  "hostapd 2.7": ["data"], "wpa_supplicant 2.7": ["data"]},
                   "analysis_date": 1591092564.6739304, "plugin_version": "0.0.4"},
    "cpu_architecture": {
        "summary": {"ARM, 32-bit, big endian (M)": [1, 2, 3, 4, 5, 6, 7, 8, 9],
                    "x86, 32-bit, little endian (M)": [1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4,
                                                       5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 42]},
        "analysis_date": 1591092565.5146425, "plugin_version": "0.3.2"},
    "binwalk": {"signature_analysis": "some Binwalk output",
                "summary": {"something, that binwalk found": ["some data"]},
                "entropy_analysis_graph": "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",
                "analysis_date": 1592550893.563894, "plugin_version": "0.5.2"},
    "known_vulnerabilities": {"summary": {"BackDoor_String": ["here is some data"]},
                              "analysis_date": 1591092565.987832, "plugin_version": "0.2",
                              "system_version": "3.7.1_1588174612"}
}

META_DICT = {
    "device_name": "A devices name",
    "device_class": "Router",
    "device_part": "",
    "vendor": "a vendor",
    "version": "version 42.13",
    "release_date": "1970-01-01",
    "hid": "some specs",
    "size": 2315412323,
    "number_of_included_files": 21,
    "included_files": [1, 2, 3, 4, 5, 6, 7],
    "total_files_in_firmware": 12
}
